/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.FileExistsException;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.InvalidHandleException;
import com.sshtools.common.sftp.SftpExtension;
import com.sshtools.common.sftp.SftpExtensionFactory;
import com.sshtools.common.sftp.SftpFile;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpOperationWrapper;
import com.sshtools.common.sftp.SftpSpecification;
import com.sshtools.common.sftp.SftpStatusEventException;
import com.sshtools.common.sftp.SftpSubsystemOperation;
import com.sshtools.common.sftp.TransferEvent;
import com.sshtools.common.sftp.UnsupportedFileOperationException;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.common.ssh.SessionChannelHelper;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.Subsystem;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import com.sshtools.common.util.Version;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SftpSubsystem
extends Subsystem
implements SftpSpecification {
    private AbstractFileSystem nfs;
    private List<SftpOperationWrapper> wrappers = new ArrayList<SftpOperationWrapper>();
    private SshConnection con;
    private boolean nfsClosed = false;
    int writeBlockSize = 4096;
    static final int SFTP_QUEUE = Integer.MAX_VALUE;
    static final int MAX_VERSION = 4;
    public static final String SUBSYSTEM_NAME = "sftp";
    int version;
    private String CHARSET_ENCODING;
    private FileSystemPolicy filePolicy = new FileSystemPolicy();
    private Map<String, TransferEvent> openFileHandles = new ConcurrentHashMap<String, TransferEvent>(8, 0.9f, 1);
    private Map<String, TransferEvent> openFolderHandles = new ConcurrentHashMap<String, TransferEvent>(8, 0.9f, 1);
    private Map<Context, Set<String>> openFilesByContext = new ConcurrentHashMap<Context, Set<String>>(8, 0.9f, 1);

    public SftpSubsystem() {
        super(SUBSYSTEM_NAME);
    }

    @Override
    public void init(SessionChannel session, Context context) throws IOException, PermissionDeniedException {
        super.init(session, context);
        this.filePolicy = context.getPolicy(FileSystemPolicy.class);
        this.con = session.getConnection();
        try {
            "1234567890".getBytes(this.filePolicy.getSFTPCharsetEncoding());
            this.CHARSET_ENCODING = this.filePolicy.getSFTPCharsetEncoding();
        }
        catch (UnsupportedEncodingException ex) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)(this.filePolicy.getSFTPCharsetEncoding() + " is not a supported character set encoding. Defaulting to ISO-8859-1"), (Object[])new Object[0]);
            }
            this.CHARSET_ENCODING = "ISO-8859-1";
        }
        AbstractFileFactory<?> ff = this.filePolicy.getFileFactory().getFileFactory(session.getConnection());
        if (this.filePolicy.getFileFactory() instanceof SftpOperationWrapper) {
            this.addWrapper((SftpOperationWrapper)((Object)ff));
        }
        this.executeOperation(Integer.MAX_VALUE, new InitOperation());
        session.addEventListener(new ChannelEventListener(){

            @Override
            public void onChannelClosing(Channel channel) {
                SessionChannelHelper.sendExitStatus(channel, 0);
            }
        });
    }

    @Override
    protected void cleanupSubsystem() {
        if (!this.nfsClosed) {
            long started = System.currentTimeMillis();
            ArrayList<byte[]> fileHandles = new ArrayList<byte[]>();
            ArrayList<byte[]> dirHandles = new ArrayList<byte[]>();
            for (TransferEvent evt : this.openFileHandles.values()) {
                fileHandles.add(evt.handle);
            }
            for (TransferEvent evt : this.openFolderHandles.values()) {
                dirHandles.add(evt.handle);
            }
            this.fireEvent(new Event((Object)this, -16777118, true).addAttribute("OPEN_FILE_HANDLES", fileHandles).addAttribute("OPEN_DIR_HANDLES", dirHandles).addAttribute("CONNECTION", this.con));
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Cleaning up SFTP subsystem", (Object[])new Object[0]);
            }
            this.cleanupOpenFiles();
            if (this.nfs != null) {
                this.nfs.closeFilesystem();
            }
            this.nfsClosed = true;
            this.fireEvent(new Event((Object)this, -16777135, true).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", System.currentTimeMillis()).addAttribute("CONNECTION", this.con));
        }
    }

    @Override
    protected void onSubsystemFree() {
    }

    @Override
    protected void onMessageReceived(byte[] msg) throws IOException {
        switch (msg[0] & 0xFF) {
            case 1: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_INIT", (Object[])new Object[0]);
                }
                this.onInitialize(msg);
                break;
            }
            case 14: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_MKDIR", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new MakeDirectoryOperation(msg));
                break;
            }
            case 16: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_REALPATH", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new RealPathOperation(msg));
                break;
            }
            case 11: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_OPENDIR", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new OpenDirectoryOperation(msg));
                break;
            }
            case 3: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_OPEN", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new OpenFileOperation(msg));
                break;
            }
            case 5: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_READ", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new ReadFileOperation(msg));
                break;
            }
            case 6: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_WRITE", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new WriteFileOperation(msg));
                break;
            }
            case 12: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_READDIR", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new ReadDirectoryOperation(msg));
                break;
            }
            case 7: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_LSTAT", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new LStatOperation(msg));
                break;
            }
            case 17: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_STAT", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new StatOperation(msg));
                break;
            }
            case 8: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_FSTAT", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new FStatOperation(msg));
                break;
            }
            case 4: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_CLOSE", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new CloseFileOperation(msg));
                break;
            }
            case 13: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_REMOVE", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new RemoveFileOperation(msg));
                break;
            }
            case 18: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_RENAME", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new RenameFileOperation(msg));
                break;
            }
            case 15: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_RMDIR", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new RemoveDirectoryOperation(msg));
                break;
            }
            case 9: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_SETSTAT", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new SetStatOperation(msg));
                break;
            }
            case 10: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_FSETSTAT", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new SetFStatOperation(msg));
                break;
            }
            case 19: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_READLINK", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new ReadlinkOperation(msg));
                break;
            }
            case 20: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_SYMLINK", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new SymlinkOperation(msg));
                break;
            }
            case 200: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Processing SSH_FXP_EXTENDED", (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new ExtendedOperation(msg));
                break;
            }
            default: {
                block22: for (SftpExtensionFactory fact : this.getContext().getPolicy(FileSystemPolicy.class).getSFTPExtensionFactories()) {
                    for (SftpExtension ext : fact.getExtensions()) {
                        if (!ext.supportsExtendedMessage(msg[0])) continue;
                        this.executeOperation(Integer.MAX_VALUE, new ExtendedMessageOperation(msg, ext));
                        continue block22;
                    }
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Processing Unsupported Message id=" + msg[0]), (Object[])new Object[0]);
                }
                this.executeOperation(Integer.MAX_VALUE, new UnsupportedOperation(msg));
            }
        }
    }

    protected void fireStatEvent(String path, SftpFileAttributes old, SftpFileAttributes attrs, Date started, Exception error) {
        this.fireEvent(new Event((Object)this, -16777125, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", path).addAttribute("OLD_ATTR", old).addAttribute("NEW_ATTR", attrs).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    protected void fireSymlinkEvent(String linkpath, String targetpath, Date started, Exception error) {
        this.fireEvent(new Event((Object)this, -16777130, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", linkpath).addAttribute("FILE_TARGET", targetpath).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    protected void fireRmDirEvent(String path, Date started, Exception error) {
        this.fireEvent(new Event((Object)this, -16777133, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    protected void fireRenameFileEvent(String oldpath, String newpath, Date started, Exception error) {
        this.fireEvent(new Event((Object)this, -16777132, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", oldpath).addAttribute("FILE_NEW_NAME", newpath).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    protected void fireRemoveFileEvent(String path, Date started, Exception error) {
        this.fireEvent(new Event((Object)this, -16777131, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    protected void fireOpenFileEvent(UnsignedInteger32 flags, SftpFileAttributes attrs, String path, Date started, byte[] handle, Exception error) {
        if ((flags.longValue() & 1L) != 1L && ((flags.longValue() & 2L) == 2L || (flags.longValue() & 4L) == 4L)) {
            this.fireEvent(new Event((Object)this, -16777122, error).addAttribute("CONNECTION", this.con).addAttribute("NEW_ATTR", attrs).addAttribute("HANDLE", handle).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
        } else if ((flags.longValue() & 1L) == 1L && (flags.longValue() & 2L) != 2L && (flags.longValue() & 4L) != 4L) {
            this.fireEvent(new Event((Object)this, -16777123, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", path).addAttribute("HANDLE", handle).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
        } else {
            this.fireEvent(new Event((Object)this, -16777121, error).addAttribute("CONNECTION", this.con).addAttribute("HANDLE", handle).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
        }
    }

    protected void fireOpenInitEvent(UnsignedInteger32 flags, SftpFileAttributes attrs, String path, Date started, Exception error) {
        if ((flags.longValue() & 1L) != 1L && ((flags.longValue() & 2L) == 2L || (flags.longValue() & 4L) == 4L)) {
            this.fireEvent(new Event((Object)this, -16777116, error).addAttribute("CONNECTION", this.con).addAttribute("NEW_ATTR", attrs).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
        } else if ((flags.longValue() & 1L) == 1L && (flags.longValue() & 2L) != 2L && (flags.longValue() & 4L) != 4L) {
            this.fireEvent(new Event((Object)this, -16777117, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
        } else {
            this.fireEvent(new Event((Object)this, -16777115, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
        }
    }

    public void sendHandleMessage(int id, byte[] handle) throws IOException {
        Packet reply = new Packet(handle.length + 9);
        reply.write(102);
        reply.writeInt(id);
        reply.writeBinaryString(handle);
        this.sendMessage(reply);
    }

    protected void fireCloseFileEvent(byte[] handle, Exception error) {
        String key = new String(handle);
        if (this.openFileHandles.containsKey(key)) {
            TransferEvent evt = this.openFileHandles.remove(key);
            this.fireCloseFileEvent(evt, error);
            this.openFileHandles.remove(key);
            this.openFilesByContext.get(this.getContext()).remove(key);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"There are now {} file(s) open in the current context", (Object[])new Object[]{this.openFilesByContext.get(this.getContext()).size()});
            }
        } else if (this.openFolderHandles.containsKey(key)) {
            TransferEvent evt = this.openFolderHandles.remove(key);
            this.fireCloseFileEvent(evt, error);
            this.openFolderHandles.remove(key);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void fireCloseFileEvent(TransferEvent evt, Exception error) {
        if (evt == null) return;
        if (!evt.error && error != null) {
            evt.error = true;
        }
        if (evt.error && this.getContext().getPolicy(FileSystemPolicy.class).isSFTPCloseFileBeforeFailedTransferEvents()) {
            try {
                this.nfs.closeFile(evt.handle);
            }
            catch (InvalidHandleException invalidHandleException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (evt.isDir) {
            this.fireEvent(new Event((Object)this, -16777124, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesWritten)).addAttribute("FILE_NAME", evt.path).addAttribute("HANDLE", evt.handle).addAttribute("OP_STARTED", evt.started).addAttribute("OP_FINISHED", new Date()));
            return;
        }
        if (evt.bytesWritten > 0L && evt.bytesRead <= 0L) {
            this.fireEvent(new Event((Object)this, -16777129, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesWritten)).addAttribute("FILE_NAME", evt.path).addAttribute("HANDLE", evt.handle).addAttribute("OP_STARTED", evt.started).addAttribute("OP_FINISHED", new Date()));
            return;
        }
        if (evt.bytesRead > 0L && evt.bytesWritten <= 0L) {
            this.fireEvent(new Event((Object)this, -16777128, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesRead)).addAttribute("HANDLE", evt.handle).addAttribute("FILE_NAME", evt.path).addAttribute("OP_STARTED", evt.started).addAttribute("OP_FINISHED", new Date()));
            return;
        }
        if (evt.bytesRead <= 0L && evt.bytesWritten <= 0L && (evt.flags.longValue() & 1L) != 1L && ((evt.flags.longValue() & 2L) == 2L || (evt.flags.longValue() & 4L) == 4L)) {
            if (this.context.getPolicy(FileSystemPolicy.class).isAllowZeroLengthFileUpload() || evt.exists) {
                this.fireEvent(new Event((Object)this, -16777127, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_READ", new Long(evt.bytesRead)).addAttribute("BYTES_WRITTEN", new Long(evt.bytesWritten)).addAttribute("HANDLE", evt.handle).addAttribute("FILE_NAME", evt.path).addAttribute("OP_STARTED", evt.started).addAttribute("OP_FINISHED", new Date()));
                return;
            }
            try {
                this.nfs.removeFile(evt.path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fireEvent(new Event((Object)this, -16777127, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_READ", new Long(evt.bytesRead)).addAttribute("BYTES_WRITTEN", new Long(evt.bytesWritten)).addAttribute("HANDLE", evt.handle).addAttribute("FILE_NAME", evt.path).addAttribute("OP_STARTED", evt.started).addAttribute("OP_FINISHED", new Date()));
            throw new SftpStatusEventException(4, "Zero length file is not allowed");
        }
        if (evt.bytesRead <= 0L && evt.bytesWritten <= 0L && (evt.flags.longValue() & 1L) == 1L && (evt.flags.longValue() & 2L) != 2L && (evt.flags.longValue() & 4L) != 4L) {
            this.fireEvent(new Event((Object)this, -16777128, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesRead)).addAttribute("FILE_NAME", evt.path).addAttribute("HANDLE", evt.handle).addAttribute("OP_STARTED", evt.started).addAttribute("OP_FINISHED", new Date()));
            return;
        } else {
            this.fireEvent(new Event((Object)this, -16777126, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_READ", new Long(evt.bytesRead)).addAttribute("BYTES_WRITTEN", new Long(evt.bytesWritten)).addAttribute("FILE_NAME", evt.path).addAttribute("HANDLE", evt.handle).addAttribute("OP_STARTED", evt.started).addAttribute("OP_FINISHED", new Date()));
        }
    }

    public void sendAttributesMessage(int id, SftpFileAttributes attrs) throws IOException {
        byte[] encoded = attrs.toByteArray(this.version);
        Packet msg = new Packet(5 + encoded.length);
        msg.write(105);
        msg.writeInt(id);
        msg.write(encoded);
        this.sendMessage(msg);
    }

    protected void fireOpenDirectoryEvent(String path, Date started, byte[] handle, Exception error) {
        this.fireEvent(new Event((Object)this, -16777124, error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(0L)).addAttribute("HANDLE", handle).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    @Override
    public void sendStatusMessage(int id, int reason, String description) {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Sending SSH_FXP_STATUS: : " + description + " reason=" + reason), (Object[])new Object[0]);
        }
        try {
            Packet baw = new Packet(1024);
            baw.write(101);
            baw.writeInt(id);
            baw.writeInt(reason);
            if (this.version > 2) {
                baw.writeString(description, this.CHARSET_ENCODING);
                baw.writeString("");
            }
            this.sendMessage(baw);
        }
        catch (IOException ex) {
            this.session.close();
        }
    }

    private String formatLongnameInContext(SftpFile file, Locale locale) {
        return this.formatLongnameInContext(file.getAttributes(), file.getFilename(), locale);
    }

    private String formatLongnameInContext(SftpFileAttributes attrs, String filename, Locale locale) {
        StringBuffer str = new StringBuffer();
        str.append(SftpSubsystem.pad(10 - attrs.getPermissionsString().length()) + attrs.getPermissionsString());
        if (attrs.isDirectory()) {
            str.append(" 1 ");
        } else {
            str.append(" 1 ");
        }
        if (attrs.hasUID()) {
            str.append(attrs.getUID() + SftpSubsystem.pad(8 - attrs.getUID().length()));
        } else {
            str.append(String.valueOf(attrs.getUID()) + SftpSubsystem.pad(8 - String.valueOf(attrs.getUID()).length()));
        }
        str.append(" ");
        if (attrs.hasGID()) {
            str.append(attrs.getGID() + SftpSubsystem.pad(8 - attrs.getGID().length()));
        } else {
            str.append(String.valueOf(attrs.getGID()) + SftpSubsystem.pad(8 - String.valueOf(attrs.getGID()).length()));
        }
        str.append(" ");
        str.append(SftpSubsystem.pad(11 - attrs.getSize().toString().length()) + attrs.getSize().toString());
        str.append(" ");
        String modTime = this.getModTimeStringInContext(attrs.getModifiedTime(), locale);
        str.append(SftpSubsystem.pad(12 - modTime.length()) + modTime);
        str.append(" ");
        str.append(filename);
        return str.toString();
    }

    private String getModTimeStringInContext(UnsignedInteger64 mtime, Locale locale) {
        if (mtime == null) {
            return "";
        }
        long mt = mtime.longValue() * 1000L;
        long now = System.currentTimeMillis();
        SimpleDateFormat df = now - mt > 15552000000L ? new SimpleDateFormat(this.getContext().getPolicy(FileSystemPolicy.class).getSFTPLongnameDateFormat(), locale) : new SimpleDateFormat(this.getContext().getPolicy(FileSystemPolicy.class).getSFTPLongnameDateFormatWithTime(), locale);
        return df.format(new Date(mt));
    }

    private static String pad(int num) {
        String str = "";
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                str = str + " ";
            }
        }
        return str;
    }

    public void sendFilenameMessage(int id, SftpFile[] files, boolean isRealPath, boolean isAbsolute) throws IOException {
        Packet baw = new Packet(4096);
        baw.write(104);
        baw.writeInt(id);
        baw.writeInt(files.length);
        for (int i = 0; i < files.length; ++i) {
            baw.writeString(isAbsolute ? files[i].getAbsolutePath() : files[i].getFilename(), this.CHARSET_ENCODING);
            if (this.version <= 3) {
                baw.writeString(isRealPath ? files[i].getAbsolutePath() : this.formatLongnameInContext(files[i], this.con.getLocale()), this.CHARSET_ENCODING);
            }
            baw.write(files[i].getAttributes().toByteArray(this.version));
        }
        this.sendMessage(baw);
    }

    protected void fireMakeDirectoryEvent(String path, Date started, Exception error) {
        this.fireEvent(new Event((Object)this, -16777134, error).addAttribute("CONNECTION", this.con).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    public String checkDefaultPath(String path) throws IOException, PermissionDeniedException {
        if (path.equals("")) {
            return this.nfs.getDefaultPath();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInitialize(byte[] msg) throws IOException {
        try {
            int theirVersion = (int)ByteArrayReader.readInt((byte[])msg, (int)1);
            int ourVersion = this.context.getPolicy(FileSystemPolicy.class).getSFTPVersion();
            this.version = Math.min(theirVersion, ourVersion);
            Packet packet = new Packet(5);
            packet.write(2);
            packet.writeInt(this.version);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Negotiated SFTP version " + this.version + " [server=" + ourVersion + " client=" + theirVersion + "]"), (Object[])new Object[0]);
            }
            if (this.version > 3) {
                packet.writeString("newline");
                packet.writeString(System.getProperty("line.separator"));
            } else {
                packet.writeString("newline@vandyke.com");
                packet.writeString(System.getProperty("line.separator"));
            }
            packet.writeString("vendor-id");
            try (ByteArrayWriter writer = new ByteArrayWriter();){
                writer.writeString("JADAPTIVE Limited");
                writer.writeString("Maverick Synergy");
                writer.writeString(Version.getVersion());
                writer.writeUINT64(new UnsignedInteger64(0L));
                packet.writeBinaryString(writer.toByteArray());
            }
            for (SftpExtensionFactory factory : this.context.getPolicy(FileSystemPolicy.class).getSFTPExtensionFactories()) {
                for (SftpExtension ext : factory.getExtensions()) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"SFTP supports extension {}", (Object[])new Object[]{ext.getName()});
                    }
                    if (!ext.isDeclaredInVersion()) continue;
                    packet.writeString(ext.getName());
                    packet.writeBinaryString(ext.getDefaultData());
                }
            }
            this.sendMessage(packet);
        }
        finally {
            this.onFreeMessage(msg);
        }
    }

    public void fireEvent(Event event) {
        if (this.nfs != null) {
            this.nfs.populateEvent(event);
        }
        EventServiceImplementation.getInstance().fireEvent(event);
    }

    private void cleanupOpenFiles() {
        Iterator<TransferEvent> it = this.openFileHandles.values().iterator();
        SshException ex = new SshException("The connection has closed", 12);
        while (it.hasNext()) {
            TransferEvent evt = it.next();
            evt.error = true;
            try {
                this.fireCloseFileEvent(evt, (Exception)ex);
            }
            catch (SftpStatusEventException sftpStatusEventException) {
                // empty catch block
            }
            this.openFilesByContext.get(this.getContext()).remove(evt.key);
        }
        this.openFileHandles.clear();
        for (TransferEvent evt : this.openFolderHandles.values()) {
            evt.error = true;
            try {
                this.fireCloseFileEvent(evt, (Exception)ex);
            }
            catch (SftpStatusEventException sftpStatusEventException) {}
        }
        this.openFolderHandles.clear();
    }

    @Override
    public AbstractFileSystem getFileSystem() {
        return this.nfs;
    }

    public void submitTask(Runnable runnable) {
    }

    public void addWrapper(SftpOperationWrapper wrapper) {
        this.wrappers.add(wrapper);
    }

    public void removeWrapper(SftpOperationWrapper wrapper) {
        this.wrappers.remove(wrapper);
    }

    public String getCharsetEncoding() {
        return this.CHARSET_ENCODING;
    }

    public void addTransferEvent(String handle, TransferEvent evt) {
        if (evt.isDir()) {
            this.openFolderHandles.put(handle, evt);
        } else {
            this.openFileHandles.put(handle, evt);
        }
    }

    static /* synthetic */ SessionChannel access$1300(SftpSubsystem x0) {
        return x0.session;
    }

    abstract class FileSystemOperation
    extends ConnectionAwareTask {
        protected byte[] msg;

        FileSystemOperation(byte[] msg) {
            super(SftpSubsystem.this.session.getConnection());
            this.msg = msg;
        }

        public abstract void doOperation();

        public abstract SftpSubsystemOperation getOp();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doTask() {
            if (!SftpSubsystem.this.wrappers.isEmpty()) {
                for (SftpOperationWrapper wrapper : SftpSubsystem.this.wrappers) {
                    try {
                        wrapper.onBeginOperation(SftpSubsystem.this.session, this.getOp());
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                this.doOperation();
            }
            finally {
                if (!SftpSubsystem.this.wrappers.isEmpty()) {
                    for (SftpOperationWrapper wrapper : SftpSubsystem.this.wrappers) {
                        try {
                            wrapper.onEndOperation(SftpSubsystem.this.session, this.getOp());
                        }
                        catch (Throwable throwable) {}
                    }
                }
                if (this.msg != null) {
                    SftpSubsystem.this.onFreeMessage(this.msg);
                }
                this.msg = null;
            }
        }
    }

    class MakeDirectoryOperation
    extends FileSystemOperation {
        MakeDirectoryOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.MAKE_DIRECTORY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            Date started = new Date();
            String path = null;
            SftpFileAttributes attrs = null;
            try {
                boolean exists;
                id = (int)bar.readInt();
                path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                if (bar.available() > 0) {
                    attrs = new SftpFileAttributes(bar, SftpSubsystem.this.version, SftpSubsystem.this.CHARSET_ENCODING);
                }
                if (!(exists = SftpSubsystem.this.nfs.fileExists(path)) && SftpSubsystem.this.nfs.makeDirectory(path, attrs)) {
                    try {
                        SftpSubsystem.this.fireMakeDirectoryEvent(path, started, null);
                        SftpSubsystem.this.sendStatusMessage(id, 0, "The operation completed sucessfully");
                    }
                    catch (SftpStatusEventException ex) {
                        SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                    }
                } else {
                    try {
                        SftpSubsystem.this.fireMakeDirectoryEvent(path, started, exists ? new FileExistsException() : new IOException("The operation failed."));
                        SftpSubsystem.this.sendStatusMessage(id, exists ? 11 : 4, "The operation failed");
                    }
                    catch (SftpStatusEventException ex) {
                        SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                    }
                }
                return;
            }
            catch (FileExistsException fe) {
                SftpSubsystem.this.fireMakeDirectoryEvent(path, started, fe);
                SftpSubsystem.this.sendStatusMessage(id, 4, "File already exists");
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.fireMakeDirectoryEvent(path, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireMakeDirectoryEvent(path, started, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            catch (IOException ioe) {
                SftpSubsystem.this.fireMakeDirectoryEvent(path, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class RealPathOperation
    extends FileSystemOperation {
        RealPathOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.RESOLVE_PATH;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            try (ByteArrayReader bar = new ByteArrayReader(this.msg);){
                bar.skip(1L);
                int id = (int)bar.readInt();
                String path = bar.readString(SftpSubsystem.this.CHARSET_ENCODING);
                try {
                    String realpath = SftpSubsystem.this.nfs.getRealPath(SftpSubsystem.this.checkDefaultPath(path));
                    SftpFile file = new SftpFile(realpath, SftpSubsystem.this.nfs.getFileAttributes(realpath));
                    SftpSubsystem.this.sendFilenameMessage(id, new SftpFile[]{file}, true, true);
                }
                catch (FileNotFoundException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, 2, ex.getMessage());
                }
                catch (PermissionDeniedException ioe) {
                    SftpSubsystem.this.sendStatusMessage(id, 3, ioe.getMessage());
                }
            }
        }
    }

    class OpenDirectoryOperation
    extends FileSystemOperation {
        OpenDirectoryOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.OPEN_DIRECTORY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            Date started = new Date();
            int id = -1;
            String path = null;
            try {
                id = (int)bar.readInt();
                path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                TransferEvent evt = new TransferEvent();
                evt.nfs = SftpSubsystem.this.nfs;
                evt.isDir = true;
                evt.started = new Date();
                evt.path = path;
                byte[] handle = SftpSubsystem.this.nfs.openDirectory(path);
                try {
                    SftpSubsystem.this.fireOpenDirectoryEvent(path, started, handle, null);
                    SftpSubsystem.this.openFolderHandles.put(new String(handle), evt);
                    SftpSubsystem.this.sendHandleMessage(id, handle);
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
                return;
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.fireOpenDirectoryEvent(path, started, null, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.fireOpenDirectoryEvent(path, started, null, ioe2);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireOpenDirectoryEvent(path, started, null, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class ReadDirectoryOperation
    extends FileSystemOperation {
        ReadDirectoryOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.READ_DIRECTORY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            try {
                id = (int)bar.readInt();
                SftpSubsystem.this.sendFilenameMessage(id, SftpSubsystem.this.nfs.readDirectory(bar.readBinaryString()), false, false);
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (InvalidHandleException ihe) {
                SftpSubsystem.this.sendStatusMessage(id, 4, ihe.getMessage());
            }
            catch (EOFException eof) {
                SftpSubsystem.this.sendStatusMessage(id, 1, eof.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            catch (PermissionDeniedException e) {
                SftpSubsystem.this.sendStatusMessage(id, 3, e.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class LStatOperation
    extends FileSystemOperation {
        LStatOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.GET_ATTRIBUTES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            try {
                id = (int)bar.readInt();
                String path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                if (SftpSubsystem.this.nfs.fileExists(path)) {
                    SftpSubsystem.this.sendAttributesMessage(id, SftpSubsystem.this.nfs.getFileAttributes(path));
                } else {
                    SftpSubsystem.this.sendStatusMessage(id, 2, path + " is not a valid file path");
                }
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (PermissionDeniedException ioe) {
                SftpSubsystem.this.sendStatusMessage(id, 3, ioe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class StatOperation
    extends FileSystemOperation {
        StatOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.GET_ATTRIBUTES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            try {
                id = (int)bar.readInt();
                String path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                if (SftpSubsystem.this.nfs.fileExists(path)) {
                    SftpSubsystem.this.sendAttributesMessage(id, SftpSubsystem.this.nfs.getFileAttributes(path));
                } else {
                    SftpSubsystem.this.sendStatusMessage(id, 2, path + " is not a valid file path");
                }
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (PermissionDeniedException ioe) {
                SftpSubsystem.this.sendStatusMessage(id, 3, ioe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class FStatOperation
    extends FileSystemOperation {
        FStatOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.GET_ATTRIBUTES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            try {
                id = (int)bar.readInt();
                SftpSubsystem.this.sendAttributesMessage(id, SftpSubsystem.this.nfs.getFileAttributes(bar.readBinaryString()));
            }
            catch (InvalidHandleException ihe) {
                SftpSubsystem.this.sendStatusMessage(id, 4, ihe.getMessage());
            }
            catch (PermissionDeniedException ihe) {
                SftpSubsystem.this.sendStatusMessage(id, 3, ihe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class CloseFileOperation
    extends FileSystemOperation {
        CloseFileOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.CLOSE_HANDLE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            byte[] handle = null;
            try {
                id = (int)bar.readInt();
                handle = bar.readBinaryString();
                SftpSubsystem.this.nfs.closeFile(handle);
                try {
                    SftpSubsystem.this.fireCloseFileEvent(handle, null);
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The operation completed");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
            }
            catch (InvalidHandleException ihe) {
                SftpSubsystem.this.fireCloseFileEvent(handle, (Exception)ihe);
                SftpSubsystem.this.sendStatusMessage(id, 4, ihe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.fireCloseFileEvent(handle, (Exception)ioe2);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class UnsupportedOperation
    extends FileSystemOperation {
        UnsupportedOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.UNSUPPORTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Unsupported SFTP message received [id=" + this.msg[0] + "]"), (Object[])new Object[0]);
            }
            try (ByteArrayReader bar = new ByteArrayReader(this.msg);){
                bar.skip(1L);
                int id = -1;
                try {
                    id = (int)bar.readInt();
                    SftpSubsystem.this.sendStatusMessage(id, 8, "Unexpected message id " + this.msg[0]);
                }
                catch (IOException e) {
                    Log.error((String)"Failed to read message id", (Throwable)e, (Object[])new Object[0]);
                    this.con.disconnect("I/O error during read operation");
                }
            }
        }
    }

    class WriteFileOperation
    extends FileSystemOperation {
        WriteFileOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.WRITE_FILE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            TransferEvent evt = null;
            Date started = new Date();
            try {
                id = (int)bar.readInt();
                byte[] handle = bar.readBinaryString();
                String h = new String(handle);
                evt = (TransferEvent)SftpSubsystem.this.openFileHandles.get(h);
                UnsignedInteger64 offset = bar.readUINT64();
                int count = (int)bar.readInt();
                if (SftpSubsystem.this.filePolicy.hasUploadQuota()) {
                    Long quota;
                    if (!this.con.containsProperty("uploadQuota")) {
                        this.con.setProperty("uploadQuota", new Long(0L));
                    }
                    if ((quota = (Long)this.con.getProperty("uploadQuota")) + (long)count > SftpSubsystem.this.filePolicy.getConnectionUploadQuota()) {
                        SftpSubsystem.this.sendStatusMessage(id, 15, "User upload quota exceeded");
                        return;
                    }
                    this.con.setProperty("uploadQuota", new Long(quota + (long)count));
                }
                try {
                    SftpSubsystem.this.nfs.writeFile(handle, offset, bar.array(), bar.getPosition(), count);
                    evt.bytesWritten += (long)count;
                    if (SftpSubsystem.this.context.getPolicy(FileSystemPolicy.class).isSFTPReadWriteEvents()) {
                        SftpSubsystem.this.fireEvent(new Event((Object)SftpSubsystem.this, -16777119, !evt.error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesWritten)).addAttribute("BYTES_WRITTEN", new Long(count)).addAttribute("FILE_NAME", evt.path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
                    }
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The write completed successfully");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
                return;
            }
            catch (InvalidHandleException ihe) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = ihe;
                }
                SftpSubsystem.this.sendStatusMessage(id, 4, ihe.getMessage());
            }
            catch (PermissionDeniedException e) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = e;
                }
                SftpSubsystem.this.sendStatusMessage(id, 3, e.getMessage());
            }
            catch (FileNotFoundException ioe2) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = ioe2;
                }
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe2.getMessage());
            }
            catch (IOException ioe2) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = ioe2;
                }
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            finally {
                bar.close();
            }
            if (evt != null && evt.error && SftpSubsystem.this.context.getPolicy(FileSystemPolicy.class).isSFTPReadWriteEvents()) {
                SftpSubsystem.this.fireEvent(new Event((Object)SftpSubsystem.this, -16777119, !evt.error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesWritten)).addAttribute("FILE_NAME", evt.path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("THROWABLE", evt.ex));
            }
        }
    }

    class ReadFileOperation
    extends FileSystemOperation {
        ReadFileOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.READ_FILE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            TransferEvent evt = null;
            Date started = new Date();
            try {
                id = (int)bar.readInt();
                byte[] handle = bar.readBinaryString();
                String h = new String(handle);
                evt = (TransferEvent)SftpSubsystem.this.openFileHandles.get(h);
                UnsignedInteger64 offset = bar.readUINT64();
                int count = (int)bar.readInt();
                Packet reply = new Packet(count + 13);
                try {
                    reply.write(103);
                    reply.writeInt(id);
                    int position = reply.position();
                    reply.writeInt(0);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Remote client wants " + String.valueOf(count) + " bytes from file at offset " + offset.toString() + " localwindow=" + SftpSubsystem.this.session.getLocalWindow() + " remotewindow=" + SftpSubsystem.this.session.getRemoteWindow()), (Object[])new Object[0]);
                    }
                    if ((count = SftpSubsystem.this.nfs.readFile(handle, offset, reply.array(), reply.position(), count)) == -1) {
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Got EOF from filesystem", (Object[])new Object[0]);
                        }
                        evt.hasReachedEOF = true;
                        SftpSubsystem.this.sendStatusMessage(id, 1, "File is EOF");
                        return;
                    }
                    evt.bytesRead += (long)count;
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Read " + count + " bytes from filesystem"), (Object[])new Object[0]);
                    }
                    position = reply.setPosition(position);
                    reply.writeInt(count);
                    reply.setPosition(position + count);
                    try {
                        if (SftpSubsystem.this.context.getPolicy(FileSystemPolicy.class).isSFTPReadWriteEvents()) {
                            SftpSubsystem.this.fireEvent(new Event((Object)SftpSubsystem.this, -16777120, !evt.error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesRead)).addAttribute("BYTES_READ", new Long(count)).addAttribute("FILE_NAME", evt.path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
                        }
                        SftpSubsystem.this.sendMessage(reply);
                    }
                    catch (SftpStatusEventException ex) {
                        SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                    }
                }
                finally {
                    try {
                        reply.close();
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
            catch (EOFException eof) {
                SftpSubsystem.this.sendStatusMessage(id, 1, eof.getMessage());
            }
            catch (PermissionDeniedException e) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = e;
                }
                SftpSubsystem.this.sendStatusMessage(id, 3, e.getMessage());
            }
            catch (InvalidHandleException ihe) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = ihe;
                }
                SftpSubsystem.this.sendStatusMessage(id, 4, ihe.getMessage());
            }
            catch (FileNotFoundException ioe2) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = ioe2;
                }
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe2.getMessage());
            }
            catch (IOException ioe2) {
                if (evt != null) {
                    evt.error = true;
                    evt.ex = ioe2;
                }
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            finally {
                bar.close();
            }
            if (evt != null && evt.error && SftpSubsystem.this.context.getPolicy(FileSystemPolicy.class).isSFTPReadWriteEvents()) {
                SftpSubsystem.this.fireEvent(new Event((Object)SftpSubsystem.this, -16777120, !evt.error).addAttribute("CONNECTION", this.con).addAttribute("BYTES_TRANSFERED", new Long(evt.bytesRead)).addAttribute("FILE_NAME", evt.path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()).addAttribute("THROWABLE", evt.ex));
            }
        }
    }

    class OpenFileOperation
    extends FileSystemOperation {
        OpenFileOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.OPEN_FILE;
        }

        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            String path = "";
            UnsignedInteger32 flags = new UnsignedInteger32(0L);
            Date started = new Date();
            SftpFileAttributes attrs = null;
            try {
                Set openHandles;
                id = (int)bar.readInt();
                path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                flags = new UnsignedInteger32(bar.readInt());
                attrs = new SftpFileAttributes(bar, SftpSubsystem.this.version, SftpSubsystem.this.CHARSET_ENCODING);
                if (SftpSubsystem.this.getContext().getPolicy(FileSystemPolicy.class).getMaxConcurrentTransfers() > -1 && SftpSubsystem.this.openFilesByContext.containsKey(SftpSubsystem.this.getContext()) && (openHandles = (Set)SftpSubsystem.this.openFilesByContext.get(SftpSubsystem.this.getContext())).size() >= SftpSubsystem.this.getContext().getPolicy(FileSystemPolicy.class).getMaxConcurrentTransfers()) {
                    SftpSubsystem.this.fireOpenInitEvent(flags, attrs, path, started, new PermissionDeniedException("Maximum concurrent transfers exceeded for the current context"));
                    SftpSubsystem.this.sendStatusMessage(id, 3, "Maximum concurrent transfers exceeded for the current context");
                    return;
                }
                SftpSubsystem.this.fireOpenInitEvent(flags, attrs, path, started, null);
                boolean exists = false;
                try {
                    exists = SftpSubsystem.this.nfs.fileExists(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] handle = SftpSubsystem.this.nfs.openFile(path, flags, attrs);
                TransferEvent evt = new TransferEvent();
                evt.path = path;
                evt.nfs = SftpSubsystem.this.nfs;
                evt.handle = handle;
                evt.exists = exists;
                evt.flags = flags;
                evt.key = new String(handle);
                try {
                    SftpSubsystem.this.fireOpenFileEvent(flags, attrs, path, started, handle, null);
                    SftpSubsystem.this.openFileHandles.put(evt.key, evt);
                    if (!SftpSubsystem.this.openFilesByContext.containsKey(SftpSubsystem.this.getContext())) {
                        SftpSubsystem.this.openFilesByContext.put(SftpSubsystem.this.getContext(), new HashSet());
                    }
                    ((Set)SftpSubsystem.this.openFilesByContext.get(SftpSubsystem.this.getContext())).add(evt.key);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"There are now {} file(s) open in the current context", (Object[])new Object[]{((Set)SftpSubsystem.this.openFilesByContext.get(SftpSubsystem.this.getContext())).size()});
                    }
                    SftpSubsystem.this.sendHandleMessage(id, handle);
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                    try {
                        SftpSubsystem.this.nfs.closeFile(handle);
                    }
                    catch (InvalidHandleException invalidHandleException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.fireOpenFileEvent(flags, attrs, path, started, null, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.fireOpenFileEvent(flags, attrs, path, started, null, ioe2);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireOpenFileEvent(flags, attrs, path, started, null, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
        }
    }

    class RemoveFileOperation
    extends FileSystemOperation {
        RemoveFileOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.REMOVE_FILE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            String path = null;
            Date started = new Date();
            int id = -1;
            try {
                id = (int)bar.readInt();
                path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                SftpSubsystem.this.nfs.removeFile(path);
                try {
                    SftpSubsystem.this.fireRemoveFileEvent(path, started, null);
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The file was removed");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.fireRemoveFileEvent(path, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.fireRemoveFileEvent(path, started, ioe2);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireRemoveFileEvent(path, started, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class RenameFileOperation
    extends FileSystemOperation {
        RenameFileOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.RENAME_FILE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            Date started = new Date();
            String oldpath = null;
            String newpath = null;
            int id = -1;
            try {
                id = (int)bar.readInt();
                oldpath = bar.readString(SftpSubsystem.this.CHARSET_ENCODING);
                newpath = bar.readString(SftpSubsystem.this.CHARSET_ENCODING);
                SftpSubsystem.this.nfs.renameFile(SftpSubsystem.this.checkDefaultPath(oldpath), SftpSubsystem.this.checkDefaultPath(newpath));
                try {
                    SftpSubsystem.this.fireRenameFileEvent(oldpath, newpath, started, null);
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The file was renamed");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.fireRenameFileEvent(oldpath, newpath, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.fireRenameFileEvent(oldpath, newpath, started, ioe2);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireRenameFileEvent(oldpath, newpath, started, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class RemoveDirectoryOperation
    extends FileSystemOperation {
        RemoveDirectoryOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.REMOVE_DIRECTORY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            String path = null;
            Date started = new Date();
            int id = -1;
            try {
                id = (int)bar.readInt();
                path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                SftpSubsystem.this.nfs.removeDirectory(path);
                try {
                    SftpSubsystem.this.fireRmDirEvent(path, started, null);
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The directory was removed");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.fireRmDirEvent(path, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.fireRmDirEvent(path, started, ioe2);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireRmDirEvent(path, started, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class SymlinkOperation
    extends FileSystemOperation {
        SymlinkOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.CREATE_SYMLINK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            Date started = new Date();
            String linkpath = null;
            String targetpath = null;
            try {
                id = (int)bar.readInt();
                linkpath = bar.readString(SftpSubsystem.this.CHARSET_ENCODING);
                targetpath = bar.readString(SftpSubsystem.this.CHARSET_ENCODING);
                SftpSubsystem.this.nfs.createSymbolicLink(SftpSubsystem.this.checkDefaultPath(linkpath), SftpSubsystem.this.checkDefaultPath(targetpath));
                try {
                    SftpSubsystem.this.fireSymlinkEvent(linkpath, targetpath, started, null);
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The symbolic link was created");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.fireSymlinkEvent(linkpath, targetpath, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireSymlinkEvent(linkpath, targetpath, started, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.fireSymlinkEvent(linkpath, targetpath, started, ioe2);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            catch (UnsupportedFileOperationException uso) {
                SftpSubsystem.this.fireSymlinkEvent(linkpath, targetpath, started, uso);
                SftpSubsystem.this.sendStatusMessage(id, 8, uso.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class ReadlinkOperation
    extends FileSystemOperation {
        ReadlinkOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.FOLLOW_SYMLINK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            try {
                id = (int)bar.readInt();
                SftpFile[] files = new SftpFile[]{SftpSubsystem.this.nfs.readSymbolicLink(SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING)))};
                SftpSubsystem.this.sendFilenameMessage(id, files, false, true);
            }
            catch (FileNotFoundException ioe) {
                SftpSubsystem.this.sendStatusMessage(id, 2, ioe.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            catch (UnsupportedFileOperationException uso) {
                SftpSubsystem.this.sendStatusMessage(id, 8, uso.getMessage());
            }
            catch (IOException ioe2) {
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe2.getMessage());
            }
            finally {
                bar.close();
            }
        }
    }

    class SetFStatOperation
    extends FileSystemOperation {
        SetFStatOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.SET_ATTRIBUTES;
        }

        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            Date started = new Date();
            String path = null;
            SftpFileAttributes attrs = null;
            SftpFileAttributes old = null;
            try {
                id = (int)bar.readInt();
                byte[] handle = bar.readBinaryString();
                old = SftpSubsystem.this.nfs.getFileAttributes(handle);
                path = SftpSubsystem.this.nfs.getPathForHandle(handle);
                attrs = new SftpFileAttributes(bar, SftpSubsystem.this.version, SftpSubsystem.this.CHARSET_ENCODING);
                SftpSubsystem.this.nfs.setFileAttributes(handle, attrs);
                try {
                    SftpSubsystem.this.fireStatEvent(path, old, attrs, started, null);
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The attributes were set");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
            }
            catch (InvalidHandleException ihe) {
                SftpSubsystem.this.fireStatEvent(path, old, attrs, started, ihe);
                SftpSubsystem.this.sendStatusMessage(id, 4, ihe.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireStatEvent(path, old, attrs, started, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            catch (IOException ioe) {
                SftpSubsystem.this.fireStatEvent(path, old, attrs, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe.getMessage());
            }
        }
    }

    class SetStatOperation
    extends FileSystemOperation {
        SetStatOperation(byte[] msg) {
            super(msg);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.SET_ATTRIBUTES;
        }

        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            int id = -1;
            Date started = new Date();
            String path = null;
            SftpFileAttributes old = null;
            SftpFileAttributes attrs = null;
            try {
                id = (int)bar.readInt();
                path = SftpSubsystem.this.checkDefaultPath(bar.readString(SftpSubsystem.this.CHARSET_ENCODING));
                old = SftpSubsystem.this.nfs.getFileAttributes(path);
                attrs = new SftpFileAttributes(bar, SftpSubsystem.this.version, SftpSubsystem.this.CHARSET_ENCODING);
                SftpSubsystem.this.nfs.setFileAttributes(path, attrs);
                try {
                    SftpSubsystem.this.fireStatEvent(path, old, attrs, started, null);
                    SftpSubsystem.this.sendStatusMessage(id, 0, "The attributes were set");
                }
                catch (SftpStatusEventException ex) {
                    SftpSubsystem.this.sendStatusMessage(id, ex.getStatus(), ex.getMessage());
                }
            }
            catch (FileNotFoundException fnfe) {
                SftpSubsystem.this.fireStatEvent(path, old, attrs, started, fnfe);
                SftpSubsystem.this.sendStatusMessage(id, 2, fnfe.getMessage());
            }
            catch (PermissionDeniedException pde) {
                SftpSubsystem.this.fireStatEvent(path, old, attrs, started, pde);
                SftpSubsystem.this.sendStatusMessage(id, 3, pde.getMessage());
            }
            catch (IOException ioe) {
                SftpSubsystem.this.fireStatEvent(path, old, attrs, started, ioe);
                SftpSubsystem.this.sendStatusMessage(id, 4, ioe.getMessage());
            }
        }
    }

    class ExtendedOperation
    extends FileSystemOperation {
        ExtendedOperation(byte[] msg) {
            super(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation() {
            ByteArrayReader bar = new ByteArrayReader(this.msg);
            bar.skip(1L);
            try {
                int id = (int)bar.readInt();
                String requestName = bar.readString();
                SftpExtension ext = SftpSubsystem.this.getContext().getPolicy(FileSystemPolicy.class).getSFTPExtension(requestName);
                if (ext != null) {
                    ext.processMessage(bar, id, SftpSubsystem.this);
                } else {
                    SftpSubsystem.this.sendStatusMessage(id, 8, "Extensions not currently supported");
                }
            }
            catch (IOException iOException) {
            }
            finally {
                bar.close();
            }
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.EXTENDED;
        }
    }

    class ExtendedMessageOperation
    extends FileSystemOperation {
        SftpExtension ext;

        ExtendedMessageOperation(byte[] msg, SftpExtension ext) {
            super(msg);
            this.ext = ext;
        }

        @Override
        public void doOperation() {
            this.ext.processExtendedMessage(new ByteArrayReader(this.msg), SftpSubsystem.this);
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.EXTENDED;
        }
    }

    class InitOperation
    extends FileSystemOperation {
        InitOperation() {
            super(null);
        }

        @Override
        public void doOperation() {
            try {
                SftpSubsystem.this.nfs = new AbstractFileSystem(this.con, SftpSubsystem.SUBSYSTEM_NAME);
                SftpSubsystem.this.fireEvent(new Event((Object)SftpSubsystem.this, -16777136, true).addAttribute("CONNECTION", this.con));
            }
            catch (Throwable t) {
                try {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"An SFTP initialization error occurred", (Throwable)t, (Object[])new Object[0]);
                    }
                    SftpSubsystem.this.session.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public SftpSubsystemOperation getOp() {
            return SftpSubsystemOperation.INIT;
        }
    }
}

