/*
 * Decompiled with CFR 0.152.
 */
package com.srotya.minuteman.rocksdb;

import com.srotya.minuteman.cluster.WALManager;
import com.srotya.minuteman.cluster.WALManagerImpl;
import com.srotya.minuteman.connectors.AtomixConnector;
import com.srotya.minuteman.connectors.ClusterConnector;
import com.srotya.minuteman.rocksdb.RocksDBConfiguration;
import com.srotya.minuteman.rocksdb.RocksDBWALClient;
import com.srotya.minuteman.rocksdb.api.RockApi;
import io.dropwizard.Application;
import io.dropwizard.setup.Environment;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.rocksdb.CompressionType;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDBCluster
extends Application<RocksDBConfiguration> {
    public void run(RocksDBConfiguration configuration, Environment environment) throws Exception {
        AtomixConnector connector;
        HashMap<String, String> conf = new HashMap<String, String>();
        if (configuration.getConfigPath() != null) {
            this.loadConfiguration(configuration, conf);
        }
        int shards = Integer.parseInt(conf.getOrDefault("shard.count", "1"));
        try {
            connector = new AtomixConnector();
            connector.init(conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        RocksDB rocks = this.buildLocalRocksDB(conf);
        ScheduledExecutorService es = Executors.newScheduledThreadPool(1);
        conf.put("wal.client.class", RocksDBWALClient.class.getName());
        WALManagerImpl mgr = new WALManagerImpl();
        mgr.init(conf, (ClusterConnector)connector, es, (Object)rocks);
        environment.jersey().register((Object)new RockApi(shards, (WALManager)mgr, rocks));
    }

    private RocksDB buildLocalRocksDB(Map<String, String> conf) throws RocksDBException {
        Options options = new Options();
        options.setAllowMmapReads(true).setAllowMmapWrites(true).setCreateIfMissing(true).setCompressionType(CompressionType.SNAPPY_COMPRESSION).setCreateMissingColumnFamilies(true);
        RocksDB db = RocksDB.open((Options)options, (String)conf.getOrDefault("rocksdb.dir", "target/rocksdb"));
        return db;
    }

    private void loadConfiguration(RocksDBConfiguration configuration, Map<String, String> conf) throws IOException, FileNotFoundException {
        String path = configuration.getConfigPath();
        if (path != null) {
            Properties props = new Properties();
            props.load(new FileInputStream(path));
            for (String name : props.stringPropertyNames()) {
                conf.put(name, props.getProperty(name));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new RocksDBCluster().run(args);
    }
}

