/*
 * Decompiled with CFR 0.152.
 */
package com.srotya.minuteman.rocksdb.rpc;

import com.google.protobuf.ByteString;
import com.srotya.minuteman.cluster.Node;
import com.srotya.minuteman.cluster.WALManager;
import com.srotya.minuteman.rocksdb.rpc.DeleteRequest;
import com.srotya.minuteman.rocksdb.rpc.GenericResponse;
import com.srotya.minuteman.rocksdb.rpc.GetRequest;
import com.srotya.minuteman.rocksdb.rpc.GetResponse;
import com.srotya.minuteman.rocksdb.rpc.KeyValuePair;
import com.srotya.minuteman.rocksdb.rpc.PutRequest;
import com.srotya.minuteman.rocksdb.rpc.RocksServiceGrpc;
import com.srotya.minuteman.wal.WAL;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rocksdb.RocksDB;

public class RocksServiceImpl
extends RocksServiceGrpc.RocksServiceImplBase {
    private WALManager mgr;
    private RocksDB rocks;
    private int shards;

    public RocksServiceImpl(int shards, WALManager mgr, RocksDB rocks) {
        this.shards = shards;
        this.mgr = mgr;
        this.rocks = rocks;
    }

    @Override
    public void get(GetRequest request, StreamObserver<GetResponse> responseObserver) {
        if (request.getKeysList() == null) {
            // empty if block
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (String key : request.getKeysList()) {
            String str = String.valueOf(key.hashCode() % this.shards);
            ArrayList<String> req = (ArrayList<String>)map.get(str);
            if (req == null) {
                req = new ArrayList<String>();
                map.put(str, req);
            }
            req.add(key);
        }
        GetResponse.Builder builder = GetResponse.newBuilder();
        for (Map.Entry entry : map.entrySet()) {
            Node node = RocksServiceImpl.getLeaderNode((String)entry.getKey(), this.mgr, this.shards);
            try {
                if (this.mgr.getThisNodeKey().equalsIgnoreCase(node.getNodeKey())) {
                    for (String key : (List)entry.getValue()) {
                        Object val = this.rocks.get(key.getBytes());
                        builder.addKvPairs(KeyValuePair.newBuilder().setKey(key).setValue(ByteString.copyFrom((byte[])val)));
                    }
                    continue;
                }
                RocksServiceGrpc.RocksServiceBlockingStub stub = RocksServiceGrpc.newBlockingStub((Channel)node.getChannel());
                GetRequest.Builder req = GetRequest.newBuilder();
                for (String key : (List)entry.getValue()) {
                    req.addKeys(key);
                }
                GetResponse response = stub.get(req.build());
                builder.addAllKvPairs(response.getKvPairsList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    @Override
    public void delete(DeleteRequest request, StreamObserver<GenericResponse> responseObserver) {
        if (request.getKeysList() != null) {
            HashMap<String, DeleteRequest.Builder> map = new HashMap<String, DeleteRequest.Builder>();
            for (String key : request.getKeysList()) {
                String str = String.valueOf(key.hashCode() % this.shards);
                DeleteRequest.Builder req = (DeleteRequest.Builder)map.get(str);
                if (req == null) {
                    req = DeleteRequest.newBuilder();
                    map.put(str, req);
                }
                req.addKeys(key);
            }
            for (Map.Entry entry : map.entrySet()) {
                Node node = RocksServiceImpl.getLeaderNode((String)entry.getKey(), this.mgr, this.shards);
                try {
                    GenericResponse delete = null;
                    if (this.mgr.getThisNodeKey().equalsIgnoreCase(node.getNodeKey())) {
                        String str = String.valueOf(((String)entry.getKey()).hashCode() % this.shards);
                        WAL wal = this.mgr.getWAL(str);
                        wal.write(((DeleteRequest.Builder)entry.getValue()).build().toByteArray(), false);
                        delete = GenericResponse.newBuilder().setResponseCode(200).build();
                    } else {
                        RocksServiceGrpc.RocksServiceBlockingStub stub = RocksServiceGrpc.newBlockingStub((Channel)node.getChannel());
                        delete = stub.delete(((DeleteRequest.Builder)entry.getValue()).build());
                    }
                    responseObserver.onNext((Object)delete);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        responseObserver.onCompleted();
    }

    public static Node getLeaderNode(String str, WALManager mgr, int shards) {
        String replica = mgr.getReplicaLeader(str);
        Node node = (Node)mgr.getNodeMap().get(replica);
        return node;
    }

    @Override
    public void put(PutRequest request, StreamObserver<GenericResponse> responseObserver) {
        if (request.getKvPairsList() != null) {
            HashMap<String, PutRequest.Builder> map = new HashMap<String, PutRequest.Builder>();
            for (KeyValuePair keyValuePair : request.getKvPairsList()) {
                String str = String.valueOf(keyValuePair.getKey().hashCode() % this.shards);
                PutRequest.Builder list = (PutRequest.Builder)map.get(str);
                if (list == null) {
                    list = PutRequest.newBuilder();
                    map.put(str, list);
                }
                list.addKvPairs(keyValuePair);
            }
            for (Map.Entry entry : map.entrySet()) {
                Node node = RocksServiceImpl.getLeaderNode((String)entry.getKey(), this.mgr, this.shards);
                try {
                    if (this.mgr.getThisNodeKey().equalsIgnoreCase(node.getNodeKey())) {
                        WAL wal = this.mgr.getWAL((String)entry.getKey());
                        wal.write(((PutRequest.Builder)entry.getValue()).build().toByteArray(), false);
                        continue;
                    }
                    RocksServiceGrpc.RocksServiceBlockingStub stub = RocksServiceGrpc.newBlockingStub((Channel)node.getChannel());
                    GenericResponse response = stub.put(((PutRequest.Builder)entry.getValue()).build());
                    responseObserver.onNext((Object)response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        responseObserver.onCompleted();
    }
}

