/*
 * Decompiled with CFR 0.152.
 */
package com.srotya.minuteman.rocksdb.api;

import com.google.gson.Gson;
import com.google.protobuf.ByteString;
import com.srotya.minuteman.cluster.Node;
import com.srotya.minuteman.cluster.WALManager;
import com.srotya.minuteman.rocksdb.rpc.GetRequest;
import com.srotya.minuteman.rocksdb.rpc.GetResponse;
import com.srotya.minuteman.rocksdb.rpc.KeyValuePair;
import com.srotya.minuteman.rocksdb.rpc.PutRequest;
import com.srotya.minuteman.rocksdb.rpc.RocksServiceGrpc;
import com.srotya.minuteman.rpc.ReplicationServiceGrpc;
import com.srotya.minuteman.rpc.RouteRequest;
import com.srotya.minuteman.rpc.RouteResponse;
import com.srotya.minuteman.wal.WAL;
import io.grpc.Channel;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.rocksdb.RocksDB;

@Path(value="/")
public class RockApi {
    private int shards;
    private WALManager mgr;
    private RocksDB rocks;

    public RockApi(int shards, WALManager mgr, RocksDB rocks) {
        this.shards = shards;
        this.mgr = mgr;
        this.rocks = rocks;
    }

    @GET
    @Consumes(value={"text/html"})
    public String get(String keys) {
        ArrayList<String> req;
        Gson gson = new Gson();
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (String key : (String[])gson.fromJson(keys, String[].class)) {
            String str = String.valueOf(key.hashCode() % this.shards);
            req = (ArrayList<String>)map.get(str);
            if (req == null) {
                req = new ArrayList<String>();
                map.put(str, req);
            }
            req.add(key);
        }
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        for (Map.Entry entry : map.entrySet()) {
            Node node = RockApi.getLeaderNode((String)entry.getKey(), this.mgr, this.shards);
            try {
                if (this.mgr.getThisNodeKey().equalsIgnoreCase(node.getNodeKey())) {
                    for (String key : (List)entry.getValue()) {
                        Object val = this.rocks.get(key.getBytes());
                        if (val != null) {
                            results.add(new KeyValue(key, Base64.getEncoder().encodeToString((byte[])val)));
                            continue;
                        }
                        System.out.println("Value is null fr key:" + key);
                    }
                    continue;
                }
                RocksServiceGrpc.RocksServiceBlockingStub stub = RocksServiceGrpc.newBlockingStub((Channel)node.getChannel());
                req = GetRequest.newBuilder();
                for (String key : (List)entry.getValue()) {
                    ((GetRequest.Builder)((Object)req)).addKeys(key);
                }
                GetResponse resp = stub.get(((GetRequest.Builder)((Object)req)).build());
                for (KeyValuePair pair : resp.getKvPairsList()) {
                    results.add(new KeyValue(pair.getKey(), Base64.getEncoder().encodeToString(pair.getValue().toByteArray())));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Gson().toJson(results);
    }

    @PUT
    @Consumes(value={"text/html"})
    public void put(String payload) {
        Gson gson = new Gson();
        HashMap<String, PutRequest.Builder> map = new HashMap<String, PutRequest.Builder>();
        for (KeyValue pair : (KeyValue[])gson.fromJson(payload, KeyValue[].class)) {
            String str = String.valueOf(pair.getKey().hashCode() % this.shards);
            PutRequest.Builder list = (PutRequest.Builder)map.get(str);
            if (list == null) {
                list = PutRequest.newBuilder();
                list.setDelete(false);
                map.put(str, list);
            }
            list.addKvPairs(KeyValuePair.newBuilder().setKey(pair.getKey()).setValue(ByteString.copyFrom((byte[])Base64.getDecoder().decode(pair.getValue()))));
        }
        for (Map.Entry entry : map.entrySet()) {
            Node node = RockApi.getLeaderNode((String)entry.getKey(), this.mgr, this.shards);
            try {
                if (this.mgr.getThisNodeKey().equalsIgnoreCase(node.getNodeKey())) {
                    WAL wal = this.mgr.getWAL((String)entry.getKey());
                    wal.write(((PutRequest.Builder)entry.getValue()).build().toByteArray(), false);
                    continue;
                }
                RocksServiceGrpc.RocksServiceBlockingStub stub = RocksServiceGrpc.newBlockingStub((Channel)node.getChannel());
                stub.put(((PutRequest.Builder)entry.getValue()).build());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Node getLeaderNode(String key, WALManager mgr, int shards) {
        String str = String.valueOf(key.hashCode() % shards);
        String replica = mgr.getReplicaLeader(str);
        if (replica == null) {
            String leaderid;
            Node coordinator = mgr.getCoordinator();
            ReplicationServiceGrpc.ReplicationServiceBlockingStub stub = ReplicationServiceGrpc.newBlockingStub((Channel)coordinator.getChannel());
            RouteResponse response = stub.addRoute(RouteRequest.newBuilder().setRouteKey(str).setReplicationFactor(1).build());
            replica = leaderid = response.getLeaderid();
        }
        Node node = (Node)mgr.getNodeMap().get(replica);
        return node;
    }

    public static class KeyValue {
        private String key;
        private String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

