/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.storage;

import android.content.Context;
import com.sromku.simple.storage.ExternalStorage;
import com.sromku.simple.storage.InternalStorage;
import com.sromku.simple.storage.SimpleStorageConfiguration;

public class SimpleStorage {
    private static InternalStorage mInternalStorage = null;
    private static ExternalStorage mExternalStorage = null;
    private static SimpleStorage mInstance = null;
    private static SimpleStorageConfiguration mSimpleStorageConfiguration;

    private SimpleStorage() {
        mSimpleStorageConfiguration = new SimpleStorageConfiguration.Builder().build();
        mInternalStorage = new InternalStorage();
        mExternalStorage = new ExternalStorage();
    }

    private static SimpleStorage init() {
        if (mInstance == null) {
            mInstance = new SimpleStorage();
        }
        return mInstance;
    }

    public static InternalStorage getInternalStorage(Context context) {
        SimpleStorage.init();
        mInternalStorage.initActivity(context);
        return mInternalStorage;
    }

    public static ExternalStorage getExternalStorage() {
        return SimpleStorage.getExternalStorage(null);
    }

    public static ExternalStorage getExternalStorage(String publicDirectory) {
        SimpleStorage.init();
        mExternalStorage.setPublicDirectory(publicDirectory);
        return mExternalStorage;
    }

    public static boolean isExternalStorageWritable() {
        SimpleStorage.init();
        return mExternalStorage.isWritable();
    }

    public static SimpleStorageConfiguration getConfiguration() {
        return mSimpleStorageConfiguration;
    }

    public static void updateConfiguration(SimpleStorageConfiguration configuration) {
        if (mInstance == null) {
            throw new RuntimeException("First instantiate the Storage and then you can update the configuration");
        }
        mSimpleStorageConfiguration = configuration;
    }

    public static void resetConfiguration() {
        SimpleStorageConfiguration configuration;
        mSimpleStorageConfiguration = configuration = new SimpleStorageConfiguration.Builder().build();
    }

    public static enum StorageType {
        INTERNAL,
        EXTERNAL;

    }
}

