/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.storage;

import android.os.Environment;
import com.sromku.simple.storage.AbstractDiskStorage;
import com.sromku.simple.storage.SimpleStorage;
import java.io.File;

public class ExternalStorage
extends AbstractDiskStorage {
    private String mPublicDirectory = null;

    ExternalStorage() {
    }

    @Override
    public SimpleStorage.StorageType getStorageType() {
        return SimpleStorage.StorageType.EXTERNAL;
    }

    public boolean isWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    @Override
    protected String buildAbsolutePath() {
        if (this.mPublicDirectory != null) {
            return Environment.getExternalStoragePublicDirectory((String)this.mPublicDirectory).getAbsolutePath();
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    @Override
    protected String buildPath(String name) {
        String path = this.buildAbsolutePath();
        path = path + File.separator + name;
        return path;
    }

    @Override
    protected String buildPath(String directoryName, String fileName) {
        String path = this.buildAbsolutePath();
        path = path + File.separator + directoryName + File.separator + fileName;
        return path;
    }

    public void setPublicDirectory(String publicDirectory) {
        this.mPublicDirectory = publicDirectory;
    }
}

