/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.storage.security;

import com.sromku.simple.storage.security.CipherAlgorithmType;
import com.sromku.simple.storage.security.CipherTransformationType;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtil {
    public static byte[] encrypt(byte[] content, int encryptionMode, byte[] secretKey, byte[] ivx) {
        if (secretKey.length != 16 || ivx.length != 16) {
            throw new RuntimeException("Set the encryption parameters correctly. The must be 16 length long each");
        }
        try {
            SecretKeySpec secretkey = new SecretKeySpec(secretKey, CipherAlgorithmType.AES.getAlgorithmName());
            IvParameterSpec IV = new IvParameterSpec(ivx);
            String transformation = CipherTransformationType.AES_CBC_PKCS5Padding;
            Cipher decipher = Cipher.getInstance(transformation);
            decipher.init(encryptionMode, (Key)secretkey, IV);
            byte[] plainText = decipher.doFinal(content);
            return plainText;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to encrypt/descrypt - Unknown Algorithm", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Failed to encrypt/descrypt- Unknown Padding", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to encrypt/descrypt - Invalid Key", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("Failed to encrypt/descrypt - Invalid Algorithm Parameter", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException("Failed to encrypt/descrypt", e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException("Failed to encrypt/descrypt", e);
        }
    }

    public String xor(String msg, String key) {
        try {
            String UTF_8 = "UTF-8";
            byte[] msgArray = msg.getBytes("UTF-8");
            byte[] keyArray = key.getBytes("UTF-8");
            byte[] out = new byte[msgArray.length];
            for (int i = 0; i < msgArray.length; ++i) {
                out[i] = (byte)(msgArray[i] ^ keyArray[i % keyArray.length]);
            }
            return new String(out, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

