/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import android.text.TextUtils;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.sromku.simple.fb.SimpleFacebook;
import com.sromku.simple.fb.actions.GetAction;
import com.sromku.simple.fb.listeners.OnAuthorizationDeviceListener;
import com.sromku.simple.fb.utils.Logger;
import java.lang.reflect.Field;
import java.util.Locale;
import org.json.JSONException;

public class PollDeviceAuthorizationAction {
    private OnAuthorizationDeviceListener mOnActionListener;
    private final String mCode;

    public PollDeviceAuthorizationAction(String code) {
        this.mCode = code;
    }

    public void setActionListener(OnAuthorizationDeviceListener actionListener) {
        this.mOnActionListener = actionListener;
    }

    public void execute() {
        try {
            if (TextUtils.isEmpty((CharSequence)this.mCode)) {
                this.mOnActionListener.onFail("Must set authorization code, that was retrieved from connecting device action");
                return;
            }
            String appId = SimpleFacebook.getConfiguration().getAppId();
            String url = "https://graph.facebook.com/oauth/device?type=device_token&client_id=%s&code=%s";
            url = String.format(Locale.US, url, appId, this.mCode);
            GraphRequest request = new GraphRequest(null, "");
            request.setHttpMethod(HttpMethod.POST);
            Field field = GraphRequest.class.getDeclaredField("overriddenURL");
            field.setAccessible(true);
            field.set(request, url);
            request.setCallback(new GraphRequest.Callback(){

                public void onCompleted(GraphResponse response) {
                    FacebookRequestError error = response.getError();
                    if (error != null) {
                        Logger.logError(GetAction.class, "Failed to get what you have requested", (Throwable)error.getException());
                        PollDeviceAuthorizationAction.this.mOnActionListener.onException((Throwable)error.getException());
                    } else {
                        String rawResponse = response.getRawResponse();
                        if (rawResponse == null) {
                            Logger.logError(GetAction.class, "The response GraphObject has null value. Response=" + response.toString(), null);
                        } else {
                            try {
                                String accessToken = response.getJSONObject().getString("access_token");
                                PollDeviceAuthorizationAction.this.mOnActionListener.onComplete(accessToken);
                            }
                            catch (JSONException e) {
                                PollDeviceAuthorizationAction.this.mOnActionListener.onFail("Failed to parse access token result");
                            }
                        }
                    }
                }
            });
            GraphRequestAsyncTask task = new GraphRequestAsyncTask(new GraphRequest[]{request});
            task.execute((Object[])new Void[0]);
        }
        catch (Exception e) {
            this.mOnActionListener.onException(e);
        }
    }
}

