/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import com.google.gson.annotations.SerializedName;
import com.sromku.simple.fb.utils.Logger;
import com.sromku.simple.fb.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

public class Privacy {
    private static final String PRIVACY = "value";
    private static final String ALLOW = "allow";
    private static final String DENY = "deny";
    private static final String DESCRIPTION = "description";
    @SerializedName(value="value")
    private PrivacySettings mPrivacySetting = null;
    @SerializedName(value="allow")
    private ArrayList<String> mAllowedUsers = new ArrayList();
    @SerializedName(value="deny")
    private ArrayList<String> mDeniedUsers = new ArrayList();
    @SerializedName(value="description")
    private String mDescription;

    private Privacy(Builder builder) {
        this.mPrivacySetting = builder.mPrivacySetting;
        this.mAllowedUsers = builder.mAllowedUsers;
        this.mDeniedUsers = builder.mDeniedUsers;
    }

    public String getJSONString() {
        JSONObject jsonRepresentation = new JSONObject();
        try {
            jsonRepresentation.put(PRIVACY, (Object)this.mPrivacySetting.name());
            if (this.mPrivacySetting == PrivacySettings.CUSTOM) {
                if (!this.mAllowedUsers.isEmpty()) {
                    jsonRepresentation.put(ALLOW, (Object)Utils.join(this.mAllowedUsers.iterator(), ","));
                }
                if (!this.mDeniedUsers.isEmpty()) {
                    jsonRepresentation.put(DENY, (Object)Utils.join(this.mDeniedUsers.iterator(), ","));
                }
            }
        }
        catch (JSONException e) {
            Logger.logError(Privacy.class, "Failed to get json string from properties", e);
        }
        return jsonRepresentation.toString();
    }

    public static class Builder {
        private PrivacySettings mPrivacySetting = null;
        private ArrayList<String> mAllowedUsers = new ArrayList();
        private ArrayList<String> mDeniedUsers = new ArrayList();

        public Builder setPrivacySettings(PrivacySettings privacySettings) {
            this.mPrivacySetting = privacySettings;
            return this;
        }

        public Builder addAllowed(String userOrListId) {
            this.validateListsAccessRequest();
            this.mAllowedUsers.add(userOrListId);
            return this;
        }

        public Builder addAllowed(PrivacySettings privacySettings) {
            this.validateListsAccessRequest();
            if (privacySettings != PrivacySettings.ALL_FRIENDS || privacySettings != PrivacySettings.FRIENDS_OF_FRIENDS) {
                UnsupportedOperationException exception = new UnsupportedOperationException("Can't add this predefined friend list. Only allowed are: ALL_FRIENDS or FRIENDS_OF_FRIENDS");
                Logger.logError(Privacy.class, "failed to add allowed users", exception);
                throw exception;
            }
            this.mAllowedUsers.add(privacySettings.name());
            return this;
        }

        public Builder addAllowed(Collection<? extends String> userOrListIds) {
            this.validateListsAccessRequest();
            this.mAllowedUsers.addAll(userOrListIds);
            return this;
        }

        public Builder addDenied(String userOrListId) {
            this.validateListsAccessRequest();
            this.mDeniedUsers.add(userOrListId);
            return this;
        }

        public Builder addDenied(Collection<? extends String> userOrListIds) {
            this.validateListsAccessRequest();
            this.mDeniedUsers.addAll(userOrListIds);
            return this;
        }

        public Privacy build() {
            return new Privacy(this);
        }

        private void validateListsAccessRequest() {
            if (this.mPrivacySetting != PrivacySettings.CUSTOM) {
                Logger.logWarning(Privacy.class, "Can't add / delete from allowed / denied lists when privacy setting is different than \"CUSTOM\"");
                this.mPrivacySetting = PrivacySettings.CUSTOM;
            }
        }
    }

    public static enum PrivacySettings {
        EVERYONE,
        ALL_FRIENDS,
        FRIENDS_OF_FRIENDS,
        SELF,
        CUSTOM;

    }
}

