/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import android.os.Bundle;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.Sharer;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.ShareOpenGraphObject;
import com.facebook.share.widget.ShareDialog;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.actions.AbstractAction;
import com.sromku.simple.fb.entities.Story;
import com.sromku.simple.fb.listeners.OnPublishListener;
import java.util.Iterator;
import org.json.JSONObject;

public class PublishStoryDialogAction
extends AbstractAction {
    private OnPublishListener mOnPublishListener;
    private Story mStory;

    public PublishStoryDialogAction(SessionManager sessionManager) {
        super(sessionManager);
    }

    public void setOnPublishListener(OnPublishListener onPublishListener) {
        this.mOnPublishListener = onPublishListener;
    }

    public void setStory(Story story) {
        this.mStory = story;
    }

    @Override
    protected void executeImpl() {
        ShareDialog shareDialog = new ShareDialog(this.sessionManager.getActivity());
        ShareOpenGraphContent.Builder builder = new ShareOpenGraphContent.Builder();
        String objectId = this.mStory.getStoryObject().getId();
        String objectUrl = this.mStory.getStoryObject().getHostedUrl();
        boolean predefineObject = objectId != null || objectUrl != null;
        String objectType = this.mStory.getObjectType();
        String storyPath = this.mStory.getPath();
        if (predefineObject) {
            ShareOpenGraphAction.Builder actionBuilder = new ShareOpenGraphAction.Builder();
            actionBuilder.putString(objectType, objectId != null ? objectId : objectUrl);
            for (String property : this.mStory.getStoryAction().getParams().keySet()) {
                actionBuilder.putString(property, String.valueOf(this.mStory.getStoryAction().getParams().get(property)));
            }
            actionBuilder.setActionType(storyPath);
            builder.setAction(actionBuilder.build());
        } else {
            ShareOpenGraphObject.Builder objectBuilder = new ShareOpenGraphObject.Builder();
            Bundle objectProperties = this.mStory.getStoryObject().getObjectProperties();
            Iterator iterator = objectProperties.keySet().iterator();
            String OG = "og:";
            while (iterator.hasNext()) {
                String property = (String)iterator.next();
                objectBuilder.putString(OG + property, String.valueOf(objectProperties.get(property)));
            }
            objectBuilder.putString(OG + "type", objectType);
            JSONObject data = this.mStory.getStoryObject().getData();
            String OG_CUSTOM = this.configuration.getNamespace() + ":";
            if (data != null) {
                Iterator keys = data.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    objectBuilder.putString(OG_CUSTOM + key, String.valueOf(data.opt(key)));
                }
            }
            ShareOpenGraphObject object = objectBuilder.build();
            ShareOpenGraphAction.Builder actionBuilder = new ShareOpenGraphAction.Builder();
            actionBuilder.putObject(objectType, object);
            for (String property : this.mStory.getStoryAction().getParams().keySet()) {
                actionBuilder.putString(property, String.valueOf(this.mStory.getStoryAction().getParams().get(property)));
            }
            actionBuilder.setActionType(storyPath);
            builder.setAction(actionBuilder.build());
        }
        builder.setPreviewPropertyName(objectType);
        ShareOpenGraphContent content = builder.build();
        if (shareDialog.canShow((Object)content)) {
            shareDialog.registerCallback(this.sessionManager.getCallbackManager(), (FacebookCallback)new FacebookCallback<Sharer.Result>(){

                public void onSuccess(Sharer.Result result) {
                    String postId = result.getPostId();
                    if (PublishStoryDialogAction.this.mOnPublishListener != null) {
                        PublishStoryDialogAction.this.mOnPublishListener.onComplete(postId);
                    }
                }

                public void onCancel() {
                    if (PublishStoryDialogAction.this.mOnPublishListener != null) {
                        PublishStoryDialogAction.this.mOnPublishListener.onFail("Canceled by user");
                    }
                }

                public void onError(FacebookException e) {
                    if (PublishStoryDialogAction.this.mOnPublishListener != null) {
                        PublishStoryDialogAction.this.mOnPublishListener.onFail(e.getMessage());
                    }
                }
            });
            shareDialog.show((Object)content);
        } else {
            this.mOnPublishListener.onFail("Open graph sharing dialog isn't supported");
        }
    }
}

