/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestAsyncTask;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.actions.AbstractAction;
import com.sromku.simple.fb.actions.Cursor;
import com.sromku.simple.fb.listeners.OnActionListener;
import com.sromku.simple.fb.utils.Errors;
import com.sromku.simple.fb.utils.Logger;
import com.sromku.simple.fb.utils.Utils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.json.JSONException;

public class GetAction<T>
extends AbstractAction {
    private String mTarget = "me";
    private String mEdge = null;
    private OnActionListener<T> mOnActionListener = null;
    private Cursor<T> mCursor = null;
    private GraphRequest.Callback mCallback = new GraphRequest.Callback(){

        public void onCompleted(GraphResponse response) {
            OnActionListener actionListener = GetAction.this.getActionListener();
            FacebookRequestError error = response.getError();
            if (error != null) {
                Logger.logError(GetAction.class, "Failed to get what you have requested", (Throwable)error.getException());
                if (actionListener != null) {
                    actionListener.onException((Throwable)error.getException());
                }
            } else if (response.getRawResponse() == null) {
                Logger.logError(GetAction.class, "The response GraphObject has null value. Response=" + response.toString(), null);
            } else if (actionListener != null) {
                Object result = null;
                try {
                    GetAction.this.updateCursor(response);
                    result = GetAction.this.processResponse(response);
                }
                catch (Exception e) {
                    actionListener.onException(e);
                    return;
                }
                actionListener.onComplete(result);
            }
        }
    };

    public GetAction(SessionManager sessionManager) {
        super(sessionManager);
    }

    public void setEdge(String edge) {
        this.mEdge = edge;
    }

    public void setTarget(String target) {
        if (target != null) {
            this.mTarget = target;
        }
    }

    public void setActionListener(OnActionListener<T> actionListener) {
        this.mOnActionListener = actionListener;
    }

    @Override
    protected void executeImpl() {
        OnActionListener<T> actionListener = this.getActionListener();
        if (this.sessionManager.isLogin()) {
            AccessToken accessToken = this.sessionManager.getAccessToken();
            Bundle bundle = this.updateAppSecretProof(this.getBundle());
            GraphRequest request = new GraphRequest(accessToken, this.getGraphPath(), bundle, HttpMethod.GET);
            request.setVersion(this.configuration.getGraphVersion());
            this.runRequest(request);
        } else {
            String reason = Errors.getError(Errors.ErrorMsg.LOGIN);
            Logger.logError(this.getClass(), reason, null);
            if (actionListener != null) {
                actionListener.onFail(reason);
            }
        }
    }

    private Bundle updateAppSecretProof(Bundle bundle) {
        if (this.configuration.useAppsecretProof()) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putString("appsecret_proof", Utils.encode(this.configuration.getAppSecret(), this.sessionManager.getAccessToken().getToken()));
        }
        return bundle;
    }

    protected String getTarget() {
        return this.mTarget;
    }

    protected String getGraphPath() {
        if (this.mEdge != null) {
            return this.mTarget + "/" + this.mEdge;
        }
        return this.mTarget;
    }

    protected Bundle getBundle() {
        return null;
    }

    protected OnActionListener<T> getActionListener() {
        return this.mOnActionListener;
    }

    protected T processResponse(GraphResponse response) {
        Type type = this.mOnActionListener.getGenericType();
        if (type instanceof ParameterizedType) {
            Object arrayJson;
            try {
                arrayJson = response.getJSONObject().get("data");
            }
            catch (JSONException e) {
                return null;
            }
            Object data = Utils.convert(String.valueOf(arrayJson), type);
            return data;
        }
        return Utils.convert(response, type);
    }

    void runRequest(GraphRequest request) {
        OnActionListener<T> actionListener = this.getActionListener();
        request.setCallback(this.mCallback);
        GraphRequestAsyncTask task = new GraphRequestAsyncTask(new GraphRequest[]{request});
        task.execute((Object[])new Void[0]);
        if (actionListener != null) {
            actionListener.onThinking();
        }
    }

    private void updateCursor(GraphResponse response) {
        GraphRequest requestNextPage;
        if (this.mOnActionListener == null) {
            return;
        }
        if (this.mCursor == null) {
            this.mCursor = new Cursor(this);
        }
        if ((requestNextPage = response.getRequestForPagedResults(GraphResponse.PagingDirection.NEXT)) != null) {
            requestNextPage.setCallback(this.mCallback);
        }
        this.mCursor.setNextPage(requestNextPage);
        GraphRequest requestPrevPage = response.getRequestForPagedResults(GraphResponse.PagingDirection.PREVIOUS);
        if (requestPrevPage != null) {
            requestPrevPage.setCallback(this.mCallback);
        }
        this.mCursor.setPrevPage(requestPrevPage);
        this.mOnActionListener.setCursor(this.mCursor);
    }
}

