/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum Permission {
    USER_ABOUT_ME("user_about_me", Type.READ),
    USER_ACTIONS_BOOKS("user_actions.books", Type.READ),
    USER_ACTIONS_FITNESS("user_actions.fitness", Type.READ),
    USER_ACTIONS_MUSIC("user_actions.music", Type.READ),
    USER_ACTIONS_NEWS("user_actions.news", Type.READ),
    USER_ACTIONS_VIDEO("user_actions.video", Type.READ),
    USER_BIRTHDAY("user_birthday", Type.READ),
    USER_EDUCATION_HISTORY("user_education_history", Type.READ),
    USER_EVENTS("user_events", Type.READ),
    USER_FRIENDS("user_friends", Type.READ),
    USER_GAMES_ACTIVITY("user_games_activity", Type.READ),
    USER_MANAGED_GROUPS("user_managed_groups", Type.READ),
    USER_HOMETOWN("user_hometown", Type.READ),
    USER_LIKES("user_likes", Type.READ),
    USER_LOCATION("user_location", Type.READ),
    USER_PHOTOS("user_photos", Type.READ),
    USER_RELATIONSHIPS("user_relationships", Type.READ),
    USER_RELATIONSHIP_DETAILS("user_relationship_details", Type.READ),
    USER_RELIGION_POLITICS("user_religion_politics", Type.READ),
    USER_STATUS("user_status", Type.READ),
    USER_TAGGED_PLACES("user_tagged_places", Type.READ),
    USER_VIDEOS("user_videos", Type.READ),
    USER_WEBSITE("user_website", Type.READ),
    USER_WORK_HISTORY("user_work_history", Type.READ),
    READ_CUSTOM_FRIENDLISTS("read_custom_friendlists", Type.READ),
    READ_INSIGHTS("read_insights", Type.READ),
    READ_PAGE_MAILBOX("read_page_mailboxes", Type.READ),
    EMAIL("email", Type.READ),
    USER_POSTS("user_posts", Type.READ),
    ADS_READ("ads_read", Type.READ),
    READ_AUDIENCE_NETWORK_INSIGHTS("read_audience_network_insights", Type.READ),
    PUBLISH_ACTION("publish_actions", Type.PUBLISH),
    RSVP_EVENT("rsvp_event", Type.PUBLISH),
    MANAGE_PAGES("manage_pages", Type.PUBLISH);

    private final String mValue;
    private final Type mType;

    private Permission(String value, Type type) {
        this.mValue = value;
        this.mType = type;
    }

    public String getValue() {
        return this.mValue;
    }

    public Type getType() {
        return this.mType;
    }

    public static Permission fromValue(String permissionValue) {
        for (Permission permission : Permission.values()) {
            if (!permission.mValue.equals(permissionValue)) continue;
            return permission;
        }
        return null;
    }

    public static List<Permission> convert(Collection<String> rawPermissions) {
        if (rawPermissions == null) {
            return null;
        }
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Permission permission : Permission.values()) {
            if (!rawPermissions.contains(permission.getValue())) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    public static List<String> convert(List<Permission> permissions) {
        if (permissions == null) {
            return null;
        }
        ArrayList<String> rawPermissions = new ArrayList<String>();
        for (Permission permission : permissions) {
            rawPermissions.add(permission.getValue());
        }
        return rawPermissions;
    }

    public static List<String> fetchPermissions(List<Permission> permissions, Type type) {
        ArrayList<String> perms = new ArrayList<String>();
        for (Permission permission : permissions) {
            if (!type.equals((Object)permission.getType())) continue;
            perms.add(permission.getValue());
        }
        return perms;
    }

    public static enum Role {
        ADMINISTER,
        EDIT_PROFILE,
        CREATE_CONTENT,
        MODERATE_CONTENT,
        CREATE_ADS,
        BASIC_ADMIN;

    }

    public static enum Type {
        PUBLISH,
        READ;

    }
}

