/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import android.os.Bundle;
import com.google.gson.annotations.SerializedName;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.SimpleFacebook;
import com.sromku.simple.fb.entities.Application;
import com.sromku.simple.fb.entities.Privacy;
import com.sromku.simple.fb.entities.Publishable;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Story
implements Publishable {
    private StoryObject mStoryObject;
    private StoryAction mStoryAction;

    @Override
    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        if (this.mStoryObject.getId() != null) {
            bundle.putString(this.mStoryObject.getNoun(), this.mStoryObject.getId());
        } else if (this.mStoryObject.getHostedUrl() != null) {
            bundle.putString(this.mStoryObject.getNoun(), this.mStoryObject.getHostedUrl());
        } else {
            bundle = this.mStoryObject.getBundle();
            bundle.putString(this.mStoryObject.getNoun(), bundle.getString("object"));
        }
        if (this.mStoryAction.getParams() != null) {
            bundle.putAll(this.mStoryAction.getParams());
        }
        return bundle;
    }

    @Override
    public String getPath() {
        String namespace = SimpleFacebook.getConfiguration().getNamespace();
        return namespace + ":" + this.mStoryAction.getActionName();
    }

    public String getObjectType() {
        String namespace = SimpleFacebook.getConfiguration().getNamespace();
        return namespace + ":" + this.mStoryObject.getNoun();
    }

    @Override
    public Permission getPermission() {
        return Permission.PUBLISH_ACTION;
    }

    public StoryAction getStoryAction() {
        return this.mStoryAction;
    }

    public StoryObject getStoryObject() {
        return this.mStoryObject;
    }

    private Story(Builder buidler) {
        this.mStoryObject = buidler.storyObject;
        this.mStoryAction = buidler.storyAction;
    }

    public static class StoryObject
    implements Publishable {
        private static final String ID = "id";
        private static final String TYPE = "type";
        private static final String TITLE = "title";
        private static final String URL = "url";
        private static final String IMAGE = "image";
        private static final String DATA = "data";
        private static final String DESCRIPTION = "description";
        private static final String UPDATED_TIME = "updated_time";
        private static final String CREATED_TIME = "created_time";
        private static final String APPLICATION = "application";
        private static final String OBJECT = "object";
        private static final String PRIVACY = "privacy";
        @SerializedName(value="id")
        private String mId;
        @SerializedName(value="type")
        private String mType;
        @SerializedName(value="title")
        private String mTitle;
        @SerializedName(value="url")
        private String mUrl;
        private String mImage;
        @SerializedName(value="image")
        private List<ImageUrl> mImageUrl;
        @SerializedName(value="description")
        private String mDescription;
        @SerializedName(value="updated_time")
        private Date mUpdatedTime;
        @SerializedName(value="created_time")
        private Date mCreatedTime;
        @SerializedName(value="application")
        private Application mApplication;
        @SerializedName(value="privacy")
        private Privacy mPrivacy;
        private String mNoun;
        private String mHostedUrl;
        private JSONObject mData;

        private StoryObject(Builder builder) {
            String namespace = SimpleFacebook.getConfiguration().getNamespace();
            this.mType = namespace + ":" + builder.noun;
            this.mNoun = builder.noun;
            this.mTitle = builder.title;
            this.mId = builder.id;
            this.mUrl = builder.url;
            this.mDescription = builder.description;
            this.mData = builder.data;
            this.mImage = builder.image;
            this.mPrivacy = builder.privacy;
            this.mHostedUrl = builder.hostedUrl;
        }

        @Override
        public Bundle getBundle() {
            Bundle bundle = new Bundle();
            JSONObject object = new JSONObject();
            try {
                object.put(URL, (Object)this.mUrl);
                object.put(IMAGE, (Object)this.mImage);
                object.put(TITLE, (Object)this.mTitle);
                object.put(DESCRIPTION, (Object)this.mDescription);
                if (this.mData != null) {
                    object.put(DATA, (Object)this.mData);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bundle.putString(OBJECT, object.toString());
            if (this.mPrivacy != null) {
                bundle.putString(PRIVACY, this.mPrivacy.getJSONString());
            }
            return bundle;
        }

        @Override
        public String getPath() {
            return "objects/" + this.mType;
        }

        @Override
        public Permission getPermission() {
            return Permission.PUBLISH_ACTION;
        }

        public Bundle getObjectProperties() {
            Bundle bundle = new Bundle();
            bundle.putString(URL, this.mUrl);
            bundle.putString(IMAGE, this.mImage);
            bundle.putString(TITLE, this.mTitle);
            bundle.putString(DESCRIPTION, this.mDescription);
            return bundle;
        }

        public String getId() {
            return this.mId;
        }

        public String getType() {
            return this.mType;
        }

        public String getNoun() {
            return this.mNoun;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String getHostedUrl() {
            return this.mHostedUrl;
        }

        public String getImage() {
            if (this.mImageUrl != null && this.mImageUrl.size() > 0) {
                return this.mImageUrl.get((int)0).url;
            }
            return null;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public Date getUpdatedTime() {
            return this.mUpdatedTime;
        }

        public Date getCreatedTime() {
            return this.mCreatedTime;
        }

        public Application getApplication() {
            return this.mApplication;
        }

        public JSONObject getData() {
            return this.mData;
        }

        public Object getCustomData(String param) {
            return this.mData.opt(param);
        }

        public static class Builder {
            private String id;
            private String noun;
            private String url;
            private String image;
            private String title;
            private String description;
            private Privacy privacy;
            private String hostedUrl;
            private JSONObject data = null;

            public Builder setNoun(String noun) {
                this.noun = noun;
                return this;
            }

            public Builder setUrl(String url) {
                this.url = url;
                return this;
            }

            public Builder setHostedUrl(String hostedUrl) {
                this.hostedUrl = hostedUrl;
                return this;
            }

            public Builder setId(String id) {
                this.id = id;
                return this;
            }

            public Builder setImage(String imageUrl) {
                this.image = imageUrl;
                return this;
            }

            public Builder setTitle(String title) {
                this.title = title;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder setPrivacy(Privacy privacy) {
                this.privacy = privacy;
                return this;
            }

            public Builder addProperty(String param, Object value) {
                if (this.data == null) {
                    this.data = new JSONObject();
                }
                try {
                    this.data.put(param, value);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return this;
            }

            public StoryObject build() {
                return new StoryObject(this);
            }
        }

        private static class ImageUrl {
            String url;

            private ImageUrl() {
            }
        }
    }

    public static class StoryAction {
        private Bundle mBundle = new Bundle();
        private String mActionName;

        private StoryAction(Builder builder) {
            this.mBundle = builder.bundle;
            this.mActionName = builder.actionName;
        }

        public String getActionName() {
            return this.mActionName;
        }

        public Bundle getParams() {
            return this.mBundle;
        }

        public String getParamValue(String param) {
            return this.mBundle.getString(param);
        }

        public static class Builder {
            private Bundle bundle = new Bundle();
            private String actionName;

            public Builder setAction(String actionName) {
                this.actionName = actionName;
                return this;
            }

            public Builder addProperty(String param, String value) {
                this.bundle.putString(param, value);
                return this;
            }

            public StoryAction build() {
                return new StoryAction(this);
            }
        }
    }

    public static class Builder {
        private StoryObject storyObject;
        private StoryAction storyAction;

        public Builder setAction(StoryAction storyAction) {
            this.storyAction = storyAction;
            return this;
        }

        public Builder setObject(StoryObject storyObject) {
            this.storyObject = storyObject;
            return this;
        }

        public Story build() {
            return new Story(this);
        }
    }
}

