/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb;

import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.sromku.simple.fb.Permission;
import java.util.ArrayList;
import java.util.List;

public class SimpleFacebookConfiguration {
    private String mAppId;
    private String mNamespace;
    private List<String> mReadPermissions = null;
    private List<String> mPublishPermissions = null;
    private DefaultAudience mDefaultAudience = null;
    private LoginBehavior mLoginBehavior = null;
    private boolean mHasPublishPermissions = false;
    boolean mAllAtOnce = false;
    private boolean mUseAppsecretProof = false;
    private String mAppSecret = null;

    private SimpleFacebookConfiguration(Builder builder) {
        this.mAppId = builder.mAppId;
        this.mNamespace = builder.mNamespace;
        this.mReadPermissions = builder.mReadPermissions;
        this.mPublishPermissions = builder.mPublishPermissions;
        this.mDefaultAudience = builder.mDefaultAudience;
        this.mLoginBehavior = builder.mLoginBehavior;
        this.mAllAtOnce = builder.mAllAtOnce;
        this.mUseAppsecretProof = builder.mUseAppsecretProof;
        this.mAppSecret = builder.mAppSecret;
        if (this.mPublishPermissions.size() > 0) {
            this.mHasPublishPermissions = true;
        }
    }

    public String getAppId() {
        return this.mAppId;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public List<String> getReadPermissions() {
        return this.mReadPermissions;
    }

    public List<String> getPublishPermissions() {
        return this.mPublishPermissions;
    }

    boolean hasPublishPermissions() {
        return this.mHasPublishPermissions;
    }

    LoginBehavior getLoginBehavior() {
        return this.mLoginBehavior;
    }

    DefaultAudience getDefaultAudience() {
        return this.mDefaultAudience;
    }

    public boolean useAppsecretProof() {
        return this.mUseAppsecretProof;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    boolean isAllPermissionsAtOnce() {
        return this.mAllAtOnce;
    }

    int getType(List<Permission> permissions) {
        int flag = 0;
        if (permissions == null || permissions.size() == 0) {
            return flag;
        }
        for (Permission permission : permissions) {
            switch (permission.getType()) {
                case READ: {
                    flag |= 1;
                    break;
                }
                case PUBLISH: {
                    flag |= 2;
                    break;
                }
            }
        }
        return flag;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ").append("mAppId:").append(this.mAppId).append(", ").append("mNamespace:").append(this.mNamespace).append(", ").append("mDefaultAudience:").append(", ").append("mLoginBehavior:").append(", ").append("mReadPermissions:").append(this.mReadPermissions.toString()).append(", ").append("mPublishPermissions:").append(this.mPublishPermissions.toString()).append(" ]");
        return stringBuilder.toString();
    }

    public static class Builder {
        private String mAppId = null;
        private String mNamespace = null;
        private List<String> mReadPermissions = new ArrayList<String>();
        private List<String> mPublishPermissions = new ArrayList<String>();
        private DefaultAudience mDefaultAudience = DefaultAudience.FRIENDS;
        private LoginBehavior mLoginBehavior = LoginBehavior.SSO_WITH_FALLBACK;
        private boolean mAllAtOnce = false;
        private boolean mUseAppsecretProof = false;
        private String mAppSecret = null;

        public Builder setAppId(String appId) {
            this.mAppId = appId;
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.mNamespace = namespace;
            return this;
        }

        public Builder setPermissions(Permission[] permissions) {
            block4: for (Permission permission : permissions) {
                switch (permission.getType()) {
                    case READ: {
                        this.mReadPermissions.add(permission.getValue());
                        continue block4;
                    }
                    case PUBLISH: {
                        this.mPublishPermissions.add(permission.getValue());
                        continue block4;
                    }
                }
            }
            return this;
        }

        public Builder setDefaultAudience(DefaultAudience defaultAudience) {
            this.mDefaultAudience = defaultAudience;
            return this;
        }

        public Builder setLoginBehavior(LoginBehavior loginBehavior) {
            this.mLoginBehavior = loginBehavior;
            return this;
        }

        public Builder setAskForAllPermissionsAtOnce(boolean allAtOnce) {
            this.mAllAtOnce = allAtOnce;
            return this;
        }

        public Builder useAppsecretProof(boolean use) {
            this.mUseAppsecretProof = use;
            return this;
        }

        public Builder setAppSecret(String appSecret) {
            this.mAppSecret = appSecret;
            return this;
        }

        public SimpleFacebookConfiguration build() {
            return new SimpleFacebookConfiguration(this);
        }
    }
}

