/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.entities;

import android.os.Bundle;
import com.google.gson.annotations.SerializedName;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.entities.Application;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.entities.User;

public class Score
implements Publishable {
    private static final String USER = "user";
    private static final String SCORE = "score";
    private static final String APPLICATION = "application";
    @SerializedName(value="user")
    private User mUser;
    @SerializedName(value="score")
    private Integer mScore;
    @SerializedName(value="application")
    private Application mApplication;

    private Score(Builder builder) {
        this.mScore = builder.mScore;
    }

    public User getUser() {
        return this.mUser;
    }

    public Integer getScore() {
        return this.mScore;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    @Override
    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(SCORE, this.mScore.intValue());
        return bundle;
    }

    @Override
    public String getPath() {
        return "scores";
    }

    @Override
    public Permission getPermission() {
        return Permission.PUBLISH_ACTION;
    }

    public static class Builder {
        private int mScore;

        public Builder setScore(int score) {
            this.mScore = score;
            return this;
        }

        public Score build() {
            return new Score(this);
        }
    }
}

