/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.actions;

import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.share.Sharer;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.widget.ShareDialog;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.actions.AbstractAction;
import com.sromku.simple.fb.entities.Photo;
import com.sromku.simple.fb.listeners.OnPublishListener;
import com.sromku.simple.fb.utils.Utils;
import java.util.List;

public class PublishPhotoDialogAction
extends AbstractAction {
    private OnPublishListener mOnPublishListener;
    private List<Photo> mPhotos;
    private String mPlace;

    public PublishPhotoDialogAction(SessionManager sessionManager) {
        super(sessionManager);
    }

    public void setPhotos(List<Photo> photos) {
        this.mPhotos = photos;
    }

    public void setPlace(String place) {
        this.mPlace = place;
    }

    public void setOnPublishListener(OnPublishListener onPublishListener) {
        this.mOnPublishListener = onPublishListener;
    }

    @Override
    protected void executeImpl() {
        SharePhotoContent content;
        ShareDialog shareDialog = new ShareDialog(this.sessionManager.getActivity());
        if (shareDialog.canShow((Object)(content = new SharePhotoContent.Builder().addPhotos(Utils.extractBitmaps(this.mPhotos)).build()))) {
            shareDialog.registerCallback(this.sessionManager.getCallbackManager(), (FacebookCallback)new FacebookCallback<Sharer.Result>(){

                public void onSuccess(Sharer.Result result) {
                    String postId = result.getPostId();
                    if (PublishPhotoDialogAction.this.mOnPublishListener != null) {
                        PublishPhotoDialogAction.this.mOnPublishListener.onComplete(postId);
                    }
                }

                public void onCancel() {
                    if (PublishPhotoDialogAction.this.mOnPublishListener != null) {
                        PublishPhotoDialogAction.this.mOnPublishListener.onFail("Canceled by user");
                    }
                }

                public void onError(FacebookException e) {
                    if (PublishPhotoDialogAction.this.mOnPublishListener != null) {
                        PublishPhotoDialogAction.this.mOnPublishListener.onFail(e.getMessage());
                    }
                }
            });
            shareDialog.show((Object)content);
        }
    }
}

