/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.facebook.FacebookSdk;
import com.sromku.simple.fb.Permission;
import com.sromku.simple.fb.SessionManager;
import com.sromku.simple.fb.SimpleFacebookConfiguration;
import com.sromku.simple.fb.actions.DeleteRequestAction;
import com.sromku.simple.fb.actions.GetAccountsAction;
import com.sromku.simple.fb.actions.GetAction;
import com.sromku.simple.fb.actions.GetAlbumAction;
import com.sromku.simple.fb.actions.GetAlbumsAction;
import com.sromku.simple.fb.actions.GetAppRequestsAction;
import com.sromku.simple.fb.actions.GetAttachmentAction;
import com.sromku.simple.fb.actions.GetCommentAction;
import com.sromku.simple.fb.actions.GetCommentsAction;
import com.sromku.simple.fb.actions.GetEventsAction;
import com.sromku.simple.fb.actions.GetFamilyAction;
import com.sromku.simple.fb.actions.GetFriendsAction;
import com.sromku.simple.fb.actions.GetGroupsAction;
import com.sromku.simple.fb.actions.GetInvitableFriendsAction;
import com.sromku.simple.fb.actions.GetLikesAction;
import com.sromku.simple.fb.actions.GetNotificationsAction;
import com.sromku.simple.fb.actions.GetPageAction;
import com.sromku.simple.fb.actions.GetPagesAction;
import com.sromku.simple.fb.actions.GetPhotoAction;
import com.sromku.simple.fb.actions.GetPhotosAction;
import com.sromku.simple.fb.actions.GetPostsAction;
import com.sromku.simple.fb.actions.GetProfileAction;
import com.sromku.simple.fb.actions.GetScoresAction;
import com.sromku.simple.fb.actions.GetStoryObjectsAction;
import com.sromku.simple.fb.actions.GetTaggableFriendsAction;
import com.sromku.simple.fb.actions.GetVideosAction;
import com.sromku.simple.fb.actions.InviteAction;
import com.sromku.simple.fb.actions.PublishAction;
import com.sromku.simple.fb.actions.PublishFeedDialogAction;
import com.sromku.simple.fb.actions.PublishPhotoDialogAction;
import com.sromku.simple.fb.actions.PublishStoryDialogAction;
import com.sromku.simple.fb.entities.Album;
import com.sromku.simple.fb.entities.Comment;
import com.sromku.simple.fb.entities.Event;
import com.sromku.simple.fb.entities.Feed;
import com.sromku.simple.fb.entities.Like;
import com.sromku.simple.fb.entities.Page;
import com.sromku.simple.fb.entities.Photo;
import com.sromku.simple.fb.entities.Post;
import com.sromku.simple.fb.entities.Profile;
import com.sromku.simple.fb.entities.Publishable;
import com.sromku.simple.fb.entities.Score;
import com.sromku.simple.fb.entities.Story;
import com.sromku.simple.fb.entities.Video;
import com.sromku.simple.fb.listeners.OnAccountsListener;
import com.sromku.simple.fb.listeners.OnActionListener;
import com.sromku.simple.fb.listeners.OnAlbumListener;
import com.sromku.simple.fb.listeners.OnAlbumsListener;
import com.sromku.simple.fb.listeners.OnAppRequestsListener;
import com.sromku.simple.fb.listeners.OnAttachmentListener;
import com.sromku.simple.fb.listeners.OnCommentListener;
import com.sromku.simple.fb.listeners.OnCommentsListener;
import com.sromku.simple.fb.listeners.OnCreateStoryObject;
import com.sromku.simple.fb.listeners.OnDeleteListener;
import com.sromku.simple.fb.listeners.OnEventsListener;
import com.sromku.simple.fb.listeners.OnFamilyListener;
import com.sromku.simple.fb.listeners.OnFriendsListener;
import com.sromku.simple.fb.listeners.OnGroupsListener;
import com.sromku.simple.fb.listeners.OnInviteListener;
import com.sromku.simple.fb.listeners.OnLikesListener;
import com.sromku.simple.fb.listeners.OnLoginListener;
import com.sromku.simple.fb.listeners.OnLogoutListener;
import com.sromku.simple.fb.listeners.OnNewPermissionsListener;
import com.sromku.simple.fb.listeners.OnNotificationsListener;
import com.sromku.simple.fb.listeners.OnPageListener;
import com.sromku.simple.fb.listeners.OnPagesListener;
import com.sromku.simple.fb.listeners.OnPhotoListener;
import com.sromku.simple.fb.listeners.OnPhotosListener;
import com.sromku.simple.fb.listeners.OnPostsListener;
import com.sromku.simple.fb.listeners.OnProfileListener;
import com.sromku.simple.fb.listeners.OnPublishListener;
import com.sromku.simple.fb.listeners.OnScoresListener;
import com.sromku.simple.fb.listeners.OnStoryObjectsListener;
import com.sromku.simple.fb.listeners.OnVideosListener;
import com.sromku.simple.fb.utils.Utils;
import java.util.List;
import java.util.Set;

public class SimpleFacebook {
    private static SimpleFacebook mInstance = null;
    private static SimpleFacebookConfiguration mConfiguration = new SimpleFacebookConfiguration.Builder().build();
    private static SessionManager mSessionManager = null;

    private SimpleFacebook() {
    }

    public static void initialize(Activity activity) {
        if (mInstance == null) {
            FacebookSdk.sdkInitialize((Context)activity.getApplicationContext());
            mInstance = new SimpleFacebook();
            mSessionManager = new SessionManager(mConfiguration);
        }
        mSessionManager.setActivity(activity);
    }

    public static SimpleFacebook getInstance(Activity activity) {
        if (mInstance == null) {
            FacebookSdk.sdkInitialize((Context)activity.getApplicationContext());
            mInstance = new SimpleFacebook();
            mSessionManager = new SessionManager(mConfiguration);
        }
        mSessionManager.setActivity(activity);
        return mInstance;
    }

    public static SimpleFacebook getInstance() {
        return mInstance;
    }

    public static void setConfiguration(SimpleFacebookConfiguration configuration) {
        mConfiguration = configuration;
        SessionManager.configuration = configuration;
    }

    public static SimpleFacebookConfiguration getConfiguration() {
        return mConfiguration;
    }

    public void login(OnLoginListener onLoginListener) {
        mSessionManager.login(onLoginListener);
    }

    public void logout(OnLogoutListener onLogoutListener) {
        mSessionManager.logout(onLogoutListener);
    }

    public boolean isLogin() {
        return mSessionManager.isLogin();
    }

    public <T> void get(String entityId, String edge, final Bundle bundle, OnActionListener<T> onActionListener) {
        GetAction getAction = new GetAction<T>(mSessionManager){

            @Override
            protected Bundle getBundle() {
                if (bundle != null) {
                    return bundle;
                }
                return super.getBundle();
            }
        };
        getAction.setActionListener(onActionListener);
        getAction.setTarget(entityId);
        getAction.setEdge(edge);
        getAction.execute();
    }

    public void getAccounts(OnAccountsListener onAccountsListener) {
        GetAccountsAction getAccountsAction = new GetAccountsAction(mSessionManager);
        getAccountsAction.setActionListener(onAccountsListener);
        getAccountsAction.execute();
    }

    public void getAlbum(String albumId, OnAlbumListener onAlbumListener) {
        GetAlbumAction getAlbumAction = new GetAlbumAction(mSessionManager);
        getAlbumAction.setActionListener(onAlbumListener);
        getAlbumAction.setTarget(albumId);
        getAlbumAction.execute();
    }

    public void getAlbums(OnAlbumsListener onAlbumsListener) {
        GetAlbumsAction getAlbumsAction = new GetAlbumsAction(mSessionManager);
        getAlbumsAction.setActionListener(onAlbumsListener);
        getAlbumsAction.execute();
    }

    public void getAlbums(String entityId, OnAlbumsListener onAlbumsListener) {
        GetAlbumsAction getAlbumsAction = new GetAlbumsAction(mSessionManager);
        getAlbumsAction.setActionListener(onAlbumsListener);
        getAlbumsAction.setTarget(entityId);
        getAlbumsAction.execute();
    }

    public void getAppRequests(OnAppRequestsListener onAppRequestsListener) {
        GetAppRequestsAction getAppRequestsAction = new GetAppRequestsAction(mSessionManager);
        getAppRequestsAction.setActionListener(onAppRequestsListener);
        getAppRequestsAction.execute();
    }

    public void getAttachment(String entityId, OnAttachmentListener onAttachmentListener) {
        GetAttachmentAction getAttachmentAction = new GetAttachmentAction(mSessionManager);
        getAttachmentAction.setActionListener(onAttachmentListener);
        getAttachmentAction.setTarget(entityId);
        getAttachmentAction.execute();
    }

    public void getBooks(OnPagesListener onPagesListener) {
        this.getBooks(null, null, onPagesListener);
    }

    public void getBooks(Page.Properties properties, OnPagesListener onPagesListener) {
        this.getBooks(null, properties, onPagesListener);
    }

    public void getBooks(String entityId, OnPagesListener onPagesListener) {
        this.getBooks(entityId, null, onPagesListener);
    }

    public void getBooks(String entityId, Page.Properties properties, OnPagesListener onPagesListener) {
        GetPagesAction getPagesAction = new GetPagesAction(mSessionManager);
        getPagesAction.setActionListener(onPagesListener);
        getPagesAction.setProperties(properties);
        getPagesAction.setTarget(entityId);
        getPagesAction.setEdge("books");
        getPagesAction.execute();
    }

    public void getComment(String commentId, OnCommentListener onCommentListener) {
        GetCommentAction getCommentAction = new GetCommentAction(mSessionManager);
        getCommentAction.setActionListener(onCommentListener);
        getCommentAction.setTarget(commentId);
        getCommentAction.execute();
    }

    public void getComments(String entityId, OnCommentsListener onCommentsListener) {
        GetCommentsAction getCommentsAction = new GetCommentsAction(mSessionManager);
        getCommentsAction.setActionListener(onCommentsListener);
        getCommentsAction.setTarget(entityId);
        getCommentsAction.execute();
    }

    public void getEvents(Event.EventDecision eventDecision, OnEventsListener onEventsListener) {
        GetEventsAction getEventsAction = new GetEventsAction(mSessionManager);
        getEventsAction.setActionListener(onEventsListener);
        getEventsAction.setEventDecision(eventDecision);
        getEventsAction.execute();
    }

    public void getEvents(String entityId, Event.EventDecision eventDecision, OnEventsListener onEventsListener) {
        GetEventsAction getEventsAction = new GetEventsAction(mSessionManager);
        getEventsAction.setActionListener(onEventsListener);
        getEventsAction.setEventDecision(eventDecision);
        getEventsAction.setTarget(entityId);
        getEventsAction.execute();
    }

    public void getFamily(OnFamilyListener onFamilyListener) {
        GetFamilyAction getFamilyAction = new GetFamilyAction(mSessionManager);
        getFamilyAction.setActionListener(onFamilyListener);
        getFamilyAction.execute();
    }

    public void getFamily(String entityId, OnFamilyListener onFamilyListener) {
        GetFamilyAction getFamilyAction = new GetFamilyAction(mSessionManager);
        getFamilyAction.setActionListener(onFamilyListener);
        getFamilyAction.setTarget(entityId);
        getFamilyAction.execute();
    }

    public void getFriends(OnFriendsListener onFriendsListener) {
        this.getFriends(null, onFriendsListener);
    }

    public void getFriends(Profile.Properties properties, OnFriendsListener onFriendsListener) {
        GetFriendsAction getFriendsAction = new GetFriendsAction(mSessionManager);
        getFriendsAction.setProperties(properties);
        getFriendsAction.setActionListener(onFriendsListener);
        getFriendsAction.execute();
    }

    public void getTaggableFriends(OnFriendsListener onFriendsListener) {
        this.getTaggableFriends(null, onFriendsListener);
    }

    public void getTaggableFriends(Profile.Properties properties, OnFriendsListener onFriendsListener) {
        GetTaggableFriendsAction getFriendsAction = new GetTaggableFriendsAction(mSessionManager);
        getFriendsAction.setProperties(properties);
        getFriendsAction.setActionListener(onFriendsListener);
        getFriendsAction.execute();
    }

    public void getInvitableFriends(OnFriendsListener onFriendsListener) {
        this.getInvitableFriends(null, onFriendsListener);
    }

    public void getInvitableFriends(Profile.Properties properties, OnFriendsListener onFriendsListener) {
        GetInvitableFriendsAction getFriendsAction = new GetInvitableFriendsAction(mSessionManager);
        getFriendsAction.setProperties(properties);
        getFriendsAction.setActionListener(onFriendsListener);
        getFriendsAction.execute();
    }

    public void getGames(OnPagesListener onPagesListener) {
        this.getGames(null, null, onPagesListener);
    }

    public void getGames(Page.Properties properties, OnPagesListener onPagesListener) {
        this.getGames(null, properties, onPagesListener);
    }

    public void getGames(String entityId, OnPagesListener onPagesListener) {
        this.getGames(entityId, null, onPagesListener);
    }

    public void getGames(String entityId, Page.Properties properties, OnPagesListener onPagesListener) {
        GetPagesAction getPagesAction = new GetPagesAction(mSessionManager);
        getPagesAction.setActionListener(onPagesListener);
        getPagesAction.setProperties(properties);
        getPagesAction.setTarget(entityId);
        getPagesAction.setEdge("games");
        getPagesAction.execute();
    }

    public void getGroups(OnGroupsListener onGroupsListener) {
        GetGroupsAction getGroupsAction = new GetGroupsAction(mSessionManager);
        getGroupsAction.setActionListener(onGroupsListener);
        getGroupsAction.execute();
    }

    public void getGroups(String entityId, OnGroupsListener onGroupsListener) {
        GetGroupsAction getGroupsAction = new GetGroupsAction(mSessionManager);
        getGroupsAction.setActionListener(onGroupsListener);
        getGroupsAction.setTarget(entityId);
        getGroupsAction.execute();
    }

    public void getLikes(String entityId, OnLikesListener onLikesListener) {
        GetLikesAction getLikesAction = new GetLikesAction(mSessionManager);
        getLikesAction.setActionListener(onLikesListener);
        getLikesAction.setTarget(entityId);
        getLikesAction.execute();
    }

    public void getMovies(OnPagesListener onPagesListener) {
        this.getMovies(null, null, onPagesListener);
    }

    public void getMovies(Page.Properties properties, OnPagesListener onPagesListener) {
        this.getMovies(null, properties, onPagesListener);
    }

    public void getMovies(String entityId, OnPagesListener onPagesListener) {
        this.getMovies(entityId, null, onPagesListener);
    }

    public void getMovies(String entityId, Page.Properties properties, OnPagesListener onPagesListener) {
        GetPagesAction getPagesAction = new GetPagesAction(mSessionManager);
        getPagesAction.setActionListener(onPagesListener);
        getPagesAction.setProperties(properties);
        getPagesAction.setTarget(entityId);
        getPagesAction.setEdge("movies");
        getPagesAction.execute();
    }

    public void getMusic(OnPagesListener onPagesListener) {
        this.getMusic(null, null, onPagesListener);
    }

    public void getMusic(Page.Properties properties, OnPagesListener onPagesListener) {
        this.getMusic(null, properties, onPagesListener);
    }

    public void getMusic(String entityId, OnPagesListener onPagesListener) {
        this.getMusic(entityId, null, onPagesListener);
    }

    public void getMusic(String entityId, Page.Properties properties, OnPagesListener onPagesListener) {
        GetPagesAction getPageAction = new GetPagesAction(mSessionManager);
        getPageAction.setActionListener(onPagesListener);
        getPageAction.setProperties(properties);
        getPageAction.setTarget(entityId);
        getPageAction.setEdge("music");
        getPageAction.execute();
    }

    public void getNotifications(OnNotificationsListener onNotificationsListener) {
        GetNotificationsAction getNotificationsAction = new GetNotificationsAction(mSessionManager);
        getNotificationsAction.setActionListener(onNotificationsListener);
        getNotificationsAction.execute();
    }

    public void getPage(String entityId, OnPageListener onPageListener) {
        GetPageAction getPageAction = new GetPageAction(mSessionManager);
        getPageAction.setActionListener(onPageListener);
        getPageAction.setTarget(entityId);
        getPageAction.execute();
    }

    public void getPage(String entityId, Page.Properties properties, OnPageListener onPageListener) {
        GetPageAction getPageAction = new GetPageAction(mSessionManager);
        getPageAction.setActionListener(onPageListener);
        getPageAction.setTarget(entityId);
        getPageAction.setProperties(properties);
        getPageAction.execute();
    }

    public void getPages(OnPagesListener onPagesListener) {
        GetPagesAction getPagesAction = new GetPagesAction(mSessionManager);
        getPagesAction.setActionListener(onPagesListener);
        getPagesAction.setEdge("likes");
        getPagesAction.execute();
    }

    public void getPhoto(String entityId, OnPhotoListener onPhotoListener) {
        GetPhotoAction getPhotoAction = new GetPhotoAction(mSessionManager);
        getPhotoAction.setActionListener(onPhotoListener);
        getPhotoAction.setTarget(entityId);
        getPhotoAction.execute();
    }

    public void getPhotos(OnPhotosListener onPhotosListener) {
        GetPhotosAction getPhotosAction = new GetPhotosAction(mSessionManager);
        getPhotosAction.setActionListener(onPhotosListener);
        getPhotosAction.execute();
    }

    public void getPhotos(String entityId, OnPhotosListener onPhotosListener) {
        GetPhotosAction getPhotosAction = new GetPhotosAction(mSessionManager);
        getPhotosAction.setActionListener(onPhotosListener);
        getPhotosAction.setTarget(entityId);
        getPhotosAction.execute();
    }

    public void getProfile(OnProfileListener onProfileListener) {
        this.getProfile(null, null, onProfileListener);
    }

    public void getProfile(String profileId, OnProfileListener onProfileListener) {
        this.getProfile(profileId, null, onProfileListener);
    }

    public void getProfile(Profile.Properties properties, OnProfileListener onProfileListener) {
        this.getProfile(null, properties, onProfileListener);
    }

    public void getProfile(String profileId, Profile.Properties properties, OnProfileListener onProfileListener) {
        GetProfileAction getProfileAction = new GetProfileAction(mSessionManager);
        getProfileAction.setProperties(properties);
        getProfileAction.setTarget(profileId);
        getProfileAction.setActionListener(onProfileListener);
        getProfileAction.execute();
    }

    public void getPosts(OnPostsListener onPostsListener) {
        GetPostsAction getPostsAction = new GetPostsAction(mSessionManager);
        getPostsAction.setActionListener(onPostsListener);
        getPostsAction.execute();
    }

    public void getPosts(Post.PostType postType, OnPostsListener onPostsListener) {
        GetPostsAction getPostsAction = new GetPostsAction(mSessionManager);
        getPostsAction.setActionListener(onPostsListener);
        getPostsAction.setPostType(postType);
        getPostsAction.execute();
    }

    public void getPosts(String entityId, OnPostsListener onPostsListener) {
        this.getPosts(entityId, Post.PostType.ALL, onPostsListener);
    }

    public void getPosts(String entityId, Post.PostType postType, OnPostsListener onPostsListener) {
        GetPostsAction getPostsAction = new GetPostsAction(mSessionManager);
        getPostsAction.setActionListener(onPostsListener);
        getPostsAction.setTarget(entityId);
        getPostsAction.setPostType(postType);
        getPostsAction.execute();
    }

    public void getScores(OnScoresListener onScoresListener) {
        GetScoresAction getScoresAction = new GetScoresAction(mSessionManager);
        getScoresAction.setActionListener(onScoresListener);
        getScoresAction.execute();
    }

    public void getStoryObjects(String objectName, OnStoryObjectsListener onStoryObjectsListener) {
        GetStoryObjectsAction getStoryObjectsAction = new GetStoryObjectsAction(mSessionManager);
        getStoryObjectsAction.setObjectName(objectName);
        getStoryObjectsAction.setActionListener(onStoryObjectsListener);
        getStoryObjectsAction.execute();
    }

    public void getTelevision(OnPagesListener onPagesListener) {
        this.getTelevision(null, null, onPagesListener);
    }

    public void getTelevision(Page.Properties properties, OnPagesListener onPagesListener) {
        this.getTelevision(null, properties, onPagesListener);
    }

    public void getTelevision(String entityId, OnPagesListener onPagesListener) {
        this.getTelevision(entityId, null, onPagesListener);
    }

    public void getTelevision(String entityId, Page.Properties properties, OnPagesListener onPagesListener) {
        GetPagesAction getPagesAction = new GetPagesAction(mSessionManager);
        getPagesAction.setActionListener(onPagesListener);
        getPagesAction.setProperties(properties);
        getPagesAction.setTarget(entityId);
        getPagesAction.setEdge("television");
        getPagesAction.execute();
    }

    public void getVideos(OnVideosListener onVideosListener) {
        GetVideosAction getVideosAction = new GetVideosAction(mSessionManager);
        getVideosAction.setActionListener(onVideosListener);
        getVideosAction.execute();
    }

    public void getVideos(String entityId, OnVideosListener onVideosListener) {
        GetVideosAction getVideosAction = new GetVideosAction(mSessionManager);
        getVideosAction.setActionListener(onVideosListener);
        getVideosAction.setTarget(entityId);
        getVideosAction.execute();
    }

    public void publish(String entityId, Comment comment, OnPublishListener onPublishListener) {
        this.publish(entityId, (Publishable)comment, onPublishListener);
    }

    public void publish(String entityId, Like like, OnPublishListener onPublishListener) {
        this.publish(entityId, (Publishable)like, onPublishListener);
    }

    public void publish(Score score, OnPublishListener onPublishListener) {
        this.publish("me", score, onPublishListener);
    }

    public void publish(String entityId, Feed feed, OnPublishListener onPublishListener) {
        this.publish(entityId, (Publishable)feed, onPublishListener);
    }

    public void publish(Feed feed, OnPublishListener onPublishListener) {
        this.publish("me", (Publishable)feed, onPublishListener);
    }

    public void publish(Feed feed, boolean withDialog, OnPublishListener onPublishListener) {
        if (!withDialog) {
            this.publish(feed, onPublishListener);
        } else {
            PublishFeedDialogAction publishFeedDialogAction = new PublishFeedDialogAction(mSessionManager);
            publishFeedDialogAction.setFeed(feed);
            publishFeedDialogAction.setOnPublishListener(onPublishListener);
            publishFeedDialogAction.execute();
        }
    }

    public void publish(Story story, OnPublishListener onPublishListener) {
        this.publish("me", story, onPublishListener);
    }

    public void publish(Story story, boolean withDialog, OnPublishListener onPublishListener) {
        if (!withDialog) {
            this.publish(story, onPublishListener);
        } else {
            PublishStoryDialogAction publishStoryDialogAction = new PublishStoryDialogAction(mSessionManager);
            publishStoryDialogAction.setStory(story);
            publishStoryDialogAction.setOnPublishListener(onPublishListener);
            publishStoryDialogAction.execute();
        }
    }

    public void publish(Album album, OnPublishListener onPublishListener) {
        this.publish("me", album, onPublishListener);
    }

    public void publish(Photo photo, String albumId, OnPublishListener onPublishListener) {
        this.publish(albumId, photo, onPublishListener);
    }

    public void publish(Photo photo, boolean withDialog, OnPublishListener onPublishListener) {
        if (!withDialog) {
            this.publish("me", photo, onPublishListener);
        } else {
            List<Photo> photos = Utils.createSingleItemList(photo);
            PublishPhotoDialogAction publishPhotoDialogAction = new PublishPhotoDialogAction(mSessionManager);
            publishPhotoDialogAction.setPhotos(photos);
            publishPhotoDialogAction.setPlace(photo.getPlaceId());
            publishPhotoDialogAction.setOnPublishListener(onPublishListener);
            publishPhotoDialogAction.execute();
        }
    }

    public void publish(List<Photo> photos, OnPublishListener onPublishListener) {
        PublishPhotoDialogAction publishPhotoDialogAction = new PublishPhotoDialogAction(mSessionManager);
        publishPhotoDialogAction.setPhotos(photos);
        publishPhotoDialogAction.setPlace(photos.get(0).getPlaceId());
        publishPhotoDialogAction.setOnPublishListener(onPublishListener);
        publishPhotoDialogAction.execute();
    }

    public void publish(Video video, OnPublishListener onPublishListener) {
        this.publish("me", video, onPublishListener);
    }

    public void publish(String entityId, Publishable publishable, OnPublishListener onPublishListener) {
        PublishAction publishAction = new PublishAction(mSessionManager);
        publishAction.setPublishable(publishable);
        publishAction.setTarget(entityId);
        publishAction.setOnPublishListener(onPublishListener);
        publishAction.execute();
    }

    public void invite(String message, OnInviteListener onInviteListener, String data) {
        InviteAction inviteAction = new InviteAction(mSessionManager);
        inviteAction.setMessage(message);
        inviteAction.setData(data);
        inviteAction.setOnInviteListener(onInviteListener);
        inviteAction.execute();
    }

    public void invite(String to, String message, OnInviteListener onInviteListener, String data) {
        InviteAction inviteAction = new InviteAction(mSessionManager);
        inviteAction.setTo(to);
        inviteAction.setMessage(message);
        inviteAction.setData(data);
        inviteAction.setOnInviteListener(onInviteListener);
        inviteAction.execute();
    }

    public void invite(String[] suggestedFriends, String message, OnInviteListener onInviteListener, String data) {
        InviteAction inviteAction = new InviteAction(mSessionManager);
        inviteAction.setSuggestions(suggestedFriends);
        inviteAction.setMessage(message);
        inviteAction.setData(data);
        inviteAction.setOnInviteListener(onInviteListener);
        inviteAction.execute();
    }

    public void create(Story.StoryObject storyObject, OnCreateStoryObject onCreateStoryObject) {
        this.publish("me", storyObject, (OnPublishListener)onCreateStoryObject);
    }

    public void deleteRequest(String inRequestId, OnDeleteListener onDeleteListener) {
        DeleteRequestAction deleteRequestAction = new DeleteRequestAction(mSessionManager);
        deleteRequestAction.setRequestId(inRequestId);
        deleteRequestAction.setOnDeleteListener(onDeleteListener);
        deleteRequestAction.execute();
    }

    public void requestNewPermissions(Permission[] permissions, OnNewPermissionsListener onNewPermissionsListener) {
        mSessionManager.requestNewPermissions(permissions, onNewPermissionsListener);
    }

    public Set<String> getGrantedPermissions() {
        return mSessionManager.getAcceptedPermissions();
    }

    public boolean isAllPermissionsGranted() {
        return mSessionManager.isAllPermissionsGranted();
    }

    public String getAccessToken() {
        return mSessionManager.getAccessToken().getToken();
    }

    public void eventAppLaunched() {
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        mSessionManager.onActivityResult(requestCode, resultCode, data);
    }

    public void clean() {
        mSessionManager.clean();
    }
}

