/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Base64;
import com.facebook.GraphResponse;
import com.facebook.share.model.SharePhoto;
import com.google.gson.reflect.TypeToken;
import com.sromku.simple.fb.entities.IdName;
import com.sromku.simple.fb.entities.Photo;
import com.sromku.simple.fb.entities.Story;
import com.sromku.simple.fb.entities.User;
import com.sromku.simple.fb.utils.JsonUtils;
import com.sromku.simple.fb.utils.Logger;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Utils {
    public static final String EMPTY = "";
    public static final String CHARSET_NAME = "UTF-8";

    public String getFacebookSDKVersion() {
        String sdkVersion = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Class<?> cls = classLoader.loadClass("com.facebook.FacebookSdkVersion");
            Field field = cls.getField("BUILD");
            sdkVersion = String.valueOf(field.get(null));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return sdkVersion;
    }

    public static String getHashKey(Context context) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature[] arr$ = info.signatures;
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                Signature signature = arr$[i$];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)0);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? EMPTY : first.toString();
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static <T> String join(Iterator<T> iterator, String separator, Process<T> process) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? EMPTY : process.process(first);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(process.process(first));
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            T obj = iterator.next();
            if (obj == null) continue;
            buf.append(process.process(obj));
        }
        return buf.toString();
    }

    public static String join(Map<?, ?> map, char separator, char valueStartChar, char valueEndChar) {
        if (map == null) {
            return null;
        }
        if (map.size() == 0) {
            return EMPTY;
        }
        StringBuilder buf = new StringBuilder(256);
        boolean isFirst = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (isFirst) {
                buf.append(entry.getKey());
                buf.append(valueStartChar);
                buf.append(entry.getValue());
                buf.append(valueEndChar);
                isFirst = false;
                continue;
            }
            buf.append(separator);
            buf.append(entry.getKey());
            buf.append(valueStartChar);
            buf.append(entry.getValue());
            buf.append(valueEndChar);
        }
        return buf.toString();
    }

    public static List<String> extract(List<IdName> idNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (IdName idName : idNames) {
            names.add(idName.getName());
        }
        return names;
    }

    public static List<User> extractUsers(List<IdName> idNames) {
        ArrayList<User> users = new ArrayList<User>();
        for (IdName idName : idNames) {
            users.add(new User(idName));
        }
        return users;
    }

    public static <T> List<T> typedListFromResponse(GraphResponse response) {
        return (List)JsonUtils.fromJson(response.getRawResponse(), new TypeToken<List<T>>(){}.getType());
    }

    public static <T> List<T> typedListFromResponse(String raw) {
        return (List)JsonUtils.fromJson(raw, new TypeToken<List<T>>(){}.getType());
    }

    public static <T> T convert(GraphResponse response, Type type) {
        return JsonUtils.fromJson(response.getRawResponse(), type);
    }

    public static <T> T convert(String json, Type type) {
        return JsonUtils.fromJson(json, type);
    }

    public static User convert(IdName idName) {
        return new User(idName.getId(), idName.getName());
    }

    public static String encodeUrl(Bundle parameters) {
        if (parameters == null) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : parameters.keySet()) {
            Object parameter = parameters.get(key);
            if (!(parameter instanceof String)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            try {
                sb.append(URLEncoder.encode(key, CHARSET_NAME)).append("=").append(URLEncoder.encode(parameters.getString(key), CHARSET_NAME));
            }
            catch (UnsupportedEncodingException e) {
                Logger.logError(Story.class, "Error enconding URL", e);
            }
        }
        return sb.toString();
    }

    public static String encode(String key, String data) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            mac.init(secretKey);
            byte[] bytes = mac.doFinal(data.getBytes());
            StringBuilder sb = new StringBuilder(bytes.length * 2);
            Formatter formatter = new Formatter(sb);
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            return sb.toString();
        }
        catch (Exception e) {
            Logger.logError(Utils.class, "Failed to create sha256", e);
            return null;
        }
    }

    public static List<SharePhoto> extractBitmaps(List<Photo> photos) {
        ArrayList<SharePhoto> bitmaps = new ArrayList<SharePhoto>();
        for (Photo photo : photos) {
            Parcelable parcelable = photo.getParcelable();
            if (!(parcelable instanceof Bitmap)) continue;
            SharePhoto sharePhoto = new SharePhoto.Builder().setBitmap((Bitmap)parcelable).build();
            bitmaps.add(sharePhoto);
        }
        return bitmaps;
    }

    public static <T> List<T> createSingleItemList(T t) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(t);
        return list;
    }

    public static interface Process<T> {
        public String process(T var1);
    }

    public static class SingleDataResult<T> {
        public T data;

        public String toString() {
            if (this.data != null) {
                return this.data.toString();
            }
            return super.toString();
        }
    }

    public static class DataResult<T> {
        public List<T> data;
    }
}

