/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.utils;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logger {
    public static boolean DEBUG = false;
    public static boolean DEBUG_WITH_STACKTRACE = false;

    public static <T> void logInfo(Class<T> cls, String message) {
        if (DEBUG || DEBUG_WITH_STACKTRACE) {
            String tag = cls.getName();
            Log.i((String)tag, (String)"-----");
            Log.i((String)tag, (String)((Object)((Object)LogType.INFO) + ": " + message));
            if (DEBUG_WITH_STACKTRACE) {
                Log.i((String)tag, (String)Logger.getStackTrace());
            }
        }
    }

    public static <T> void logWarning(Class<T> cls, String message) {
        if (DEBUG || DEBUG_WITH_STACKTRACE) {
            String tag = cls.getName();
            Log.w((String)tag, (String)"-----");
            Log.w((String)tag, (String)((Object)((Object)LogType.WARNING) + ": " + message));
            if (DEBUG_WITH_STACKTRACE) {
                Log.w((String)tag, (String)Logger.getStackTrace());
            }
        }
    }

    public static <T> void logError(Class<T> cls, String message) {
        if (DEBUG || DEBUG_WITH_STACKTRACE) {
            String tag = cls.getName();
            Log.e((String)tag, (String)"-----");
            Log.e((String)tag, (String)((Object)((Object)LogType.ERROR) + ": " + message));
            if (DEBUG_WITH_STACKTRACE) {
                Log.e((String)tag, (String)Logger.getStackTrace());
            }
        }
    }

    public static <T> void logError(Class<T> cls, String message, Throwable e) {
        if (DEBUG || DEBUG_WITH_STACKTRACE) {
            String tag = cls.getName();
            Log.e((String)tag, (String)"-----");
            Log.e((String)tag, (String)((Object)((Object)LogType.ERROR) + ": " + message), (Throwable)e);
            if (DEBUG_WITH_STACKTRACE) {
                Log.e((String)tag, (String)Logger.getStackTrace());
            }
        }
    }

    private static String getStackTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Throwable().printStackTrace(pw);
        return sw.toString();
    }

    private static enum LogType {
        INFO,
        WARNING,
        ERROR;

    }
}

