/*
 * Decompiled with CFR 0.152.
 */
package com.sromku.simple.fb.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class JsonUtils {
    private static Gson buildGson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).create();
        return gson;
    }

    public static String toJson(Object obj) {
        Gson gson = JsonUtils.buildGson();
        return gson.toJson(obj);
    }

    public static <T> T fromJson(String json, Class<T> cls) {
        Gson gson = JsonUtils.buildGson();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (cls != null && cls.isArray() && !(element instanceof JsonArray)) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(element);
            Type listType = new TypeToken<T>(){}.getType();
            return (T)gson.fromJson((JsonElement)jsonArray, listType);
        }
        return (T)gson.fromJson(json, cls);
    }

    public static <T> T fromJson(byte[] json, Class<T> cls) {
        try {
            String decoded = new String(json, "UTF-8");
            return JsonUtils.fromJson(decoded, cls);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T fromJson(byte[] bytes, Type type) {
        try {
            String decoded = new String(bytes, "UTF-8");
            return JsonUtils.fromJson(decoded, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T fromJson(String json, Type type) {
        Gson gson = JsonUtils.buildGson();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        return (T)gson.fromJson(element, type);
    }

    public static <T> T fromJsonExcludeFields(String json, Class<T> cls) {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (cls.isArray() && !(element instanceof JsonArray)) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(element);
            Type listType = new TypeToken<T>(){}.getType();
            return (T)gson.fromJson((JsonElement)jsonArray, listType);
        }
        return (T)gson.fromJson(json, cls);
    }

    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private static List<DateFormat> formats;

        private static DateFormat createDateFormat(String format) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }

        private DateTypeAdapter() {
            formats = new ArrayList<DateFormat>();
            formats.add(DateTypeAdapter.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
            formats.add(DateTypeAdapter.createDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            formats.add(DateTypeAdapter.createDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
            formats.add(DateTypeAdapter.createDateFormat("yyyy-MM-dd"));
        }

        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            for (DateFormat dateFormat : formats) {
                try {
                    return new JsonPrimitive(dateFormat.format(date));
                }
                catch (Exception e) {
                }
            }
            return null;
        }

        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            Exception le = null;
            String dateString = jsonElement.getAsString();
            for (DateFormat dateFormat : formats) {
                try {
                    return dateFormat.parse(dateString);
                }
                catch (Exception e) {
                    le = e;
                }
            }
            throw new JsonParseException(le);
        }
    }
}

