/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.util.ByteList;

public final class StringSupport {
    public static final int CR_UNKNOWN = 0;
    public static final int CR_7BIT = 16;
    public static final int CR_VALID = 32;
    public static final int CR_BROKEN = 48;
    private static final long NONASCII_MASK = -9187201950435737472L;

    public static List<String> split(String str, char sep) {
        return StringSupport.split(str, sep, 0);
    }

    public static List<String> split(String str, char sep, int lim) {
        int e;
        int len = str.length();
        if (len == 0) {
            return Collections.singletonList(str);
        }
        ArrayList<String> result = new ArrayList<String>(lim <= 0 ? 8 : lim);
        int s = 0;
        int count = 0;
        while ((e = str.indexOf(sep, s)) != -1) {
            if (lim == ++count) {
                result.add(str.substring(s));
                return result;
            }
            result.add(str.substring(s, e));
            s = e + 1;
        }
        if (s < len || s == len && lim > 0) {
            result.add(str.substring(s));
        }
        return result;
    }

    public static int encFastMBCLen(byte[] bytes, int p, int e, Encoding enc) {
        return enc.length(bytes, p, e);
    }

    public static int length(Encoding enc, byte[] bytes, int p, int end) {
        int n = enc.length(bytes, p, end);
        if (StringSupport.MBCLEN_CHARFOUND_P(n) && StringSupport.MBCLEN_CHARFOUND_LEN(n) <= end - p) {
            return StringSupport.MBCLEN_CHARFOUND_LEN(n);
        }
        int min = enc.minLength();
        return min <= end - p ? min : end - p;
    }

    public static int preciseLength(Encoding enc, byte[] bytes, int p, int end) {
        if (p >= end) {
            return -2;
        }
        int n = enc.length(bytes, p, end);
        if (n > end - p) {
            return StringSupport.MBCLEN_NEEDMORE(n - (end - p));
        }
        return n;
    }

    public static boolean MBCLEN_NEEDMORE_P(int r) {
        return r < -1;
    }

    public static int MBCLEN_NEEDMORE(int n) {
        return -1 - n;
    }

    public static int MBCLEN_NEEDMORE_LEN(int r) {
        return -1 - r;
    }

    public static boolean MBCLEN_INVALID_P(int r) {
        return r == -1;
    }

    public static int MBCLEN_CHARFOUND_LEN(int r) {
        return r;
    }

    public static boolean MBCLEN_CHARFOUND_P(int r) {
        return 0 < r;
    }

    public static int CONSTRUCT_MBCLEN_CHARFOUND(int n) {
        return n;
    }

    public static int searchNonAscii(byte[] bytes, int p, int end) {
        while (p < end) {
            if (!Encoding.isAscii((byte)bytes[p])) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public static int searchNonAscii(ByteList bytes) {
        return StringSupport.searchNonAscii(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getBegin() + bytes.getRealSize());
    }

    public static int codeRangeScan(Encoding enc, byte[] bytes, int p, int len) {
        if (enc == ASCIIEncoding.INSTANCE) {
            return StringSupport.searchNonAscii(bytes, p, p + len) != -1 ? 32 : 16;
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.codeRangeScanAsciiCompatible(enc, bytes, p, len);
        }
        return StringSupport.codeRangeScanNonAsciiCompatible(enc, bytes, p, len);
    }

    private static int codeRangeScanAsciiCompatible(Encoding enc, byte[] bytes, int p, int len) {
        int end = p + len;
        if ((p = StringSupport.searchNonAscii(bytes, p, end)) == -1) {
            return 16;
        }
        while (p < end) {
            int cl = StringSupport.preciseLength(enc, bytes, p, end);
            if (cl <= 0) {
                return 48;
            }
            if ((p += cl) >= end || (p = StringSupport.searchNonAscii(bytes, p, end)) != -1) continue;
            return 32;
        }
        return p > end ? 48 : 32;
    }

    private static int codeRangeScanNonAsciiCompatible(Encoding enc, byte[] bytes, int p, int len) {
        int end = p + len;
        while (p < end) {
            int cl = StringSupport.preciseLength(enc, bytes, p, end);
            if (cl <= 0) {
                return 48;
            }
            p += cl;
        }
        return p > end ? 48 : 32;
    }

    public static int codeRangeScan(Encoding enc, ByteList bytes) {
        return StringSupport.codeRangeScan(enc, bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getRealSize());
    }

    private static int countUtf8LeadBytes(long d) {
        d |= d >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
        d >>>= 6;
        d &= 0x101010101010101L;
        d += d >>> 8;
        d += d >>> 16;
        d += d >>> 32;
        return (int)(d & 0xFL);
    }

    public static int strLength(Encoding enc, byte[] bytes, int p, int e, int cr) {
        if (enc.isFixedWidth()) {
            return (e - p + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            int c = 0;
            if (cr == 16 || cr == 32) {
                while (p < e) {
                    if (Encoding.isAscii((byte)bytes[p])) {
                        int q = StringSupport.searchNonAscii(bytes, p, e);
                        if (q == -1) {
                            return c + (e - p);
                        }
                        c += q - p;
                        p = q;
                    }
                    p += StringSupport.encFastMBCLen(bytes, p, e, enc);
                    ++c;
                }
            } else {
                while (p < e) {
                    if (Encoding.isAscii((byte)bytes[p])) {
                        int q = StringSupport.searchNonAscii(bytes, p, e);
                        if (q == -1) {
                            return c + (e - p);
                        }
                        c += q - p;
                        p = q;
                    }
                    p += StringSupport.length(enc, bytes, p, e);
                    ++c;
                }
            }
            return c;
        }
        int c = 0;
        while (p < e) {
            p += StringSupport.length(enc, bytes, p, e);
            ++c;
        }
        return c;
    }

    public static long strLengthWithCodeRange(Encoding enc, byte[] bytes, int p, int end) {
        if (enc.isFixedWidth()) {
            return (end - p + enc.minLength() - 1) / enc.minLength();
        }
        if (enc.isAsciiCompatible()) {
            return StringSupport.strLengthWithCodeRangeAsciiCompatible(enc, bytes, p, end);
        }
        return StringSupport.strLengthWithCodeRangeNonAsciiCompatible(enc, bytes, p, end);
    }

    public static long strLengthWithCodeRangeAsciiCompatible(Encoding enc, byte[] bytes, int p, int end) {
        int cr = 0;
        int c = 0;
        while (p < end) {
            int cl;
            if (Encoding.isAscii((byte)bytes[p])) {
                int q = StringSupport.searchNonAscii(bytes, p, end);
                if (q == -1) {
                    return StringSupport.pack(c + (end - p), cr == 0 ? 16 : cr);
                }
                c += q - p;
                p = q;
            }
            if ((cl = StringSupport.preciseLength(enc, bytes, p, end)) > 0) {
                cr |= 0x20;
                p += cl;
            } else {
                cr = 48;
                ++p;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    public static long strLengthWithCodeRangeNonAsciiCompatible(Encoding enc, byte[] bytes, int p, int end) {
        int cr = 0;
        int c = 0;
        c = 0;
        while (p < end) {
            int cl = StringSupport.preciseLength(enc, bytes, p, end);
            if (cl > 0) {
                cr |= 0x20;
                p += cl;
            } else {
                cr = 48;
                ++p;
            }
            ++c;
        }
        return StringSupport.pack(c, cr == 0 ? 16 : cr);
    }

    public static long strLengthWithCodeRange(ByteList bytes) {
        return StringSupport.strLengthWithCodeRange(bytes.getEncoding(), bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getBegin() + bytes.getRealSize());
    }

    public static long strLengthWithCodeRange(ByteList bytes, Encoding enc) {
        return StringSupport.strLengthWithCodeRange(enc, bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getBegin() + bytes.getRealSize());
    }

    public static long pack(int result, int arg) {
        return (long)arg << 31 | (long)result;
    }

    public static int unpackResult(long len) {
        return (int)len & Integer.MAX_VALUE;
    }

    public static int unpackArg(long cr) {
        return (int)(cr >>> 31);
    }

    public static int codePoint(Encoding enc, byte[] bytes, int p, int end) {
        if (p >= end) {
            throw new IllegalArgumentException("empty string");
        }
        int cl = StringSupport.preciseLength(enc, bytes, p, end);
        if (cl <= 0) {
            throw new IllegalArgumentException("invalid byte sequence in " + enc);
        }
        return enc.mbcToCode(bytes, p, end);
    }

    public static int codeLength(Encoding enc, int c) {
        return enc.codeToMbcLength(c);
    }

    public static long getAscii(Encoding enc, byte[] bytes, int p, int end) {
        return StringSupport.getAscii(enc, bytes, p, end, 0);
    }

    public static long getAscii(Encoding enc, byte[] bytes, int p, int end, int len) {
        if (p >= end) {
            return StringSupport.pack(-1, len);
        }
        if (enc.isAsciiCompatible()) {
            int c = bytes[p] & 0xFF;
            if (!Encoding.isAscii((int)c)) {
                return StringSupport.pack(-1, len);
            }
            return StringSupport.pack(c, len == 0 ? 0 : 1);
        }
        int cl = StringSupport.preciseLength(enc, bytes, p, end);
        if (cl <= 0) {
            return StringSupport.pack(-1, len);
        }
        int c = enc.mbcToCode(bytes, p, end);
        if (!Encoding.isAscii((int)c)) {
            return StringSupport.pack(-1, len);
        }
        return StringSupport.pack(c, len == 0 ? 0 : cl);
    }

    public static int preciseCodePoint(Encoding enc, byte[] bytes, int p, int end) {
        int l = StringSupport.preciseLength(enc, bytes, p, end);
        if (l > 0) {
            return enc.mbcToCode(bytes, p, end);
        }
        return -1;
    }

    public static int utf8Nth(byte[] bytes, int p, int e, int nth) {
        while (p < e) {
            if ((bytes[p] & 0xC0) != 128) {
                if (nth == 0) break;
                --nth;
            }
            ++p;
        }
        return p;
    }

    public static int nth(Encoding enc, byte[] bytes, int p, int end, int n) {
        return StringSupport.nth(enc, bytes, p, end, n, enc.isSingleByte());
    }

    public static int nth(Encoding enc, byte[] bytes, int p, int end, int n, boolean singlebyte) {
        p = singlebyte ? (p += n) : (enc.isFixedWidth() ? (p += n * enc.maxLength()) : (enc.isAsciiCompatible() ? StringSupport.nthAsciiCompatible(enc, bytes, p, end, n) : StringSupport.nthNonAsciiCompatible(enc, bytes, p, end, n)));
        if (p < 0) {
            return -1;
        }
        return p > end ? end : p;
    }

    private static int nthAsciiCompatible(Encoding enc, byte[] bytes, int p, int end, int n) {
        while (p < end && n > 0) {
            int end2 = p + n;
            if (end < end2) {
                return end;
            }
            if (Encoding.isAscii((byte)bytes[p])) {
                int p2 = StringSupport.searchNonAscii(bytes, p, end2);
                if (p2 == -1) {
                    return end2;
                }
                n -= p2 - p;
                p = p2;
            }
            int cl = StringSupport.length(enc, bytes, p, end);
            p += cl;
            --n;
        }
        return n != 0 ? end : p;
    }

    private static int nthNonAsciiCompatible(Encoding enc, byte[] bytes, int p, int end, int n) {
        while (p < end && n-- != 0) {
            p += StringSupport.length(enc, bytes, p, end);
        }
        return p;
    }

    public static int utf8Offset(byte[] bytes, int p, int end, int n) {
        int pp = StringSupport.utf8Nth(bytes, p, end, n);
        return pp == -1 ? end - p : pp - p;
    }

    public static int offset(Encoding enc, byte[] bytes, int p, int end, int n) {
        int pp = StringSupport.nth(enc, bytes, p, end, n);
        return pp == -1 ? end - p : pp - p;
    }

    public static int offset(Encoding enc, byte[] bytes, int p, int end, int n, boolean singlebyte) {
        int pp = StringSupport.nth(enc, bytes, p, end, n, singlebyte);
        return pp == -1 ? end - p : pp - p;
    }

    public static int toLower(Encoding enc, int c) {
        return Encoding.isAscii((int)c) ? AsciiTables.ToLowerCaseTable[c] : c;
    }

    public static int toUpper(Encoding enc, int c) {
        return Encoding.isAscii((int)c) ? AsciiTables.ToUpperCaseTable[c] : c;
    }

    public static int caseCmp(byte[] bytes1, int p1, byte[] bytes2, int p2, int len) {
        int i = -1;
        while (++i < len && bytes1[p1 + i] == bytes2[p2 + i]) {
        }
        if (i < len) {
            return (bytes1[p1 + i] & 0xFF) > (bytes2[p2 + i] & 0xFF) ? 1 : -1;
        }
        return 0;
    }

    public static int scanHex(byte[] bytes, int p, int len) {
        return StringSupport.scanHex(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int scanHex(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isXDigit(c = bytes[p++] & 0xFF)) {
            v = (v << 4) + enc.xdigitVal(c);
        }
        return v;
    }

    public static int hexLength(byte[] bytes, int p, int len) {
        return StringSupport.hexLength(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int hexLength(byte[] bytes, int p, int len, Encoding enc) {
        int hlen = 0;
        while (len-- > 0 && enc.isXDigit(bytes[p++] & 0xFF)) {
            ++hlen;
        }
        return hlen;
    }

    public static int scanOct(byte[] bytes, int p, int len) {
        return StringSupport.scanOct(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int scanOct(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int v = 0;
        while (len-- > 0 && enc.isDigit(c = bytes[p++] & 0xFF) && c < 56) {
            v = (v << 3) + Encoding.digitVal((int)c);
        }
        return v;
    }

    public static int octLength(byte[] bytes, int p, int len) {
        return StringSupport.octLength(bytes, p, len, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public static int octLength(byte[] bytes, int p, int len, Encoding enc) {
        int c;
        int olen = 0;
        while (len-- > 0 && enc.isDigit(c = bytes[p++] & 0xFF) && c < 56) {
            ++olen;
        }
        return olen;
    }

    public static int bytesToFixBrokenTrailingCharacter(byte[] bytes, int begin, int byteSize, Encoding encoding, int usingLength) {
        if (byteSize > 0) {
            int charHead = encoding.leftAdjustCharHead(bytes, begin, begin + usingLength - 1, begin + usingLength);
            byte byteHead = (byte)(bytes[begin + (charHead -= begin)] & 0xFF);
            int extra = encoding.length(byteHead);
            return extra -= usingLength - charHead;
        }
        return 0;
    }

    public static int memchr(byte[] ptr, int start, int find, int len) {
        for (int i = start; i < start + len; ++i) {
            if (ptr[i] != find) continue;
            return i;
        }
        return -1;
    }

    private static int strNullChar(byte[] sBytes, int s, int len, int minlen, Encoding enc) {
        int e = s + len;
        while (s + minlen <= e) {
            if (StringSupport.zeroFilled(sBytes, s, minlen)) {
                return s;
            }
            s += enc.length(sBytes, s, e);
        }
        return -1;
    }

    private static boolean zeroFilled(byte[] sBytes, int s, int n) {
        while (n > 0) {
            if (sBytes[s++] != 0) {
                return false;
            }
            --n;
        }
        return true;
    }

    private static void TERM_FILL(byte[] ptr, int beg, int len, int termlen) {
        int p = beg + len;
        Arrays.fill(ptr, p, p + termlen, (byte)0);
    }

    public static boolean isEVStr(byte[] bytes, int p, int end) {
        return p < end ? StringSupport.isEVStr(bytes[p] & 0xFF) : false;
    }

    public static boolean isEVStr(int c) {
        return c == 36 || c == 64 || c == 123;
    }

    private static int strRindex(ByteList str, ByteList sub, int s, int pos, Encoding enc) {
        byte[] strBytes = str.unsafeBytes();
        byte[] subBytes = sub.unsafeBytes();
        int sbeg = str.begin();
        int e = str.begin() + str.realSize();
        int t = sub.begin();
        int slen = sub.realSize();
        while (s >= sbeg && s + slen <= sbeg + str.realSize()) {
            if (ByteList.memcmp((byte[])strBytes, (int)s, (byte[])subBytes, (int)t, (int)slen) == 0) {
                return pos;
            }
            if (pos == 0) break;
            --pos;
            s = enc.prevCharHead(strBytes, sbeg, s, e);
        }
        return -1;
    }

    public static enum NeighborChar {
        NOT_CHAR,
        FOUND,
        WRAPPED;

    }

    public static final class TR {
        final byte[] buf;
        int p;
        int pend;
        int now;
        int max;
        boolean gen;

        public TR(ByteList bytes) {
            this.p = bytes.getBegin();
            this.pend = bytes.getRealSize() + this.p;
            this.buf = bytes.getUnsafeBytes();
            this.max = 0;
            this.now = 0;
            this.gen = false;
        }
    }
}

