/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.SJISEncoding;
import org.jruby.util.ByteList;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.AndNode;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgsPushNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.AttrAssignNode;
import org.jrubyparser.ast.BackRefNode;
import org.jrubyparser.ast.BeginNode;
import org.jrubyparser.ast.BignumNode;
import org.jrubyparser.ast.BinaryOperatorNode;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.BlockPassNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.CaseNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2ConstNode;
import org.jrubyparser.ast.Colon2ImplicitNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ComplexNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DRegexpNode;
import org.jrubyparser.ast.DStrNode;
import org.jrubyparser.ast.DSymbolNode;
import org.jrubyparser.ast.DefinedNode;
import org.jrubyparser.ast.DotNode;
import org.jrubyparser.ast.EvStrNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.FalseNode;
import org.jrubyparser.ast.FixnumNode;
import org.jrubyparser.ast.FlipNode;
import org.jrubyparser.ast.FloatNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.KeywordArgNode;
import org.jrubyparser.ast.KeywordRestArgNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.Match2CaptureNode;
import org.jrubyparser.ast.Match2Node;
import org.jrubyparser.ast.Match3Node;
import org.jrubyparser.ast.MatchNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NthRefNode;
import org.jrubyparser.ast.NumericNode;
import org.jrubyparser.ast.OpAsgnConstDeclNode;
import org.jrubyparser.ast.OpAsgnNode;
import org.jrubyparser.ast.OpElementAsgnNode;
import org.jrubyparser.ast.OrNode;
import org.jrubyparser.ast.RationalNode;
import org.jrubyparser.ast.RegexpNode;
import org.jrubyparser.ast.RescueBodyNode;
import org.jrubyparser.ast.RescueModNode;
import org.jrubyparser.ast.RestArgNode;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.ast.SValueNode;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SuperNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.TrueNode;
import org.jrubyparser.ast.UndefNode;
import org.jrubyparser.ast.WhenNode;
import org.jrubyparser.ast.WhenOneArgNode;
import org.jrubyparser.ast.YieldNode;
import org.jrubyparser.ast.types.ILiteralNode;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.common.IRubyWarnings;
import org.jrubyparser.lexer.LexingCommon;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.lexer.yacc.ISourcePositionHolder;
import org.jrubyparser.lexer.yacc.RubyLexer;
import org.jrubyparser.lexer.yacc.SyntaxException;
import org.jrubyparser.parser.ArgsTailHolder;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.RubyParserResult;
import org.jrubyparser.parser.StaticScope;
import org.jrubyparser.parser.StaticScopeFactory;
import org.jrubyparser.util.KeyValuePair;
import org.jrubyparser.util.RegexpOptions;
import org.jrubyparser.util.StringSupport;

public class ParserSupport {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    protected StaticScope currentScope;
    protected RubyLexer lexer;
    private int inSingleton;
    private boolean inDefinition;
    protected IRubyWarnings warnings;
    protected ParserConfiguration configuration;
    private RubyParserResult result;

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        if (!this.currentScope.isBlockScope()) {
            this.lexer.getCmdArgumentState().reset(this.currentScope.getCommandArgumentStack());
        }
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = StaticScopeFactory.newBlockScope(this.currentScope, this.lexer.getFile());
    }

    public void pushLocalScope() {
        this.currentScope = StaticScopeFactory.newLocalScope(this.currentScope, this.lexer.getFile());
        this.currentScope.setCommandArgumentStack(this.lexer.getCmdArgumentState().getStack());
        this.lexer.getCmdArgumentState().reset(0L);
    }

    public Node arg_concat(ISourcePosition position, Node node1, Node node2) {
        return node2 == null ? node1 : new ArgsCatNode(position, node1, node2);
    }

    public Node arg_blk_pass(Node firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            return secondNode;
        }
        return firstNode;
    }

    public Node gettable2(Node node) {
        switch (node.getNodeType()) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                String name = ((INameNode)((Object)node)).getName();
                if (name.equals(this.lexer.getCurrentArg())) {
                    this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, node.getPosition(), "circular argument reference - " + name, new Object[0]);
                }
                return this.currentScope.declare(node.getPosition(), name);
            }
            case CONSTDECLNODE: {
                return new ConstNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        this.getterIdentifierError(node.getPosition(), ((INameNode)((Object)node)).getName());
        return null;
    }

    public Node declareIdentifier(String name) {
        if (name.equals(this.lexer.getCurrentArg())) {
            this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.lexer.getPosition(), "circular argument reference - " + name, new Object[0]);
        }
        return this.currentScope.declare(this.lexer.tokline, name);
    }

    public AssignableNode assignableLabelOrIdentifier(String name, Node value) {
        return this.currentScope.assign(this.lexer.getPosition(), name.intern(), this.makeNullNil(value));
    }

    public AssignableNode assignableLabel(String name, Node value) {
        return this.currentScope.assign(this.lexer.getPosition(), name, this.makeNullNil(value));
    }

    protected void getterIdentifierError(ISourcePosition position, String identifier) {
        this.lexer.compile_error(SyntaxException.PID.BAD_IDENTIFIER, "identifier " + identifier + " is not valid to get");
    }

    public Node newline_node(Node node, ISourcePosition position) {
        if (node == null) {
            return null;
        }
        node.setNewline();
        return node;
    }

    public Node addRootNode(Node topOfAST) {
        ISourcePosition position;
        int endPosition = this.lexer.isEndSeen() ? this.lexer.getLineOffset() : -1;
        if (this.result.getBeginNodes().isEmpty()) {
            if (topOfAST == null) {
                topOfAST = NilImplicitNode.NIL;
                position = this.lexer.getPosition();
            } else {
                position = topOfAST.getPosition();
            }
        } else {
            position = topOfAST != null ? topOfAST.getPosition() : this.result.getBeginNodes().get(0).getPosition();
            BlockNode newTopOfAST = new BlockNode(position);
            for (Node beginNode : this.result.getBeginNodes()) {
                this.appendToBlock(newTopOfAST, beginNode);
            }
            if (topOfAST != null) {
                newTopOfAST.add(topOfAST);
            }
            topOfAST = newTopOfAST;
        }
        return new RootNode(position, this.result.getScope(), topOfAST, this.lexer.getFile(), endPosition, false);
    }

    public Node appendToBlock(Node head, Node tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getPosition()).add(head);
        }
        if (this.warnings.isVerbose() && this.isBreakStatement(((ListNode)head).getLast())) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, tail.getPosition(), "statement not reached");
        }
        ((ListNode)head).addAll(tail);
        return head;
    }

    public AssignableNode assignableInCurr(String name, Node value) {
        this.currentScope.addVariableThisScope(name);
        return this.currentScope.assign(this.lexer.getPosition(), name, this.makeNullNil(value));
    }

    public Node getOperatorCallNode(Node firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, null, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode) {
        return this.getOperatorCallNode(firstNode, operator, secondNode, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode, ISourcePosition defaultPosition) {
        if (defaultPosition != null) {
            firstNode = this.checkForNilNode(firstNode, defaultPosition);
            secondNode = this.checkForNilNode(secondNode, defaultPosition);
        }
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, new ArrayNode(secondNode.getPosition(), secondNode), null);
    }

    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (firstNode instanceof RegexpNode) {
            List<Integer> locals = this.allocateNamedLocals((RegexpNode)firstNode);
            if (locals.size() > 0) {
                int[] primitiveLocals = new int[locals.size()];
                for (int i = 0; i < primitiveLocals.length; ++i) {
                    primitiveLocals[i] = locals.get(i);
                }
                return new Match2CaptureNode(firstNode.getPosition(), firstNode, secondNode, primitiveLocals);
            }
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), firstNode, secondNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public Node aryset(Node receiver, Node index) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, "[]=", index, false);
    }

    public Node attrset(Node receiver, String name) {
        return this.attrset(receiver, ".", name);
    }

    public Node attrset(Node receiver, String callType, String name) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, name + "=", null, this.isLazy(callType));
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            String varName = "$" + ((NthRefNode)node).getMatchNumber();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + '.');
        } else if (node instanceof BackRefNode) {
            String varName = "$" + ((BackRefNode)node).getType();
            this.lexer.compile_error(SyntaxException.PID.INVALID_ASSIGNMENT, "Can't set variable " + varName + '.');
        }
    }

    public Node arg_add(ISourcePosition position, Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayNode(position, NilImplicitNode.NIL);
            }
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ArrayNode) {
            return ((ArrayNode)node1).add(node2);
        }
        return new ArgsPushNode(position, node1, node2);
    }

    public Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        Node newNode = lhs;
        this.checkExpression(rhs);
        if (lhs instanceof AssignableNode) {
            ((AssignableNode)lhs).setValueNode(rhs);
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(this.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        return newNode;
    }

    public Node ret_args(Node node, ISourcePosition position) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "block argument should not be given");
            } else if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
            } else if (node instanceof SplatNode) {
                node = this.newSValueNode(position, node);
            }
        }
        if (node == null) {
            node = NilImplicitNode.NIL;
        }
        return node;
    }

    public boolean isBreakStatement(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case BREAKNODE: 
            case NEXTNODE: 
            case REDONODE: 
            case RETRYNODE: 
            case RETURNNODE: {
                return true;
            }
        }
        return false;
    }

    public void warnUnlessEOption(IRubyWarnings.ID id, Node node, String message) {
        if (!this.configuration.isInlineSource()) {
            this.warnings.warn(id, node.getPosition(), message);
        }
    }

    public void warningUnlessEOption(IRubyWarnings.ID id, Node node, String message) {
        if (this.warnings.isVerbose() && !this.configuration.isInlineSource()) {
            this.warnings.warning(id, node.getPosition(), message);
        }
    }

    public boolean checkExpression(Node node) {
        boolean conditional = false;
        block7: while (node != null) {
            switch (node.getNodeType()) {
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    if (!conditional) {
                        this.lexer.compile_error(SyntaxException.PID.VOID_VALUE_EXPRESSION, "void value expression");
                    }
                    return false;
                }
                case BLOCKNODE: {
                    node = ((BlockNode)node).getLast();
                    continue block7;
                }
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block7;
                }
                case IFNODE: {
                    if (!this.checkExpression(((IfNode)node).getThenBody())) {
                        return false;
                    }
                    node = ((IfNode)node).getElseBody();
                    continue block7;
                }
                case ANDNODE: 
                case ORNODE: {
                    conditional = true;
                    node = ((BinaryOperatorNode)((Object)node)).getSecondNode();
                    continue block7;
                }
            }
            return true;
        }
        return true;
    }

    public boolean isLiteral(Node node) {
        return node != null && (node instanceof FixnumNode || node instanceof BignumNode || node instanceof FloatNode || node instanceof SymbolNode || node instanceof RegexpNode && ((RegexpNode)node).getOptions().toJoniOptions() == 0);
    }

    private void handleUselessWarn(Node node, String useless) {
        this.warnings.warn(IRubyWarnings.ID.USELESS_EXPRESSION, node.getPosition(), "Useless use of " + useless + " in void context.");
    }

    public void checkUselessStatement(Node node) {
        if (!this.warnings.isVerbose() || !this.configuration.isInlineSource() && this.configuration.isEvalParse()) {
            return;
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case CALLNODE: {
                String name = ((CallNode)node).getName();
                if (name == "+" || name == "-" || name == "*" || name == "/" || name == "%" || name == "**" || name == "+@" || name == "-@" || name == "|" || name == "^" || name == "&" || name == "<=>" || name == ">" || name == ">=" || name == "<" || name == "<=" || name == "==" || name == "!=") {
                    this.handleUselessWarn(node, name);
                }
                return;
            }
            case BACKREFNODE: 
            case DVARNODE: 
            case GLOBALVARNODE: 
            case LOCALVARNODE: 
            case NTHREFNODE: 
            case CLASSVARNODE: 
            case INSTVARNODE: {
                this.handleUselessWarn(node, "a variable");
                return;
            }
            case BIGNUMNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DSYMBOLNODE: 
            case FIXNUMNODE: 
            case FLOATNODE: 
            case REGEXPNODE: 
            case STRNODE: 
            case SYMBOLNODE: {
                this.handleUselessWarn(node, "a literal");
                return;
            }
            case DOTNODE: {
                this.handleUselessWarn(node, ((DotNode)node).isExclusive() ? "..." : "..");
                return;
            }
            case DEFINEDNODE: {
                this.handleUselessWarn(node, "defined?");
                return;
            }
            case FALSENODE: {
                this.handleUselessWarn(node, "false");
                return;
            }
            case NILNODE: {
                this.handleUselessWarn(node, "nil");
                return;
            }
            case TRUENODE: {
                this.handleUselessWarn(node, "true");
                return;
            }
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.warnings.isVerbose()) {
            Node lastNode = blockNode.getLast();
            for (int i = 0; i < blockNode.size(); ++i) {
                Node currentNode = blockNode.get(i);
                if (lastNode == currentNode) continue;
                this.checkUselessStatement(currentNode);
            }
        }
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode) {
            this.lexer.compile_error(SyntaxException.PID.MULTIPLE_ASSIGNMENT_IN_CONDITIONAL, "multiple assignment in conditional");
        } else if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node valueNode = ((AssignableNode)node).getValueNode();
            if (this.isStaticContent(valueNode)) {
                this.warnings.warn(IRubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "found = in conditional, should be ==");
            }
            return true;
        }
        return false;
    }

    private boolean isStaticContent(Node node) {
        if (node instanceof HashNode) {
            HashNode hash = (HashNode)node;
            for (KeyValuePair<Node, Node> pair : hash.getPairs()) {
                if (this.isStaticContent(pair.getKey()) && this.isStaticContent(pair.getValue())) continue;
                return false;
            }
            return true;
        }
        if (node instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)node;
            int size = array.size();
            for (int i = 0; i < size; ++i) {
                if (this.isStaticContent(array.get(i))) continue;
                return false;
            }
            return true;
        }
        return node instanceof ILiteralNode || node instanceof NilNode || node instanceof TrueNode || node instanceof FalseNode;
    }

    protected Node makeNullNil(Node node) {
        return node == null ? NilImplicitNode.NIL : node;
    }

    private Node cond0(Node node) {
        this.checkAssignmentInCondition(node);
        if (node == null) {
            return new NilNode(this.lexer.getPosition());
        }
        switch (node.getNodeType()) {
            case DREGEXPNODE: {
                ISourcePosition position = node.getPosition();
                return new Match2Node(position, node, new GlobalVarNode(position, "$_"));
            }
            case ANDNODE: {
                Node leftNode = this.cond0(((AndNode)node).getFirstNode());
                Node rightNode = this.cond0(((AndNode)node).getSecondNode());
                return new AndNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                Node leftNode = this.cond0(((OrNode)node).getFirstNode());
                Node rightNode = this.cond0(((OrNode)node).getSecondNode());
                return new OrNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String label = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(label);
                int slot = this.currentScope.isDefined(label);
                return new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), dotNode.isExclusive(), slot);
            }
            case REGEXPNODE: {
                this.warningUnlessEOption(IRubyWarnings.ID.REGEXP_LITERAL_IN_CONDITION, node, "regex literal in condition");
                return new MatchNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public Node getConditionNode(Node node) {
        Node cond = this.cond0(node);
        cond.setNewline();
        return cond;
    }

    private Node getFlipConditionNode(Node node) {
        if (!this.configuration.isInlineSource()) {
            return node;
        }
        if ((node = this.getConditionNode(node)) instanceof FixnumNode) {
            this.warnUnlessEOption(IRubyWarnings.ID.LITERAL_IN_CONDITIONAL_RANGE, node, "integer literal in conditional range");
            return this.getOperatorCallNode(node, "==", new GlobalVarNode(node.getPosition(), "$."));
        }
        return node;
    }

    public SValueNode newSValueNode(ISourcePosition position, Node node) {
        return new SValueNode(position, node);
    }

    public SplatNode newSplatNode(ISourcePosition position, Node node) {
        return new SplatNode(position, this.makeNullNil(node));
    }

    public ArrayNode newArrayNode(ISourcePosition position, Node firstNode) {
        return new ArrayNode(position, this.makeNullNil(firstNode));
    }

    public ISourcePosition position(ISourcePositionHolder one, ISourcePositionHolder two) {
        return one == null ? two.getPosition() : one.getPosition();
    }

    public AndNode newAndNode(ISourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new AndNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new AndNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public OrNode newOrNode(ISourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new OrNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new OrNode(this.position(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public CaseNode newCaseNode(ISourcePosition position, Node expression, Node firstWhenNode) {
        ArrayNode cases = new ArrayNode(firstWhenNode != null ? firstWhenNode.getPosition() : position);
        CaseNode caseNode = new CaseNode(position, expression, cases);
        Node current = firstWhenNode;
        while (current != null) {
            if (current instanceof WhenOneArgNode) {
                cases.add(current);
            } else if (current instanceof WhenNode) {
                this.simplifyMultipleArgumentWhenNodes((WhenNode)current, cases);
            } else {
                caseNode.setElseNode(current);
                break;
            }
            current = ((WhenNode)current).getNextCase();
        }
        return caseNode;
    }

    private void simplifyMultipleArgumentWhenNodes(WhenNode sourceWhen, ArrayNode cases) {
        Node expressionNodes = sourceWhen.getExpressionNodes();
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode) {
            cases.add(sourceWhen);
            return;
        }
        if (expressionNodes instanceof ListNode) {
            ListNode list = (ListNode)expressionNodes;
            ISourcePosition position = sourceWhen.getPosition();
            Node bodyNode = sourceWhen.getBodyNode();
            for (int i = 0; i < list.size(); ++i) {
                Node expression = list.get(i);
                if (expression instanceof SplatNode || expression instanceof ArgsCatNode) {
                    cases.add(new WhenNode(position, expression, bodyNode, null));
                    continue;
                }
                cases.add(new WhenOneArgNode(position, expression, bodyNode, null));
            }
        } else {
            cases.add(sourceWhen);
        }
    }

    public WhenNode newWhenNode(ISourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        Node element;
        if (bodyNode == null) {
            bodyNode = NilImplicitNode.NIL;
        }
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode || expressionNodes instanceof ArgsPushNode) {
            return new WhenNode(position, expressionNodes, bodyNode, nextCase);
        }
        ListNode list = (ListNode)expressionNodes;
        if (list.size() == 1 && !((element = list.get(0)) instanceof SplatNode)) {
            return new WhenOneArgNode(position, element, bodyNode, nextCase);
        }
        return new WhenNode(position, expressionNodes, bodyNode, nextCase);
    }

    public Node new_opElementAsgnNode(Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        ISourcePosition position = this.lexer.tokline;
        OpElementAsgnNode newNode = new OpElementAsgnNode(position, receiverNode, operatorName, argsNode, valueNode);
        this.fixpos(newNode, receiverNode);
        return newNode;
    }

    public Node newOpAsgn(ISourcePosition position, Node receiverNode, String callType, Node valueNode, String variableName, String operatorName) {
        return new OpAsgnNode(position, receiverNode, valueNode, variableName, operatorName, this.isLazy(callType));
    }

    public Node newOpConstAsgn(ISourcePosition position, Node lhs, String operatorName, Node rhs) {
        if (lhs != null) {
            return new OpAsgnConstDeclNode(position, lhs, operatorName, rhs);
        }
        return new BeginNode(position, NilImplicitNode.NIL);
    }

    public boolean isLazy(String callType) {
        return "&.".equals(callType);
    }

    public Node new_attrassign(ISourcePosition position, Node receiver, String name, Node args, boolean isLazy) {
        return new AttrAssignNode(position, receiver, name, args, isLazy);
    }

    private boolean isNumericOperator(String name) {
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '<': 
                case '>': {
                    return true;
                }
            }
        } else if (name.length() == 2) {
            switch (name.charAt(0)) {
                case '<': 
                case '=': 
                case '>': {
                    switch (name.charAt(1)) {
                        case '<': 
                        case '=': {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public Node new_call(Node receiver, String callType, String name, Node argsNode, Node iter) {
        if (argsNode instanceof BlockPassNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassNode blockPass = (BlockPassNode)argsNode;
            return new CallNode(this.position(receiver, argsNode), receiver, name, blockPass.getArgsNode(), blockPass, this.isLazy(callType));
        }
        return new CallNode(this.position(receiver, argsNode), receiver, name, argsNode, iter, this.isLazy(callType));
    }

    public Node new_call(Node receiver, String name, Node argsNode, Node iter) {
        return this.new_call(receiver, ".", name, argsNode, iter);
    }

    public Colon2Node new_colon2(ISourcePosition position, Node leftNode, String name) {
        if (leftNode == null) {
            return new Colon2ImplicitNode(position, name);
        }
        return new Colon2ConstNode(position, leftNode, name);
    }

    public Colon3Node new_colon3(ISourcePosition position, String name) {
        return new Colon3Node(position, name);
    }

    public void frobnicate_fcall_args(FCallNode fcall, Node args, Node iter) {
        if (args instanceof BlockPassNode) {
            if (iter != null) {
                this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, "Both block arg and actual block given.");
            }
            BlockPassNode blockPass = (BlockPassNode)args;
            args = blockPass.getArgsNode();
            iter = blockPass;
        }
        fcall.setArgsNode(args);
        fcall.setIterNode(iter);
    }

    public void fixpos(Node node, Node orig) {
        if (node == null || orig == null) {
            return;
        }
        node.setPosition(orig.getPosition());
    }

    public Node new_fcall(String operation) {
        return new FCallNode(this.lexer.tokline, operation);
    }

    public Node new_super(ISourcePosition position, Node args) {
        if (args != null && args instanceof BlockPassNode) {
            return new SuperNode(position, ((BlockPassNode)args).getArgsNode(), args);
        }
        return new SuperNode(position, args);
    }

    public void initTopLocalVariables() {
        StaticScope scope = this.configuration.getScope();
        this.currentScope = scope == null ? StaticScopeFactory.newLocalScope(null) : scope;
        this.result.setScope(this.currentScope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public RubyParserResult getResult() {
        return this.result;
    }

    public void setResult(RubyParserResult result) {
        this.result = result;
    }

    public void setConfiguration(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public void setLexer(RubyLexer lexer) {
        this.lexer = lexer;
    }

    public DStrNode createDStrNode(ISourcePosition position) {
        DStrNode dstr = new DStrNode(position, this.lexer.getEncoding());
        if (this.getConfiguration().isFrozenStringLiteral()) {
            dstr.setFrozen(true);
        }
        return dstr;
    }

    public KeyValuePair<Node, Node> createKeyValue(Node key, Node value) {
        if (key != null && key instanceof StrNode) {
            ((StrNode)key).setFrozen(true);
        }
        return new KeyValuePair<Node, Node>(key, value);
    }

    public Node asSymbol(ISourcePosition position, String value) {
        return new SymbolNode(position, value, this.lexer.getEncoding(), this.lexer.getTokenCR());
    }

    public Node asSymbol(ISourcePosition position, Node value) {
        return value instanceof StrNode ? new SymbolNode(position, ((StrNode)value).getValue()) : new DSymbolNode(position, (DStrNode)value);
    }

    public Node literal_concat(ISourcePosition position, Node head, Node tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrNode) {
            head = this.createDStrNode(head.getPosition()).add(head);
        }
        if (this.lexer.getHeredocIndent() > 0) {
            if (head instanceof StrNode) {
                head = this.createDStrNode(head.getPosition()).add(head);
                return this.list_append(head, tail);
            }
            if (head instanceof DStrNode) {
                return this.list_append(head, tail);
            }
        }
        if (tail instanceof StrNode) {
            if (head instanceof StrNode) {
                StrNode front = (StrNode)head;
                if (front.getValue().getRealSize() > 0) {
                    return new StrNode(head.getPosition(), front, (StrNode)tail);
                }
                return tail;
            }
            head.setPosition(head.getPosition());
            return ((ListNode)head).add(tail);
        }
        if (tail instanceof DStrNode) {
            if (head instanceof StrNode) {
                DStrNode newDStr = new DStrNode(head.getPosition(), ((DStrNode)tail).getEncoding());
                newDStr.add(head);
                newDStr.addAll(tail);
                if (this.getConfiguration().isFrozenStringLiteral()) {
                    newDStr.setFrozen(true);
                }
                return newDStr;
            }
            return ((ListNode)head).addAll(tail);
        }
        if (head instanceof StrNode) {
            head = ((StrNode)head).getValue().length() == 0 ? this.createDStrNode(head.getPosition()) : this.createDStrNode(head.getPosition()).add(head);
        }
        return ((DStrNode)head).add(tail);
    }

    public Node newRescueModNode(Node body, Node rescueBody) {
        if (rescueBody == null) {
            rescueBody = NilImplicitNode.NIL;
        }
        ISourcePosition pos = this.getPosition(body);
        return new RescueModNode(pos, body, new RescueBodyNode(pos, null, rescueBody, null));
    }

    public Node newEvStrNode(ISourcePosition position, Node node) {
        if (node instanceof StrNode || node instanceof DStrNode || node instanceof EvStrNode) {
            return node;
        }
        return new EvStrNode(position, node);
    }

    public Node new_yield(ISourcePosition position, Node node) {
        if (node != null && node instanceof BlockPassNode) {
            this.lexer.compile_error(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, "Block argument should not be given.");
        }
        return new YieldNode(position, node);
    }

    public NumericNode negateInteger(NumericNode integerNode) {
        if (integerNode instanceof FixnumNode) {
            FixnumNode fixnumNode = (FixnumNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumNode) {
            BignumNode bignumNode = (BignumNode)integerNode;
            BigInteger value = bignumNode.getValue().negate();
            if (value.compareTo(LONG_MIN) >= 0) {
                return new FixnumNode(bignumNode.getPosition(), value.longValue());
            }
            bignumNode.setValue(value);
        }
        return integerNode;
    }

    public FloatNode negateFloat(FloatNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public ComplexNode negateComplexNode(ComplexNode complexNode) {
        complexNode.setNumber(this.negateNumeric(complexNode.getNumber()));
        return complexNode;
    }

    public RationalNode negateRational(RationalNode rationalNode) {
        return new RationalNode(rationalNode.getPosition(), -rationalNode.getNumerator(), rationalNode.getDenominator());
    }

    private Node checkForNilNode(Node node, ISourcePosition defaultPosition) {
        return node == null ? new NilNode(defaultPosition) : node;
    }

    public Node new_args(ISourcePosition position, ListNode pre, ListNode optional, RestArgNode rest, ListNode post, ArgsTailHolder tail) {
        ArgsNode argsNode = tail == null ? new ArgsNode(position, pre, optional, rest, post, null) : new ArgsNode(position, pre, optional, rest, post, tail.getKeywordArgs(), tail.getKeywordRestArgNode(), tail.getBlockArg());
        return argsNode;
    }

    public ArgsTailHolder new_args_tail(ISourcePosition position, ListNode keywordArg, String keywordRestArgName, BlockArgNode blockArg) {
        if (keywordRestArgName == null) {
            return new ArgsTailHolder(position, keywordArg, null, blockArg);
        }
        String restKwargsName = keywordRestArgName;
        int slot = this.currentScope.exists(restKwargsName);
        if (slot == -1) {
            slot = this.currentScope.addVariable(restKwargsName);
        }
        KeywordRestArgNode keywordRestArg = new KeywordRestArgNode(position, restKwargsName, slot);
        return new ArgsTailHolder(position, keywordArg, keywordRestArg, blockArg);
    }

    public Node remove_duplicate_keys(HashNode hash) {
        ArrayList<Node> encounteredKeys = new ArrayList<Node>();
        for (KeyValuePair<Node, Node> pair : hash.getPairs()) {
            Node key = pair.getKey();
            if (key == null) continue;
            int index = encounteredKeys.indexOf(key);
            if (index >= 0) {
                this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, hash.getPosition(), "key " + key + " is duplicated and overwritten on line " + (((Node)encounteredKeys.get(index)).getLine() + 1), new Object[0]);
                continue;
            }
            encounteredKeys.add(key);
        }
        return hash;
    }

    public Node newAlias(ISourcePosition position, Node newNode, Node oldNode) {
        return new AliasNode(position, newNode, oldNode);
    }

    public Node newUndef(ISourcePosition position, Node nameNode) {
        return new UndefNode(position, nameNode);
    }

    public void yyerror(String message) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message);
    }

    public void yyerror(String message, String[] expected, String found) {
        this.lexer.compile_error(SyntaxException.PID.GRAMMAR_ERROR, message + ", unexpected " + found + "\n");
    }

    public ISourcePosition getPosition(ISourcePositionHolder start) {
        return start != null ? this.lexer.getPosition(start.getPosition()) : this.lexer.getPosition();
    }

    public void warn(IRubyWarnings.ID id, ISourcePosition position, String message, Object ... data) {
        this.warnings.warn(id, position, message);
    }

    public void warning(IRubyWarnings.ID id, ISourcePosition position, String message, Object ... data) {
        if (this.warnings.isVerbose()) {
            this.warnings.warning(id, position, message);
        }
    }

    public boolean is_local_id(String name) {
        return this.lexer.isIdentifierChar(name.charAt(0));
    }

    public ListNode list_append(Node list, Node item) {
        if (list == null) {
            return new ArrayNode(item.getPosition(), item);
        }
        if (!(list instanceof ListNode)) {
            return new ArrayNode(list.getPosition(), list).add(item);
        }
        return ((ListNode)list).add(item);
    }

    public Node new_bv(String identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(this.lexer.getPosition(), identifier);
        }
        this.shadowing_lvar(identifier);
        return this.arg_var(identifier);
    }

    public ArgumentNode arg_var(String name) {
        StaticScope current = this.getCurrentScope();
        if (name == "_") {
            int count = 0;
            while (current.exists(name) >= 0) {
                name = ("_$" + count++).intern();
            }
        }
        return new ArgumentNode(this.lexer.getPosition(), name, current.addVariableThisScope(name));
    }

    public String formal_argument(String identifier) {
        this.lexer.validateFormalIdentifier(identifier);
        return this.shadowing_lvar(identifier);
    }

    public String shadowing_lvar(String name) {
        if (name == "_") {
            return name;
        }
        StaticScope current = this.getCurrentScope();
        if (current.isBlockScope()) {
            if (current.exists(name) >= 0) {
                this.yyerror("duplicated argument name");
            }
            if (this.warnings.isVerbose() && current.isDefined(name) >= 0) {
                this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, this.lexer.getPosition(), "shadowing outer local variable - " + name);
            }
        } else if (current.exists(name) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return name;
    }

    public ListNode list_concat(Node first, Node second) {
        if (first instanceof ListNode) {
            if (second instanceof ListNode) {
                return ((ListNode)first).addAll((ListNode)second);
            }
            return ((ListNode)first).addAll(second);
        }
        return new ArrayNode(first.getPosition(), first).add(second);
    }

    public Node splat_array(Node node) {
        if (node instanceof SplatNode) {
            node = ((SplatNode)node).getValue();
        }
        if (node instanceof ArrayNode) {
            return node;
        }
        return null;
    }

    public Node arg_append(Node node1, Node node2) {
        if (node1 == null) {
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListNode) {
            return ((ListNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassNode) {
            return this.arg_append(((BlockPassNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node1;
            Node body = pushNode.getSecondNode();
            return new ArgsCatNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushNode(this.position(node1, node2), node1, node2);
    }

    public void regexpFragmentCheck(RegexpNode end, ByteList value) {
    }

    private List<Integer> allocateNamedLocals(RegexpNode regexpNode) {
        return Collections.emptyList();
    }

    private boolean is7BitASCII(ByteList value) {
        return StringSupport.codeRangeScan(value.getEncoding(), value) == 16;
    }

    private char optionsEncodingChar(Encoding optionEncoding) {
        if (optionEncoding == LexingCommon.USASCII_ENCODING) {
            return 'n';
        }
        if (optionEncoding == EUCJPEncoding.INSTANCE) {
            return 'e';
        }
        if (optionEncoding == SJISEncoding.INSTANCE) {
            return 's';
        }
        if (optionEncoding == LexingCommon.UTF8_ENCODING) {
            return 'u';
        }
        return ' ';
    }

    public void compile_error(String message) {
        String line = this.lexer.getCurrentLine();
        ISourcePosition position = this.lexer.getPosition();
        String errorMessage = this.lexer.getFile() + ":" + (position.getLine() + 1) + ": ";
        if (line != null && line.length() > 5) {
            boolean addNewline = message != null && !message.endsWith("\n");
            message = message + (addNewline ? "\n" : "") + line;
        }
        throw new SyntaxException(SyntaxException.PID.BAD_HEX_NUMBER, this.lexer.getFile(), this.lexer.getLineOffset(), line, errorMessage + message, "");
    }

    protected void compileError(Encoding optionEncoding, Encoding encoding) {
        this.lexer.compile_error(SyntaxException.PID.REGEXP_ENCODING_MISMATCH, "regexp encoding option '" + this.optionsEncodingChar(optionEncoding) + "' differs from source encoding '" + encoding + "'");
    }

    protected void checkRegexpSyntax(ByteList value, RegexpOptions options) {
    }

    public Node newRegexpNode(ISourcePosition position, Node contents, RegexpNode end) {
        RegexpOptions options = end.getOptions();
        Encoding encoding = this.lexer.getEncoding();
        if (contents == null) {
            ByteList newValue = ByteList.create((CharSequence)"");
            if (encoding != null) {
                newValue.setEncoding(encoding);
            }
            this.regexpFragmentCheck(end, newValue);
            return new RegexpNode(position, newValue, options.withoutOnce());
        }
        if (contents instanceof StrNode) {
            ByteList meat = (ByteList)((StrNode)contents).getValue().clone();
            this.regexpFragmentCheck(end, meat);
            this.checkRegexpSyntax(meat, options.withoutOnce());
            return new RegexpNode(contents.getPosition(), meat, options.withoutOnce());
        }
        if (contents instanceof DStrNode) {
            DStrNode dStrNode = (DStrNode)contents;
            for (int i = 0; i < dStrNode.size(); ++i) {
                Node fragment = dStrNode.get(i);
                if (!(fragment instanceof StrNode)) continue;
                ByteList frag = ((StrNode)fragment).getValue();
                this.regexpFragmentCheck(end, frag);
            }
            DRegexpNode dRegexpNode = new DRegexpNode(position, options, encoding);
            dRegexpNode.add(new StrNode(contents.getPosition(), this.createMaster(options)));
            dRegexpNode.addAll(dStrNode);
            return dRegexpNode;
        }
        ByteList master = this.createMaster(options);
        this.regexpFragmentCheck(end, master);
        encoding = master.getEncoding();
        DRegexpNode node = new DRegexpNode(position, options, encoding);
        node.add(new StrNode(contents.getPosition(), master));
        node.add(contents);
        return node;
    }

    private ByteList createMaster(RegexpOptions options) {
        Encoding encoding = options.getKCode().getEncoding();
        return new ByteList(ByteList.NULL_ARRAY, encoding);
    }

    public static int associateEncoding(ByteList buffer, Encoding newEncoding, int codeRange) {
        Encoding bufferEncoding = buffer.getEncoding();
        if (newEncoding == bufferEncoding) {
            return codeRange;
        }
        buffer.setEncoding(newEncoding);
        if (codeRange != 16 || !newEncoding.isAsciiCompatible()) {
            return 0;
        }
        return codeRange;
    }

    public KeywordArgNode keyword_arg(ISourcePosition position, AssignableNode assignable) {
        return new KeywordArgNode(position, assignable);
    }

    public NumericNode negateNumeric(NumericNode node) {
        switch (node.getNodeType()) {
            case BIGNUMNODE: 
            case FIXNUMNODE: {
                return this.negateInteger(node);
            }
            case COMPLEXNODE: {
                return this.negateComplexNode((ComplexNode)node);
            }
            case FLOATNODE: {
                return this.negateFloat((FloatNode)node);
            }
            case RATIONALNODE: {
                return this.negateRational((RationalNode)node);
            }
        }
        this.yyerror("Invalid or unimplemented numeric to negate: " + node.toString());
        return null;
    }

    public Node new_defined(ISourcePosition position, Node something) {
        return new DefinedNode(position, something);
    }

    public String internalId() {
        return "";
    }
}

