/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.parser.StaticScope;

public class SClassNode
extends Node {
    private final Node receiverNode;
    private final StaticScope scope;
    private final Node bodyNode;

    public SClassNode(ISourcePosition position, Node recvNode, StaticScope scope, Node bodyNode) {
        super(position, recvNode.containsVariableAssignment() || bodyNode.containsVariableAssignment());
        assert (scope != null) : "scope is not null";
        assert (recvNode != null) : "receiverNode is not null";
        this.receiverNode = recvNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCLASSNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.bodyNode);
    }
}

