/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class ConstDeclNode
extends AssignableNode
implements INameNode {
    private final String name;
    private final INameNode constNode;

    public ConstDeclNode(ISourcePosition position, String name, INameNode constNode, Node valueNode) {
        super(position, valueNode, valueNode != null && valueNode.containsVariableAssignment());
        this.name = name;
        this.constNode = constNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CONSTDECLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitConstDeclNode(this);
    }

    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name == null ? this.constNode.getName() : this.name;
    }

    public Node getConstNode() {
        return (Node)((Object)this.constNode);
    }

    @Override
    public List<Node> childNodes() {
        return ConstDeclNode.createList(this.getConstNode(), this.getValueNode());
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

