/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.system;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.util.io.SrcclrIo;
import com.sourceclear.util.system.SystemInfoResult;
import com.sourceclear.util.system.SystemInfoResults;
import com.sourceclear.util.system.SystemItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemInfo.class);

    public static void main(String[] args) throws IOException {
        System.out.println(SystemInfo.perform());
    }

    public static SystemInfoResults perform() throws IOException {
        SystemInfo info = new SystemInfo();
        return info.performInner();
    }

    public static SystemInfoResults performOnItems(Set<SystemItem> systemItems) throws IOException {
        SystemInfo info = new SystemInfo();
        return info.performInner(systemItems);
    }

    @VisibleForTesting
    SystemInfo() {
    }

    public SystemInfoResults performInner() throws IOException {
        ImmutableMap.Builder results = new ImmutableMap.Builder();
        results.put((Object)SystemItem.OS, (Object)new SystemInfoResult.Builder().withItem(SystemItem.OS).withValueTitle("Name").withValue(System.getProperty("os.name")).withVersion(System.getProperty("os.version")).build());
        results.put((Object)SystemItem.JAVA, (Object)new SystemInfoResult.Builder().withItem(SystemItem.JAVA).withValueTitle("Vendor").withValue(System.getProperty("java.vendor")).withVersion(System.getProperty("java.version")).build());
        List<SystemItem> valuesWithExec = SystemItem.getValuesWithExec();
        Map<SystemItem, String> executables = this.findExecutables(valuesWithExec);
        results.putAll(this.getSystemItemInfo(executables));
        HashSet missing = Sets.newHashSet((Object[])SystemItem.values());
        missing.removeAll(executables.keySet());
        missing.remove((Object)SystemItem.OS);
        missing.remove((Object)SystemItem.JAVA);
        return new SystemInfoResults((ImmutableMap<SystemItem, SystemInfoResult>)results.build(), (ImmutableSet<SystemItem>)ImmutableSet.copyOf((Collection)missing));
    }

    public SystemInfoResults performInner(Set<SystemItem> systemItems) throws IOException {
        ImmutableMap.Builder resultsBuilder = new ImmutableMap.Builder();
        if (systemItems.contains((Object)SystemItem.OS)) {
            resultsBuilder.put((Object)SystemItem.OS, (Object)new SystemInfoResult.Builder().withItem(SystemItem.OS).withValueTitle("Name").withValue(System.getProperty("os.name")).withVersion(System.getProperty("os.version")).build());
        }
        if (systemItems.contains((Object)SystemItem.JAVA)) {
            resultsBuilder.put((Object)SystemItem.JAVA, (Object)new SystemInfoResult.Builder().withItem(SystemItem.JAVA).withValueTitle("Vendor").withValue(System.getProperty("java.vendor")).withVersion(System.getProperty("java.version")).build());
        }
        List<SystemItem> valuesWithExec = SystemItem.getValuesWithExec();
        ArrayList<SystemItem> filteredItems = new ArrayList<SystemItem>();
        for (SystemItem systemItem : valuesWithExec) {
            if (!systemItems.contains((Object)systemItem)) continue;
            filteredItems.add(systemItem);
        }
        Map<SystemItem, String> executables = this.findExecutables(filteredItems);
        ImmutableMap<SystemItem, SystemInfoResult> partialResults = this.getSystemItemInfo(executables);
        resultsBuilder.putAll(partialResults);
        HashSet missing = Sets.newHashSet(systemItems);
        missing.removeAll(executables.keySet());
        missing.remove((Object)SystemItem.OS);
        missing.remove((Object)SystemItem.JAVA);
        return new SystemInfoResults((ImmutableMap<SystemItem, SystemInfoResult>)resultsBuilder.build(), (ImmutableSet<SystemItem>)ImmutableSet.copyOf((Collection)missing));
    }

    private ImmutableMap<SystemItem, SystemInfoResult> getSystemItemInfo(Map<SystemItem, String> executables) {
        ImmutableMap.Builder results = new ImmutableMap.Builder();
        for (Map.Entry<SystemItem, String> entry : executables.entrySet()) {
            results.put((Object)entry.getKey(), (Object)new SystemInfoResult.Builder().withItem(entry.getKey()).withValueTitle("Path").withValue(entry.getValue()).withVersion(this.getVersion(entry.getKey(), entry.getValue())).build());
        }
        return results.build();
    }

    @VisibleForTesting
    Process getProcess(String exePath, List<String> versionOption) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(exePath);
        command.addAll(versionOption);
        return new ProcessBuilder(new String[0]).command(command).start();
    }

    @VisibleForTesting
    String getVersion(SystemItem item, String exePath) {
        String unknown = "Unable to determine version";
        try {
            Process process = this.getProcess(exePath, item.getVersionArgument());
            Future<String> output = SrcclrIo.readAsync(process.getInputStream());
            Future<String> error = SrcclrIo.readAsync(process.getErrorStream());
            int retCode = process.waitFor();
            if (retCode != 0 && !item.equals((Object)SystemItem.GOVENDOR)) {
                LOGGER.warn("{} returned with a nonzero value {}:\n\nstdout output: {}\n\nstderr output: {}", new Object[]{exePath, retCode, output.get(), error.get()});
                return "Unable to determine version";
            }
            Pattern pattern = item.getVersionPattern();
            if (pattern == null) {
                LOGGER.error("Version extraction pattern missing for " + (Object)((Object)item));
                return "Unable to determine version";
            }
            for (Future outFuture : Arrays.asList(output, error)) {
                Matcher m = pattern.matcher((CharSequence)outFuture.get());
                if (!m.matches()) continue;
                return m.group("version");
            }
        }
        catch (Exception ex) {
            LOGGER.info("Couldn't execute " + exePath, (Throwable)ex);
        }
        return "Unable to determine version";
    }

    @VisibleForTesting
    Map<String, String> resolveExecutables(Collection<String> nameList) {
        return SrcclrIo.resolveExecutables(nameList);
    }

    @VisibleForTesting
    Map<SystemItem, String> findExecutables(List<SystemItem> valuesWithExec) {
        HashMap<SystemItem, String> executables = new HashMap<SystemItem, String>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (SystemItem item : valuesWithExec) {
            nameList.add(item.getExecutable());
        }
        Map<String, String> exes = this.resolveExecutables(nameList);
        for (SystemItem item : valuesWithExec) {
            String executable = item.getExecutable();
            if (!exes.containsKey(executable)) continue;
            executables.put(item, exes.get(executable));
        }
        return executables;
    }
}

