/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import com.sourceclear.util.fingerprints.Version;
import com.sourceclear.util.fingerprints.VersionResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class VersionMatcher {
    private static final VersionResolver VERSION_RESOLVER = VersionResolver.getInstance();
    private static final Pattern DIGIT_DASH_DIGIT = Pattern.compile("\\d-\\d");
    private static final Pattern LETTER_DASH_NUMBER_DOT = Pattern.compile("[a-zA-Z]-\\d+\\.");

    public static Context matcher(String versionString) {
        return new Context(versionString);
    }

    public static List<Range> parse(String versionString) {
        String[] rangeStrings;
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (versionString == null || versionString.isEmpty()) {
            return ranges;
        }
        for (String rangeString : rangeStrings = versionString.trim().split(",")) {
            int separatorIndex = 0;
            int lowEndFromIndex = 1;
            int highEndFromIndex = 2;
            Matcher digitDashDigitMatcher = DIGIT_DASH_DIGIT.matcher(rangeString);
            if (digitDashDigitMatcher.find()) {
                separatorIndex = digitDashDigitMatcher.start();
                if (digitDashDigitMatcher.end() == 3) {
                    ++separatorIndex;
                    --lowEndFromIndex;
                    --highEndFromIndex;
                }
            } else {
                Matcher alphabetDashDigitDotMatcher = LETTER_DASH_NUMBER_DOT.matcher(rangeString);
                if (alphabetDashDigitDotMatcher.find()) {
                    separatorIndex = alphabetDashDigitDotMatcher.start();
                }
            }
            Range r = new Range(separatorIndex == 0 ? rangeString : rangeString.substring(0, separatorIndex + lowEndFromIndex), separatorIndex == 0 ? rangeString : rangeString.substring(separatorIndex + highEndFromIndex));
            ranges.add(r);
        }
        return ranges;
    }

    private static VersionMatch versionMatch(Range range, String version) {
        Version lowVersion = VERSION_RESOLVER.resolve(range.low);
        Version highVersion = VERSION_RESOLVER.resolve(range.high);
        Version testVersion = VERSION_RESOLVER.resolve(version);
        boolean matches = lowVersion.compareTo(testVersion) <= 0 && highVersion.compareTo(testVersion) >= 0;
        return new VersionMatch(testVersion, matches);
    }

    private static boolean match(Range range, String version) {
        return VersionMatcher.versionMatch(range, version).match;
    }

    public boolean matches(String versionRange, String version) {
        if (versionRange == null || versionRange.isEmpty() || version == null || version.isEmpty()) {
            return true;
        }
        List<Range> ranges = VersionMatcher.parse(versionRange);
        for (Range range : ranges) {
            try {
                if (!VersionMatcher.match(range, version)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private static class VersionMatch {
        private final Version version;
        private final boolean match;

        private VersionMatch(Version version, boolean match) {
            this.version = version;
            this.match = match;
        }
    }

    public static class Range {
        private final String low;
        private final String high;

        public Range(String low, String high) {
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return "range [low=" + this.low + ", high=" + this.high + "]";
        }

        public String getLow() {
            return this.low;
        }

        public String getHigh() {
            return this.high;
        }
    }

    public static class Context {
        private final SortedSet<Version> versions = new TreeSet<Version>();
        private final List<Range> ranges;

        private Context(String versionString) {
            this.ranges = VersionMatcher.parse(versionString);
        }

        public boolean matches(String version) {
            for (Range range : this.ranges) {
                VersionMatch versionMatch = VersionMatcher.versionMatch(range, version);
                if (!versionMatch.match) continue;
                this.versions.add(versionMatch.version);
                return true;
            }
            return false;
        }

        public SortedSet<Version> getVersions() {
            return Collections.unmodifiableSortedSet(this.versions);
        }
    }
}

