/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.expr;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.expr.PredicateArgument;
import com.sourceclear.sgl.lang.expr.Traversal;
import com.sourceclear.sgl.lang.expr.TraversalArgument;
import com.sourceclear.sgl.lang.expr.Value;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Predicate;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public abstract class Argument {
    @Nullable
    private final String keyword;

    public Argument(String keyword) {
        this.keyword = keyword;
    }

    public abstract <E, T, A> A accept(ASTVisitor<E, T, A> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Argument argument = (Argument)o;
        return Objects.equals(this.keyword, argument.keyword);
    }

    public int hashCode() {
        return Objects.hash(this.keyword);
    }

    public static Argument of(Predicate predicate) {
        return new PredicateArgument(predicate);
    }

    public static Argument of(Traversal traversal) {
        return new TraversalArgument(null, traversal);
    }

    public static Argument of(String keyword, Traversal traversal) {
        return new TraversalArgument(keyword, traversal);
    }

    public static Argument of(Value value) {
        return new PredicateArgument(new Eq(value));
    }

    public static Argument of(String keyword, Predicate predicate) {
        return new PredicateArgument(keyword, predicate);
    }

    public static Argument of(String keyword, Value value) {
        return new PredicateArgument(keyword, new Eq(value));
    }

    public Optional<String> getKeyword() {
        return Optional.ofNullable(this.keyword);
    }

    public boolean isValue() {
        return this instanceof PredicateArgument;
    }

    public boolean isTraversal() {
        return this instanceof TraversalArgument;
    }

    public Value asValue() {
        if (!(this instanceof PredicateArgument)) {
            throw new RuntimeException("attempt to get value from non-predicate");
        }
        return ((PredicateArgument)this).getValueUnsafe();
    }

    public TraversalArgument asTraversal() {
        if (!(this instanceof TraversalArgument)) {
            throw new RuntimeException("not a traversal");
        }
        return (TraversalArgument)this;
    }
}

