/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.datastax.dse.graph.api.predicates.Search;
import com.sourceclear.sgl.Schema;
import com.sourceclear.sgl.SubseqSet;
import com.sourceclear.sgl.lang.ExpandWithin;
import com.sourceclear.sgl.lang.GremlinTranslationVisitor;
import com.sourceclear.sgl.lang.ImmutableCompileConfig;
import com.sourceclear.sgl.lang.PredicateVisitor;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.Argument;
import com.sourceclear.sgl.lang.expr.Binding;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.EvaluatedArgument;
import com.sourceclear.sgl.lang.expr.Named;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.PredicateArgument;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.SGLInteger;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.expr.Step;
import com.sourceclear.sgl.lang.expr.Traversal;
import com.sourceclear.sgl.lang.expr.TraversalArgument;
import com.sourceclear.sgl.lang.expr.Value;
import com.sourceclear.sgl.lang.expr.WildcardArgument;
import com.sourceclear.sgl.lang.predicate.And;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Neg;
import com.sourceclear.sgl.lang.predicate.Or;
import com.sourceclear.sgl.lang.predicate.Regex;
import com.sourceclear.sgl.lang.predicate.Relational;
import com.sourceclear.sgl.lang.predicate.Within;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ProjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class SGQLVisitor
extends GremlinTranslationVisitor
implements PredicateVisitor<P<Object>> {
    private MetaStepContext context = MetaStepContext.NOTHING;
    private final ImmutableCompileConfig config;

    public SGQLVisitor(GraphTraversalSource source, ImmutableCompileConfig config) {
        super((GraphTraversal<Vertex, Vertex>)source.V(new Object[0]));
        this.config = config;
    }

    public SGQLVisitor(GraphTraversal<Vertex, Vertex> traversal, Map<String, Step> env) {
        super(traversal, env);
        this.config = ImmutableCompileConfig.builder().build();
    }

    @Override
    public Void visitBindingSequence(BindingSequence bindingSequence) {
        for (Binding binding : bindingSequence.getBindings()) {
            this.env.put(binding.getVariable(), binding.getExpr());
        }
        this.visit(bindingSequence.getBody());
        return null;
    }

    @Override
    public Void visitSequence(Sequence sequence) {
        throw new RuntimeException("sequences of actions are not allowed in SGQL");
    }

    @Override
    public Void visitAddAction(AddAction action) {
        throw new RuntimeException("actions are not allowed in SGQL");
    }

    @Override
    public Void visitRemoveAction(RemoveAction action) {
        throw new RuntimeException("actions are not allowed in SGQL");
    }

    @Override
    public Void visitQuery(Query query) {
        this.visit(query.getStep());
        return null;
    }

    @Override
    public Void visitPatterns(Patterns patterns) {
        List<Named> named;
        GraphTraversal[] matchFragments = (GraphTraversal[])patterns.getNamed().stream().map(n -> {
            GraphTraversal<Vertex, Vertex> t = this.withTraversal((GraphTraversal<Vertex, Vertex>)__.as((String)n.start(), (String[])new String[0]), () -> n.step().accept(this));
            n.end().ifPresent(x$0 -> t.as(x$0, new String[0]));
            return t;
        }).toArray(GraphTraversal[]::new);
        String[] userVariables = (String[])patterns.getNamed().stream().flatMap(n -> Stream.concat(Stream.of(n.start()), n.end().map(Stream::of).orElseGet(Stream::empty))).filter(v -> !v.startsWith("_")).distinct().toArray(String[]::new);
        if (userVariables.length == 0 && (named = patterns.getNamed()).size() != 1) {
            throw new RuntimeException("there need to be variables specified if there is more than one pattern");
        }
        this.traversal(t -> t.match((org.apache.tinkerpop.gremlin.process.traversal.Traversal[])matchFragments));
        this.applySelect(userVariables);
        return null;
    }

    @Override
    public Void visitStep(Step step) {
        String name = step.getName();
        if (this.isBound(step)) {
            this.visit((Traversal)this.env.get(name));
            this.traversal(t -> this.selectivelyBindName((GraphTraversal<Vertex, Vertex>)t, name));
        } else if (Schema.isVertex(name)) {
            this.vertexStep(step);
        } else if (Schema.isTransitive(name)) {
            this.translateTransitive(step);
        } else if (Schema.isReverseEdge(name)) {
            this.edgeStep(false, this.context == MetaStepContext.EDGE, step);
        } else if (Schema.isEdge(name)) {
            this.edgeStep(true, this.context == MetaStepContext.EDGE, step);
        } else if (Schema.isSpecialStep(name)) {
            this.specialStep(step);
        } else {
            throw new RuntimeException("unrecognized step " + name);
        }
        step.getNext().ifPresent(this::visit);
        return null;
    }

    private void translateTransitive(Step step) {
        String name = step.getName();
        String direct = Schema.getDirectEdge(name);
        GraphTraversal t = Schema.isEdge(direct) ? (this.config.pathWithEdges() ? __.outE((String[])new String[]{direct}).inV() : __.out((String[])new String[]{direct})) : (this.config.pathWithEdges() ? __.inE((String[])new String[]{Schema.getReverseEdge(direct)}).outV() : __.in((String[])new String[]{Schema.getReverseEdge(direct)}));
        Integer hasDepthLimit = step.getArguments().stream().filter(a -> a.isValue() && a.asValue().isInteger()).map(a -> (Integer)a.asValue().getValue()).findAny().orElse(null);
        boolean isExclusive = step.getArguments().stream().anyMatch(a -> a.isTraversal() && ((Step)a.asTraversal().getTraversal()).getName().equals("exclusive"));
        this.transitiveEdgeStep((GraphTraversal<Object, Vertex>)t, hasDepthLimit, isExclusive);
    }

    private void vertexStep(Step step) {
        String name = step.getName();
        List<EvaluatedArgument<Object>> predicateParams = this.evaluateArguments(step);
        SGQLVisitor.vertex(name, this.traversal(s -> s.V(new Object[0]), t -> {}), predicateParams);
    }

    private Map<String, Object> vertexIdStep(Step step) {
        String name = step.getName();
        List<EvaluatedArgument<Object>> predicateParams = this.evaluateArguments(step);
        return SGQLVisitor.id(name, predicateParams);
    }

    private boolean isBound(Step step) {
        return this.env.containsKey(step.getName()) && step.getArguments().isEmpty();
    }

    private void specialStep(Step step) {
        switch (step.getName()) {
            case "where": {
                this.translateWhere(step);
                break;
            }
            case "not": {
                this.translateNot(step);
                break;
            }
            case "union": {
                this.translateUnion(step);
                break;
            }
            case "start": {
                this.translateStart(step);
                break;
            }
            case "limit": {
                this.translateLimit(step);
                break;
            }
            case "count": {
                this.ensureNoArguments(step);
                this.traversal(GraphTraversal::count);
                break;
            }
            case "path": {
                this.translatePath(step);
                break;
            }
            case "identity": {
                this.ensureNoArguments(step);
                this.traversal(GraphTraversal::identity);
                break;
            }
            case "id": {
                this.ensureNoArguments(step);
                this.traversal(GraphTraversal::id);
                break;
            }
            case "value_map": {
                this.ensureNoArguments(step);
                this.traversal(rec$ -> ((GraphTraversal)rec$).valueMap(new String[0]));
                break;
            }
            case "dedup": {
                this.ensureNoArguments(step);
                this.traversal(rec$ -> ((GraphTraversal)rec$).dedup(new String[0]));
                break;
            }
            case "state_put": {
                this.ensureExactlyOneArgument(step);
                this.traversal(t -> t.sack((BiFunction)Operator.assign).by(this.withTraversal((GraphTraversal<Vertex, Vertex>)__.start(), () -> step.getArguments().get(0).asTraversal().accept(this))));
                break;
            }
            case "state_get": {
                this.ensureNoArguments(step);
                this.traversal(GraphTraversal::sack);
                break;
            }
            case "project": {
                this.translateProject(step);
                break;
            }
            case "select": {
                this.translateSelect(step);
                break;
            }
            case "order_by": {
                this.translateOrderBy(step);
                break;
            }
            case "time_limit": {
                this.traversal(t -> t.timeLimit((long)((Integer)step.getArguments().get(0).asValue().getValue() * 1000)));
                break;
            }
            case "edge": {
                this.translateEdge(step);
                break;
            }
            default: {
                throw new RuntimeException("unrecognized step " + step.getName());
            }
        }
    }

    private void translateOrderBy(Step step) {
        Map<String, Boolean> isAscending = step.getArguments().stream().map(a -> (Step)a.asTraversal().getTraversal()).collect(Collectors.toMap(Step::getName, s -> {
            String name;
            if (!s.getNext().isPresent()) {
                throw new RuntimeException("'asc' or 'desc' is required as the next step of " + s.getName());
            }
            switch (name = s.getNext().get().getName().toLowerCase()) {
                case "asc": {
                    return true;
                }
                case "desc": {
                    return false;
                }
            }
            throw new RuntimeException("expected either 'asc' or 'desc' as the second step of order_by");
        }, (o, n) -> {
            throw new RuntimeException("the same property should not appear twice in order_by");
        }));
        this.traversal(t -> {
            t.order();
            isAscending.forEach((k, v) -> t.by((org.apache.tinkerpop.gremlin.process.traversal.Traversal)__.select((String)k), (Comparator)(v != false ? Order.incr : Order.decr)));
        });
    }

    private void translateSelect(Step step) {
        String[] args = (String[])step.getArguments().stream().map(a -> {
            Step s = (Step)a.asTraversal().getTraversal();
            s.getNext().ifPresent(e -> {
                throw new RuntimeException("select expects identifiers, not traversals");
            });
            return s.getName();
        }).toArray(String[]::new);
        this.applySelect(args);
    }

    private void applySelect(String[] args) {
        if (args.length == 0) {
            throw new RuntimeException("select requires at least one argument");
        }
        if (args.length == 1) {
            this.traversal(t -> t.select(args[0]));
        } else {
            this.traversal(t -> {
                t.asAdmin().getBytecode().addStep("select", (Object[])args);
                t.asAdmin().addStep((org.apache.tinkerpop.gremlin.process.traversal.Step)new SelectStep((Traversal.Admin)t.asAdmin(), null, args));
            });
        }
    }

    private void translateProject(Step step) {
        List args = step.getArguments().stream().map(a -> {
            if (!a.getKeyword().isPresent()) {
                throw new RuntimeException("project requires all keyword arguments");
            }
            return a;
        }).collect(Collectors.toList());
        Map<String, Step> map = args.stream().collect(Collectors.toMap(a -> a.getKeyword().get(), a -> (Step)a.asTraversal().getTraversal()));
        String[] keys = map.keySet().toArray(new String[map.keySet().size()]);
        this.traversal(t -> {
            t.asAdmin().getBytecode().addStep("project", (Object[])keys);
            t.asAdmin().addStep((org.apache.tinkerpop.gremlin.process.traversal.Step)new ProjectStep((Traversal.Admin)t.asAdmin(), keys));
        });
        for (String key : keys) {
            this.traversal(t -> t.by(this.withTraversal((GraphTraversal<Vertex, Vertex>)__.start(), () -> ((Step)map.get(key)).accept(this))));
        }
    }

    private void translateLimit(Step step) {
        this.ensureExactlyOneArgument(step);
        Value value = step.getArguments().get(0).asValue();
        if (!value.isInteger()) {
            throw new RuntimeException(step.getName() + " expects an integer argument");
        }
        SGLInteger integer = (SGLInteger)value;
        this.traversal(t -> t.limit((long)integer.getValue().intValue()));
    }

    private void translateNot(Step step) {
        this.ensureExactlyOneArgument(step);
        GraphTraversal child = this.withContext(MetaStepContext.NOTHING, () -> this.withTraversal((GraphTraversal<Vertex, Vertex>)__.start(), () -> this.visit(step.getArguments().get(0))));
        this.traversal(t -> t.not((org.apache.tinkerpop.gremlin.process.traversal.Traversal)child));
    }

    private void translateWhere(Step step) {
        this.ensureExactlyOneArgument(step);
        GraphTraversal child = this.withContext(MetaStepContext.WHERE, () -> this.withTraversal((GraphTraversal<Vertex, Vertex>)__.start(), () -> this.visit(step.getArguments().get(0))));
        this.traversal(t -> t.where((org.apache.tinkerpop.gremlin.process.traversal.Traversal)child));
    }

    private void translateUnion(Step step) {
        List<GraphTraversal> traversals = step.getArguments().stream().map(a -> this.withContext(MetaStepContext.NOTHING, () -> this.withTraversal((GraphTraversal<Vertex, Vertex>)__.start(), () -> {
            Void cfr_ignored_0 = (Void)this.visit(a.asTraversal().getTraversal());
        }))).collect(Collectors.toList());
        GraphTraversal[] args = traversals.toArray(new GraphTraversal[traversals.size()]);
        GraphTraversal<Vertex, Vertex> ignored = this.traversal(t -> t.union((org.apache.tinkerpop.gremlin.process.traversal.Traversal[])args));
    }

    private void translateStart(Step step) {
        List<Map> traversals = step.getArguments().stream().map(Argument::asTraversal).map(TraversalArgument::getTraversal).map(t -> (Step)t).flatMap(ExpandWithin::compute).map(this::vertexIdStep).collect(Collectors.toList());
        Map[] args = traversals.toArray(new Map[traversals.size()]);
        if (args.length == 1) {
            this.traversal(t -> t.hasId((Object)args[0], new Object[0]));
        } else {
            this.traversal(t -> t.hasId((Object)args[0], (Object[])Arrays.copyOfRange(args, 1, args.length)));
        }
    }

    private void translatePath(Step step) {
        List<Argument> arguments;
        boolean startingVertices = this.config.startingVertices();
        if (startingVertices) {
            this.traversal(t -> t.as("starting_vertices_end", new String[0]));
        }
        if ((arguments = step.getArguments()).isEmpty()) {
            this.traversal(GraphTraversal::path);
        } else {
            block8: for (Argument argument : arguments) {
                String name;
                if (!(argument instanceof TraversalArgument)) continue;
                switch (name = ((Step)argument.asTraversal().getTraversal()).getName()) {
                    case "longest": {
                        this.traversal(t -> t.path().fold(new SubseqSet(), (seen, path) -> {
                            if (!seen.contains(path)) {
                                seen.add(path);
                            }
                            return seen;
                        }).flatMap(ps -> ((SubseqSet)ps.get()).all().iterator()));
                        continue block8;
                    }
                    case "with_edges": {
                        this.traversal(GraphTraversal::path);
                        continue block8;
                    }
                }
                throw new RuntimeException("invalid path argument " + arguments.get(0).asValue().getValue());
            }
        }
        if (startingVertices) {
            this.traversal(t -> t.map(p -> ((Path)p.get()).subPath("starting_vertices_start", "starting_vertices_end")));
        }
    }

    private void translateEdge(Step step) {
        this.ensureExactlyOneArgument(step);
        Step arg = (Step)step.getArguments().get(0).asTraversal().getTraversal();
        if (arg.getNext().isPresent() || !Schema.isEdge(arg.getName())) {
            throw new RuntimeException("edge can only be used with an edge step, not " + arg.getName());
        }
        this.withContext(MetaStepContext.EDGE, () -> (Void)this.visit(arg));
    }

    private void ensureExactlyOneArgument(Step step) {
        if (step.getArguments().size() != 1) {
            throw new RuntimeException(step.getName() + " is expecting exactly one argument");
        }
    }

    private void ensureNoArguments(Step step) {
        if (!step.getArguments().isEmpty()) {
            throw new RuntimeException(step.getName() + " is expecting no arguments");
        }
    }

    private void edgeStep(boolean out, boolean endsWithEdge, Step step) {
        String name = step.getName();
        if (step.getArguments().isEmpty()) {
            this.traversal(t -> {
                if (out) {
                    if (endsWithEdge) {
                        t.outE(new String[]{name});
                    } else {
                        t.out(new String[]{name});
                    }
                } else {
                    String r = Schema.getReverseEdge(name);
                    if (endsWithEdge) {
                        t.inE(new String[]{r});
                    } else {
                        t.in(new String[]{r});
                    }
                }
            });
        } else {
            this.traversal(t -> {
                if (out) {
                    t.outE(new String[]{name});
                } else {
                    t.inE(new String[]{Schema.getReverseEdge(name)});
                }
                for (Argument argument : step.getArguments()) {
                    argument.getKeyword().ifPresent(kw -> t.has(kw, argument.asValue().getValue()));
                }
                if (!endsWithEdge) {
                    if (out) {
                        t.inV();
                    } else {
                        t.outV();
                    }
                }
            });
        }
    }

    @Override
    public Object visitPredicateArgument(PredicateArgument predicateArgument) {
        return this.visit(predicateArgument.getPredicate());
    }

    @Override
    public Object visitTraversalArgument(TraversalArgument traversalArgument) {
        return this.visit(traversalArgument.getTraversal());
    }

    @Override
    public Object visitWildcardArgument(WildcardArgument wildcardArgument) {
        return wildcardArgument;
    }

    private void transitiveEdgeStep(GraphTraversal<Object, Vertex> repeated, Integer limit, boolean isExclusive) {
        GraphTraversal arg = this.config.hasPath() ? repeated.simplePath() : repeated.dedup(new String[0]);
        this.traversal(t -> {
            if (isExclusive) {
                t.repeat((org.apache.tinkerpop.gremlin.process.traversal.Traversal)arg).emit();
            } else {
                t.emit().repeat((org.apache.tinkerpop.gremlin.process.traversal.Traversal)arg);
            }
            if (limit != null) {
                t.times(limit.intValue());
            }
        });
    }

    @Override
    public P<Object> visitEq(Eq eq) {
        return P.eq(eq.getValue().getValue());
    }

    @Override
    public P<Object> visitAnd(And and) {
        return ((P)this.visit(and.getLeft())).and((Predicate)this.visit(and.getRight()));
    }

    @Override
    public P<Object> visitOr(Or or) {
        return ((P)this.visit(or.getLeft())).or((Predicate)this.visit(or.getRight()));
    }

    @Override
    public P<Object> visitNot(Neg neg) {
        return P.not((P)((P)this.visit(neg.getPred())));
    }

    @Override
    public P<Object> visitRelational(Relational relational) {
        Object value = relational.getValue().getValue();
        switch (relational.getOp()) {
            case LESS_THAN: {
                return P.lt(value);
            }
            case LESS_THAN_EQUAL: {
                return P.lte(value);
            }
            case MORE_THAN: {
                return P.gt(value);
            }
            case MORE_THAN_EQUAL: {
                return P.gte(value);
            }
        }
        throw new AssertionError((Object)((Object)((Object)relational.getOp()) + " is not a valid operator"));
    }

    @Override
    public P<Object> visitRegex(Regex regex) {
        return Search.regex((String)regex.getRegex());
    }

    @Override
    public P<Object> visitWithin(Within within) {
        return P.within((Collection)within.getValues().stream().map(Value::getValue).collect(Collectors.toList()));
    }

    private List<EvaluatedArgument<Object>> evaluateArguments(Step step) {
        List<Argument> params = step.getArguments();
        return params.stream().map(p -> new EvaluatedArgument(p.getKeyword().orElse(null), this.visit((Argument)p))).collect(Collectors.toList());
    }

    private void selectivelyBindName(GraphTraversal<Vertex, Vertex> t, String name) {
        switch (this.context) {
            case WHERE: {
                break;
            }
            default: {
                t.as(name, new String[0]);
            }
        }
    }

    private <T> T withContext(MetaStepContext context, Supplier<T> f) {
        MetaStepContext temp = this.context;
        this.context = context;
        T result = f.get();
        this.context = temp;
        return result;
    }

    public static enum MetaStepContext {
        WHERE,
        EDGE,
        NOTHING;

    }
}

