/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.Argument;
import com.sourceclear.sgl.lang.expr.Binding;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.PredicateArgument;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.expr.Step;
import com.sourceclear.sgl.lang.expr.TraversalArgument;
import com.sourceclear.sgl.lang.expr.WildcardArgument;
import java.util.ArrayList;
import java.util.List;

public class BindingInsertionVisitor
extends ASTVisitor<Expr, Step, Argument> {
    private final List<Binding> bindings;

    public BindingInsertionVisitor(List<Binding> bindings) {
        this.bindings = bindings;
    }

    @Override
    public Expr visitBindingSequence(BindingSequence bindingSequence) {
        ArrayList<Binding> newBindings = new ArrayList<Binding>();
        newBindings.addAll(this.bindings);
        newBindings.addAll(bindingSequence.getBindings());
        return new BindingSequence(newBindings, bindingSequence.getBody());
    }

    @Override
    public Expr visitSequence(Sequence sequence) {
        return this.wrapWithBindings(sequence);
    }

    @Override
    public Expr visitAddAction(AddAction action) {
        return action;
    }

    @Override
    public Expr visitRemoveAction(RemoveAction action) {
        return action;
    }

    @Override
    public Expr visitQuery(Query query) {
        return this.wrapWithBindings(query);
    }

    @Override
    public Step visitStep(Step step) {
        return step;
    }

    @Override
    public Argument visitPredicateArgument(PredicateArgument predicateArgument) {
        return predicateArgument;
    }

    @Override
    public Argument visitTraversalArgument(TraversalArgument traversalArgument) {
        return traversalArgument;
    }

    @Override
    public Argument visitWildcardArgument(WildcardArgument wildcardArgument) {
        return wildcardArgument;
    }

    @Override
    public Patterns visitPatterns(Patterns patterns) {
        return patterns.mapSteps(s -> s.accept(this));
    }

    private Expr wrapWithBindings(Expr expr) {
        return new BindingSequence(new ArrayList<Binding>(this.bindings), expr);
    }
}

