/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.Builtins;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.TupleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.TypeStack;
import org.jetbrains.annotations.NotNull;

public class HashType
implements Type {
    @NotNull
    private final Type keyType;
    @NotNull
    private final Type valueType;
    @NotNull
    private final State table;
    @NotNull
    private TypeStack typeStack = new TypeStack();

    public HashType(@NotNull Type keyType, @NotNull Type valueType) {
        this(State.newGlobalTable(), keyType, valueType);
    }

    public HashType(@NotNull State globalTable, @NotNull Type keyType, @NotNull Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        ClassType hash = Builtins.initHashClass(globalTable, keyType, valueType);
        this.table = new State(globalTable, State.StateType.INSTANCE);
        this.table.setParent(hash.getTable());
        this.table.setPath(hash.getTable().path);
    }

    @NotNull
    public TupleType toTupleType(int n) {
        TupleType ret = new TupleType(this.table.getGlobalTable(), new Type[0]);
        for (int i = 0; i < n; ++i) {
            ret.add(this.keyType);
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (this.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof HashType) {
            this.typeStack.push(this, other);
            HashType co = (HashType)other;
            boolean ret = co.keyType.equals(this.keyType) && co.valueType.equals(this.valueType);
            this.typeStack.pop(this, other);
            return ret;
        }
        return false;
    }

    public int hashCode() {
        return "HashType".hashCode();
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public State getTable() {
        return this.table;
    }

    @Override
    public String printType(CyclicTypeRecorder ctr) {
        return "hash";
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }
}

