/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.Type;
import org.jetbrains.annotations.NotNull;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.LiteralNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.UnnamedRestArgNode;
import org.jrubyparser.ast.types.INameNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Binder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Binder.class);

    Binder() {
    }

    static void bind(@NotNull State s, Node target, @NotNull Type rvalue, Binding.Kind kind) {
        if (target instanceof UnnamedRestArgNode) {
            return;
        }
        if (target instanceof AssignableNode) {
            Binder.bind(s, (AssignableNode)target, rvalue, kind);
        } else if (target instanceof AliasNode) {
            Binder.bind(s, (AliasNode)target, rvalue, kind);
        } else if (target instanceof ArgumentNode) {
            s.insert(((ArgumentNode)target).getName(), target, rvalue, kind);
        } else if (target instanceof ClassNode) {
            s.insert(((ClassNode)target).getCPath().getName(), target, rvalue, kind);
        } else if (target instanceof INameNode) {
            s.insert(((INameNode)((Object)target)).getName(), target, rvalue, kind);
        } else if (target != null) {
            LOGGER.trace("invalid target {} for assignment", (Object)target);
        }
    }

    private static void bind(@NotNull State s, AliasNode alias, @NotNull Type rvalue, Binding.Kind kind) {
        String newName;
        switch (alias.getNewName().getNodeType()) {
            case LITERALNODE: {
                newName = ((LiteralNode)alias.getNewName()).getName();
                break;
            }
            case SYMBOLNODE: {
                newName = ((SymbolNode)alias.getNewName()).getName();
                break;
            }
            default: {
                LOGGER.trace("New name of alias is dynamic. Unable to bind type {} to {}", (Object)rvalue, (Object)alias.getNewName().toString());
                return;
            }
        }
        s.insert(newName, alias, rvalue, kind);
    }

    static void bind(@NotNull State s, Node target, @NotNull Type rvalue) {
        Binding.Kind kind = s.getStateType() == State.StateType.FUNCTION ? Binding.Kind.VARIABLE : (s.stateType == State.StateType.CLASS || s.stateType == State.StateType.INSTANCE ? Binding.Kind.ATTRIBUTE : Binding.Kind.SCOPE);
        Binder.bind(s, target, rvalue, kind);
    }

    static void bind(@NotNull State s, @NotNull AssignableNode assignment, @NotNull Type rvalue, Binding.Kind kind) {
        if (assignment instanceof GlobalAsgnNode) {
            Binding b = new Binding(assignment, rvalue, kind);
            String lexicalName = ((GlobalAsgnNode)assignment).getLexicalName();
            b.setQname(lexicalName);
            s.getGlobalTable().update(lexicalName, b);
        } else if (assignment instanceof LocalAsgnNode) {
            s.insert(((LocalAsgnNode)assignment).getLexicalName(), assignment, rvalue, kind);
        } else if (assignment instanceof InstAsgnNode) {
            s.insert(((InstAsgnNode)assignment).getLexicalName(), assignment, rvalue, kind);
        } else if (assignment instanceof ConstDeclNode) {
            s.insert(((ConstDeclNode)assignment).getLexicalName(), assignment, rvalue, kind);
        } else if (assignment instanceof DAsgnNode) {
            s.insert(((DAsgnNode)assignment).getLexicalName(), assignment, rvalue, kind);
        } else {
            LOGGER.trace("Unknown assignable node: {}", (Object)assignment.getNodeType());
        }
    }
}

