/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.visitor;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.Builtins;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.Utils;
import com.sourceclear.pysonar.ast.Alias;
import com.sourceclear.pysonar.ast.Assert;
import com.sourceclear.pysonar.ast.Assign;
import com.sourceclear.pysonar.ast.Attribute;
import com.sourceclear.pysonar.ast.Await;
import com.sourceclear.pysonar.ast.BinOp;
import com.sourceclear.pysonar.ast.Block;
import com.sourceclear.pysonar.ast.Break;
import com.sourceclear.pysonar.ast.Bytes;
import com.sourceclear.pysonar.ast.Call;
import com.sourceclear.pysonar.ast.ClassDef;
import com.sourceclear.pysonar.ast.Comprehension;
import com.sourceclear.pysonar.ast.Continue;
import com.sourceclear.pysonar.ast.Delete;
import com.sourceclear.pysonar.ast.Dict;
import com.sourceclear.pysonar.ast.DictComp;
import com.sourceclear.pysonar.ast.Dummy;
import com.sourceclear.pysonar.ast.Ellipsis;
import com.sourceclear.pysonar.ast.Exec;
import com.sourceclear.pysonar.ast.Expr;
import com.sourceclear.pysonar.ast.ExtSlice;
import com.sourceclear.pysonar.ast.For;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.ast.GeneratorExp;
import com.sourceclear.pysonar.ast.Global;
import com.sourceclear.pysonar.ast.Handler;
import com.sourceclear.pysonar.ast.If;
import com.sourceclear.pysonar.ast.IfExp;
import com.sourceclear.pysonar.ast.Import;
import com.sourceclear.pysonar.ast.ImportFrom;
import com.sourceclear.pysonar.ast.Index;
import com.sourceclear.pysonar.ast.Keyword;
import com.sourceclear.pysonar.ast.ListComp;
import com.sourceclear.pysonar.ast.Module;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.Op;
import com.sourceclear.pysonar.ast.Pass;
import com.sourceclear.pysonar.ast.Print;
import com.sourceclear.pysonar.ast.PyComplex;
import com.sourceclear.pysonar.ast.PyFloat;
import com.sourceclear.pysonar.ast.PyInt;
import com.sourceclear.pysonar.ast.PyList;
import com.sourceclear.pysonar.ast.PySet;
import com.sourceclear.pysonar.ast.Raise;
import com.sourceclear.pysonar.ast.Repr;
import com.sourceclear.pysonar.ast.Return;
import com.sourceclear.pysonar.ast.SetComp;
import com.sourceclear.pysonar.ast.Slice;
import com.sourceclear.pysonar.ast.Starred;
import com.sourceclear.pysonar.ast.Str;
import com.sourceclear.pysonar.ast.Subscript;
import com.sourceclear.pysonar.ast.Try;
import com.sourceclear.pysonar.ast.Tuple;
import com.sourceclear.pysonar.ast.UnaryOp;
import com.sourceclear.pysonar.ast.Unsupported;
import com.sourceclear.pysonar.ast.Url;
import com.sourceclear.pysonar.ast.While;
import com.sourceclear.pysonar.ast.With;
import com.sourceclear.pysonar.ast.Withitem;
import com.sourceclear.pysonar.ast.Yield;
import com.sourceclear.pysonar.ast.YieldFrom;
import com.sourceclear.pysonar.types.ClassType;
import com.sourceclear.pysonar.types.DictType;
import com.sourceclear.pysonar.types.FunType;
import com.sourceclear.pysonar.types.InstanceType;
import com.sourceclear.pysonar.types.ListType;
import com.sourceclear.pysonar.types.ModuleType;
import com.sourceclear.pysonar.types.TupleType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.UnionType;
import com.sourceclear.pysonar.visitor.Visitor2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeInferencer
extends Visitor2<Type, State> {
    private final Analyzer analyzer;

    public TypeInferencer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    @NotNull
    public Type visit(Alias node, State s) throws IOException {
        return this.analyzer.TYPE_UNKNOWN;
    }

    @Override
    @NotNull
    public Type visit(Assert node, State s) throws IOException {
        if (node.test != null) {
            this.visit(node.test, s);
        }
        if (node.msg != null) {
            this.visit(node.msg, s);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Assign node, State s) throws IOException {
        Type valueType = (Type)this.visit(node.value, s);
        this.bind(s, node.target, valueType);
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Attribute node, State s) throws IOException {
        Type targetType = (Type)this.visit(node.target, s);
        if (targetType instanceof UnionType) {
            Set<Type> types = ((UnionType)targetType).types;
            Type retType = this.analyzer.TYPE_UNKNOWN;
            for (Type tt : types) {
                retType = this.analyzer.union(retType, this.getAttrType(node, tt));
            }
            return retType;
        }
        return this.getAttrType(node, targetType);
    }

    @Override
    @NotNull
    public Type visit(Await node, State s) throws IOException {
        if (node.value == null) {
            return this.analyzer.TYPE_NONE;
        }
        return (Type)this.visit(node.value, s);
    }

    @Override
    @NotNull
    public Type visit(BinOp node, State s) throws IOException {
        Type ltype = (Type)this.visit(node.left, s);
        Type rtype = (Type)this.visit(node.right, s);
        if (this.operatorOverridden(ltype, node.op.getMethod())) {
            Type result = this.applyOp(node.op, ltype, rtype, node.op.getMethod(), node, node.left);
            if (result != null) {
                this.analyzer.state.addOverriddenOperatorType(node, result);
                return result;
            }
        } else {
            if (Op.isBoolean(node.op)) {
                return this.analyzer.TYPE_BOOL;
            }
            if (ltype == this.analyzer.TYPE_UNKNOWN) {
                return rtype;
            }
            if (rtype == this.analyzer.TYPE_UNKNOWN) {
                return ltype;
            }
            if (ltype.typeEquals(rtype)) {
                return ltype;
            }
        }
        this.analyzer.putProblem(node, "Cannot apply binary operator " + node.op.getRep() + " to type " + ltype + " and " + rtype);
        return this.analyzer.TYPE_UNKNOWN;
    }

    private boolean operatorOverridden(Type type, String method) {
        Type opType;
        return type instanceof InstanceType && (opType = type.table.lookupAttrType(method)) != null;
    }

    @Nullable
    private Type applyOp(Op op, Type ltype, Type rtype, String method, Node node, Node left) throws IOException {
        Type opType = ltype.table.lookupAttrType(method);
        if (opType instanceof FunType) {
            ((FunType)opType).setSelfType(ltype);
            return this.apply((FunType)opType, Collections.singletonList(rtype), null, null, null, node);
        }
        this.analyzer.putProblem(left, "Operator method " + method + " is not a function");
        return null;
    }

    @Override
    @NotNull
    public Type visit(Block node, State s) throws IOException {
        for (Node n : node.seq) {
            if (!(n instanceof Global)) continue;
            for (Name name : ((Global)n).names) {
                s.addGlobalName(name.id);
                Set<Binding> nb = s.lookup(name.id);
                if (nb == null) continue;
                this.analyzer.state.putRef((Node)name, nb);
            }
        }
        boolean returned = false;
        Type retType = this.analyzer.TYPE_UNKNOWN;
        for (Node n : node.seq) {
            Type t = (Type)this.visit(n, s);
            if (returned) continue;
            retType = this.analyzer.union(retType, t);
            if (UnionType.contains(t, this.analyzer.TYPE_CONT)) continue;
            returned = true;
            retType = UnionType.remove(this.analyzer, retType, this.analyzer.TYPE_CONT);
        }
        return retType;
    }

    @Override
    @NotNull
    public Type visit(Break node, State s) throws IOException {
        return this.analyzer.TYPE_NONE;
    }

    @Override
    @NotNull
    public Type visit(Bytes node, State s) throws IOException {
        return this.analyzer.TYPE_STR;
    }

    @Override
    @NotNull
    public Type visit(Call node, State s) throws IOException {
        Type returnType;
        Type star;
        Type fun = (Type)this.visit(node.func, s);
        List<Type> pos = this.visit(node.args, s);
        HashMap<String, Type> hash = new HashMap<String, Type>();
        if (node.keywords != null) {
            for (Keyword kw : node.keywords) {
                hash.put(kw.arg, (Type)this.visit(kw.value, s));
            }
        }
        Type kw = node.kwargs == null ? null : (Type)this.visit(node.kwargs, s);
        Type type = star = node.starargs == null ? null : (Type)this.visit(node.starargs, s);
        if (fun instanceof UnionType) {
            Set<Type> types = ((UnionType)fun).types;
            returnType = this.analyzer.TYPE_UNKNOWN;
            for (Type ft : types) {
                Type t = this.resolveCall(node, ft, pos, hash, kw, star);
                returnType = this.analyzer.union(returnType, t);
            }
        } else {
            returnType = this.resolveCall(node, fun, pos, hash, kw, star);
        }
        return returnType;
    }

    @Override
    @NotNull
    public Type visit(ClassDef node, State s) throws IOException {
        ClassType classType = new ClassType(this.analyzer, node.name.id, s);
        ArrayList<Type> baseTypes = new ArrayList<Type>();
        for (Node base : node.bases) {
            Type baseType = (Type)this.visit(base, s);
            if (baseType instanceof ClassType) {
                classType.addSuper(baseType);
            } else if (baseType instanceof UnionType) {
                for (Type parent : ((UnionType)baseType).types) {
                    classType.addSuper(parent);
                }
            } else {
                this.analyzer.putProblem(base, base + " is not a class");
            }
            baseTypes.add(baseType);
        }
        node.addSpecialAttribute(classType.table, "__bases__", new TupleType(this.analyzer, baseTypes));
        node.addSpecialAttribute(classType.table, "__name__", this.analyzer.TYPE_STR);
        node.addSpecialAttribute(classType.table, "__dict__", new DictType(this.analyzer, this.analyzer.TYPE_STR, this.analyzer.TYPE_UNKNOWN));
        node.addSpecialAttribute(classType.table, "__module__", this.analyzer.TYPE_STR);
        node.addSpecialAttribute(classType.table, "__doc__", this.analyzer.TYPE_STR);
        this.bind(s, node.name, (Type)classType, Binding.Kind.CLASS);
        if (node.body != null) {
            this.visit(node.body, classType.table);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Comprehension node, State s) throws IOException {
        this.bindIter(s, node.target, node.iter, Binding.Kind.SCOPE);
        this.visit(node.ifs, s);
        return (Type)this.visit(node.target, s);
    }

    @Override
    @NotNull
    public Type visit(Continue node, State s) throws IOException {
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Delete node, State s) throws IOException {
        for (Node n : node.targets) {
            this.visit(n, s);
            if (!(n instanceof Name)) continue;
            s.remove(((Name)n).id);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Dict node, State s) throws IOException {
        Type keyType = this.resolveUnion(node.keys, s);
        Type valType = this.resolveUnion(node.values, s);
        return new DictType(this.analyzer, keyType, valType);
    }

    @Override
    @NotNull
    public Type visit(DictComp node, State s) throws IOException {
        this.visit(node.generators, s);
        Type keyType = (Type)this.visit(node.key, s);
        Type valueType = (Type)this.visit(node.value, s);
        return new DictType(this.analyzer, keyType, valueType);
    }

    @Override
    @NotNull
    public Type visit(Dummy node, State s) throws IOException {
        return this.analyzer.TYPE_UNKNOWN;
    }

    @Override
    @NotNull
    public Type visit(Ellipsis node, State s) throws IOException {
        return this.analyzer.TYPE_NONE;
    }

    @Override
    @NotNull
    public Type visit(Exec node, State s) throws IOException {
        if (node.body != null) {
            this.visit(node.body, s);
        }
        if (node.globals != null) {
            this.visit(node.globals, s);
        }
        if (node.locals != null) {
            this.visit(node.locals, s);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Expr node, State s) throws IOException {
        if (node.value != null) {
            this.visit(node.value, s);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(ExtSlice node, State s) throws IOException {
        for (Node d : node.dims) {
            this.visit(d, s);
        }
        return new ListType(this.analyzer);
    }

    @Override
    @NotNull
    public Type visit(For node, State s) throws IOException {
        this.bindIter(s, node.target, node.iter, Binding.Kind.SCOPE);
        Type ret = node.body == null ? this.analyzer.TYPE_UNKNOWN : this.visit(node.body, s);
        if (node.orelse != null) {
            ret = this.analyzer.union(ret, this.visit(node.orelse, s));
        }
        return ret;
    }

    @Override
    @NotNull
    public Type visit(FunctionDef node, State s) throws IOException {
        State env = s.getForwarding();
        FunType fun = new FunType(this.analyzer, node, env);
        fun.table.setParent(s);
        fun.table.setPath(s.extendPath(node.name.id));
        fun.setDefaultTypes(this.visit(node.defaults, s));
        this.analyzer.state.addUncalled(fun);
        if (node.isLamba) {
            return fun;
        }
        Binding.Kind funkind = s.stateType == State.StateType.CLASS ? ("__init__".equals(node.name.id) ? Binding.Kind.CONSTRUCTOR : Binding.Kind.METHOD) : Binding.Kind.FUNCTION;
        Type outType = s.type;
        if (outType instanceof ClassType) {
            fun.setCls((ClassType)outType);
        }
        this.bind(s, node.name, (Type)fun, funkind);
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(GeneratorExp node, State s) throws IOException {
        this.visit(node.generators, s);
        return new ListType(this.analyzer, (Type)this.visit(node.elt, s));
    }

    @Override
    @NotNull
    public Type visit(Global node, State s) throws IOException {
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Handler node, State s) throws IOException {
        Type typeval = this.analyzer.TYPE_UNKNOWN;
        if (node.exceptions != null) {
            typeval = this.resolveUnion(node.exceptions, s);
        }
        if (node.binder != null) {
            this.bind(s, node.binder, typeval);
        }
        if (node.body != null) {
            return this.visit(node.body, s);
        }
        return this.analyzer.TYPE_UNKNOWN;
    }

    @Override
    @NotNull
    public Type visit(If node, State s) throws IOException {
        State s1 = s.copy();
        State s2 = s.copy();
        this.visit(node.test, s);
        Type type1 = node.body != null ? (Type)this.visit(node.body, s1) : this.analyzer.TYPE_CONT;
        Type type2 = node.orelse != null ? (Type)this.visit(node.orelse, s2) : this.analyzer.TYPE_CONT;
        boolean cont1 = UnionType.contains(type1, this.analyzer.TYPE_CONT);
        boolean cont2 = UnionType.contains(type2, this.analyzer.TYPE_CONT);
        if (cont1 && cont2) {
            s1.merge(s2);
            s.overwrite(s1);
        } else if (cont1) {
            s.overwrite(s1);
        } else if (cont2) {
            s.overwrite(s2);
        }
        return this.analyzer.union(type1, type2);
    }

    @Override
    @NotNull
    public Type visit(IfExp node, State s) throws IOException {
        this.visit(node.test, s);
        Type type1 = node.body != null ? (Type)this.visit(node.body, s) : this.analyzer.TYPE_CONT;
        Type type2 = node.orelse != null ? (Type)this.visit(node.orelse, s) : this.analyzer.TYPE_CONT;
        return this.analyzer.union(type1, type2);
    }

    @Override
    @NotNull
    public Type visit(Import node, State s) throws IOException {
        for (Alias a : node.names) {
            Type mod = this.analyzer.loadModule(a.name, s);
            if (mod == null) {
                this.analyzer.putProblem(node, "Cannot load module");
                continue;
            }
            if (a.asname == null) continue;
            s.insert(a.asname.id, a.asname, mod, Binding.Kind.VARIABLE);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(ImportFrom node, State s) throws IOException {
        if (node.module == null) {
            return this.analyzer.TYPE_CONT;
        }
        Type mod = this.analyzer.loadModule(node.module, s);
        if (mod == null) {
            this.analyzer.putProblem(node, "Cannot load module");
        } else if (node.isImportStar()) {
            node.importStar(s, mod);
        } else {
            for (Alias a : node.names) {
                Name first = a.name.get(0);
                Set<Binding> bs = mod.table.lookup(first.id);
                if (bs != null) {
                    if (a.asname != null) {
                        s.update(a.asname.id, bs);
                        this.analyzer.state.putRef((Node)a.asname, bs);
                        continue;
                    }
                    s.update(first.id, bs);
                    this.analyzer.state.putRef((Node)first, bs);
                    continue;
                }
                ArrayList<Name> ext = new ArrayList<Name>(node.module);
                ext.add(first);
                Type mod2 = this.analyzer.loadModule(ext, s);
                if (mod2 == null) continue;
                if (a.asname != null) {
                    s.insert(a.asname.id, a.asname, mod2, Binding.Kind.VARIABLE);
                    continue;
                }
                s.insert(first.id, first, mod2, Binding.Kind.VARIABLE);
            }
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Index node, State s) throws IOException {
        return (Type)this.visit(node.value, s);
    }

    @Override
    @NotNull
    public Type visit(Keyword node, State s) throws IOException {
        return (Type)this.visit(node.value, s);
    }

    @Override
    @NotNull
    public Type visit(ListComp node, State s) throws IOException {
        this.visit(node.generators, s);
        return new ListType(this.analyzer, (Type)this.visit(node.elt, s));
    }

    @Override
    @NotNull
    public Type visit(Module node, State s) throws IOException {
        ModuleType mt = new ModuleType(this.analyzer, node.name, node.getFile(), this.analyzer.globaltable);
        s.insert(Utils.moduleQname(node.getFile()), node, mt, Binding.Kind.MODULE);
        if (node.body != null) {
            this.visit(node.body, mt.table);
        }
        return mt;
    }

    @Override
    @NotNull
    public Type visit(Name node, State s) throws IOException {
        Set<Binding> b = s.lookup(node.id);
        if (b != null) {
            this.analyzer.state.putRef((Node)node, b);
            return this.analyzer.makeUnion(b);
        }
        if (node.id.equals("True") || node.id.equals("False")) {
            return this.analyzer.TYPE_BOOL;
        }
        this.analyzer.putProblem(node, "unbound variable " + node.id);
        InstanceType t = this.analyzer.TYPE_UNKNOWN;
        t.table.setPath(s.extendPath(node.id));
        return t;
    }

    @Override
    @NotNull
    public Type visit(Pass node, State s) throws IOException {
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Print node, State s) throws IOException {
        if (node.dest != null) {
            this.visit(node.dest, s);
        }
        if (node.values != null) {
            this.visit(node.values, s);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(PyComplex node, State s) throws IOException {
        return this.analyzer.TYPE_COMPLEX;
    }

    @Override
    @NotNull
    public Type visit(PyFloat node, State s) throws IOException {
        return this.analyzer.TYPE_FLOAT;
    }

    @Override
    @NotNull
    public Type visit(PyInt node, State s) throws IOException {
        return this.analyzer.TYPE_INT;
    }

    @Override
    @NotNull
    public Type visit(PyList node, State s) throws IOException {
        if (node.elts.size() == 0) {
            return new ListType(this.analyzer);
        }
        ListType listType = new ListType(this.analyzer);
        for (Node elt : node.elts) {
            listType.add((Type)this.visit(elt, s));
            if (!(elt instanceof Str)) continue;
            listType.addValue(((Str)elt).value);
        }
        return listType;
    }

    @Override
    @NotNull
    public Type visit(PySet node, State s) throws IOException {
        if (node.elts.size() == 0) {
            return new ListType(this.analyzer);
        }
        ListType listType = null;
        for (Node elt : node.elts) {
            if (listType == null) {
                listType = new ListType(this.analyzer, (Type)this.visit(elt, s));
                continue;
            }
            listType.add((Type)this.visit(elt, s));
        }
        return listType;
    }

    @Override
    @NotNull
    public Type visit(Raise node, State s) throws IOException {
        if (node.exceptionType != null) {
            this.visit(node.exceptionType, s);
        }
        if (node.inst != null) {
            this.visit(node.inst, s);
        }
        if (node.traceback != null) {
            this.visit(node.traceback, s);
        }
        return this.analyzer.TYPE_CONT;
    }

    @Override
    @NotNull
    public Type visit(Repr node, State s) throws IOException {
        if (node.value != null) {
            this.visit(node.value, s);
        }
        return this.analyzer.TYPE_STR;
    }

    @Override
    @NotNull
    public Type visit(Return node, State s) throws IOException {
        if (node.value == null) {
            return this.analyzer.TYPE_NONE;
        }
        return (Type)this.visit(node.value, s);
    }

    @Override
    @NotNull
    public Type visit(SetComp node, State s) throws IOException {
        this.visit(node.generators, s);
        return new ListType(this.analyzer, (Type)this.visit(node.elt, s));
    }

    @Override
    @NotNull
    public Type visit(Slice node, State s) throws IOException {
        if (node.lower != null) {
            this.visit(node.lower, s);
        }
        if (node.step != null) {
            this.visit(node.step, s);
        }
        if (node.upper != null) {
            this.visit(node.upper, s);
        }
        return new ListType(this.analyzer);
    }

    @Override
    @NotNull
    public Type visit(Starred node, State s) throws IOException {
        return (Type)this.visit(node.value, s);
    }

    @Override
    @NotNull
    public Type visit(Str node, State s) throws IOException {
        return this.analyzer.TYPE_STR;
    }

    @Override
    @NotNull
    public Type visit(Subscript node, State s) throws IOException {
        Type st;
        Type vt = (Type)this.visit(node.value, s);
        Type type = st = node.slice == null ? null : (Type)this.visit(node.slice, s);
        if (vt instanceof UnionType) {
            Type retType = this.analyzer.TYPE_UNKNOWN;
            for (Type t : ((UnionType)vt).types) {
                retType = this.analyzer.union(retType, this.getSubscript(node, t, st, s));
            }
            return retType;
        }
        return this.getSubscript(node, vt, st, s);
    }

    @Override
    @NotNull
    public Type visit(Try node, State s) throws IOException {
        Type tp1 = this.analyzer.TYPE_UNKNOWN;
        Type tp2 = this.analyzer.TYPE_UNKNOWN;
        Type tph = this.analyzer.TYPE_UNKNOWN;
        Type tpFinal = this.analyzer.TYPE_UNKNOWN;
        if (node.handlers != null) {
            for (Handler h : node.handlers) {
                tph = this.analyzer.union(tph, this.visit(h, s));
            }
        }
        if (node.body != null) {
            tp1 = this.visit(node.body, s);
        }
        if (node.orelse != null) {
            tp2 = this.visit(node.orelse, s);
        }
        if (node.finalbody != null) {
            tpFinal = this.visit(node.finalbody, s);
        }
        return new UnionType(this.analyzer, tp1, tp2, tph, tpFinal);
    }

    @Override
    @NotNull
    public Type visit(Tuple node, State s) throws IOException {
        TupleType t = new TupleType(this.analyzer);
        for (Node e : node.elts) {
            t.add((Type)this.visit(e, s));
        }
        return t;
    }

    @Override
    @NotNull
    public Type visit(UnaryOp node, State s) throws IOException {
        return (Type)this.visit(node.operand, s);
    }

    @Override
    @NotNull
    public Type visit(Unsupported node, State s) throws IOException {
        return this.analyzer.TYPE_NONE;
    }

    @Override
    @NotNull
    public Type visit(Url node, State s) throws IOException {
        return this.analyzer.TYPE_STR;
    }

    @Override
    @NotNull
    public Type visit(While node, State s) throws IOException {
        this.visit(node.test, s);
        Type t = this.analyzer.TYPE_UNKNOWN;
        if (node.body != null) {
            t = (Type)this.visit(node.body, s);
        }
        if (node.orelse != null) {
            t = this.analyzer.union(t, (Type)this.visit(node.orelse, s));
        }
        return t;
    }

    @Override
    @NotNull
    public Type visit(With node, State s) throws IOException {
        for (Withitem item : node.items) {
            Type val = (Type)this.visit(item.context_expr, s);
            if (item.optional_vars == null) continue;
            this.bind(s, item.optional_vars, val);
        }
        return this.visit(node.body, s);
    }

    @Override
    @NotNull
    public Type visit(Withitem node, State s) throws IOException {
        return this.analyzer.TYPE_UNKNOWN;
    }

    @Override
    @NotNull
    public Type visit(Yield node, State s) throws IOException {
        if (node.value != null) {
            return new ListType(this.analyzer, (Type)this.visit(node.value, s));
        }
        return this.analyzer.TYPE_NONE;
    }

    @Override
    @NotNull
    public Type visit(YieldFrom node, State s) throws IOException {
        if (node.value != null) {
            return new ListType(this.analyzer, (Type)this.visit(node.value, s));
        }
        return this.analyzer.TYPE_NONE;
    }

    @NotNull
    private Type resolveUnion(@NotNull Collection<? extends Node> nodes, State s) throws IOException {
        Type result = this.analyzer.TYPE_UNKNOWN;
        for (Node node : nodes) {
            Type nodeType = (Type)this.visit(node, s);
            result = this.analyzer.union(result, nodeType);
        }
        return result;
    }

    public void setAttr(Attribute node, State s, @NotNull Type v) throws IOException {
        Type targetType = (Type)this.visit(node.target, s);
        if (targetType instanceof UnionType) {
            Set<Type> types = ((UnionType)targetType).types;
            for (Type tp : types) {
                this.setAttrType(node, tp, v);
            }
        } else {
            this.setAttrType(node, targetType, v);
        }
    }

    private void addRef(Attribute node, @NotNull Type targetType, @NotNull Set<Binding> bs) {
        for (Binding b : bs) {
            this.analyzer.state.putRef((Node)node.attr, b);
            if (node.parent == null || !(node.parent instanceof Call) || !(b.type instanceof FunType) || !(targetType instanceof InstanceType)) continue;
            ((FunType)b.type).setSelfType(targetType);
        }
    }

    private void setAttrType(Attribute node, @NotNull Type targetType, @NotNull Type v) {
        if (targetType.isUnknownType()) {
            this.analyzer.putProblem(node, "Can't set attribute for UnknownType");
            return;
        }
        Set<Binding> bs = targetType.table.lookupAttr(node.attr.id);
        if (bs != null) {
            this.addRef(node, targetType, bs);
        }
        targetType.table.insert(node.attr.id, node.attr, v, Binding.Kind.ATTRIBUTE);
    }

    public Type getAttrType(Attribute node, @NotNull Type targetType) {
        Set<Binding> bs = targetType.table.lookupAttr(node.attr.id);
        if (bs == null) {
            this.analyzer.putProblem(node.attr, "attribute not found in type: " + targetType);
            InstanceType t = this.analyzer.TYPE_UNKNOWN;
            t.table.setPath(targetType.table.extendPath(node.attr.id));
            return t;
        }
        this.addRef(node, targetType, bs);
        return this.analyzer.makeUnion(bs);
    }

    @NotNull
    public Type resolveCall(Call node, @NotNull Type fun, List<Type> pos, Map<String, Type> hash, Type kw, Type star) throws IOException {
        if (fun instanceof FunType) {
            FunType ft = (FunType)fun;
            Type callReturnType = this.apply(ft, pos, hash, kw, star, node);
            return callReturnType;
        }
        if (fun instanceof ClassType) {
            return new InstanceType(this.analyzer, fun, node, pos, this);
        }
        this.addWarning(node, "calling non-function and non-class: " + fun);
        return this.analyzer.TYPE_UNKNOWN;
    }

    @NotNull
    public Type apply(@NotNull FunType func, @Nullable List<Type> pos, Map<String, Type> hash, Type kw, Type star, @Nullable Node call) throws IOException {
        this.analyzer.state.removeUncalled(func);
        if (func.func != null && !func.func.called) {
            ++this.analyzer.nCalled;
            func.func.called = true;
        }
        if (func.func == null) {
            return func.getReturnType();
        }
        ArrayList<Type> pTypes = new ArrayList<Type>();
        if (func.selfType != null) {
            pTypes.add(func.selfType);
        } else if (func.cls != null) {
            pTypes.add(func.cls.getCanon());
        }
        if (pos != null) {
            pTypes.addAll(pos);
        }
        this.bindMethodAttrs(func);
        State funcTable = new State(this.analyzer, func.env, State.StateType.FUNCTION);
        if (func.table.parent != null) {
            funcTable.setPath(func.table.parent.extendPath(func.func.name.id));
        } else {
            funcTable.setPath(func.func.name.id);
        }
        Type fromType = this.bindParams(call, func.func, funcTable, func.func.args, func.func.vararg, func.func.kwarg, pTypes, func.defaultTypes, hash, kw, star);
        Type cachedTo = func.getMapping(fromType);
        if (cachedTo != null) {
            func.setSelfType(null);
            return cachedTo;
        }
        if (func.oversized()) {
            func.setSelfType(null);
            return this.analyzer.TYPE_UNKNOWN;
        }
        func.addMapping(fromType, this.analyzer.TYPE_UNKNOWN);
        Type toType = (Type)this.visit(func.func.body, funcTable);
        if (this.missingReturn(toType)) {
            this.analyzer.putProblem(func.func.name, "Function not always return a value");
            if (call != null) {
                this.analyzer.putProblem(call, "Call not always return a value");
            }
        }
        toType = UnionType.remove(this.analyzer, toType, this.analyzer.TYPE_CONT);
        func.addMapping(fromType, toType);
        func.setSelfType(null);
        return toType;
    }

    @NotNull
    private Type bindParams(@Nullable Node call, @NotNull FunctionDef func, @NotNull State funcTable, @Nullable List<Node> args, @Nullable Name rest, @Nullable Name restKw, @Nullable List<Type> pTypes, @Nullable List<Type> dTypes, @Nullable Map<String, Type> hash, @Nullable Type kw, @Nullable Type star) throws IOException {
        TupleType fromType = new TupleType(this.analyzer);
        int pSize = args == null ? 0 : args.size();
        int aSize = pTypes == null ? 0 : pTypes.size();
        int dSize = dTypes == null ? 0 : dTypes.size();
        int nPos = pSize - dSize;
        if (star != null && star instanceof ListType) {
            star = ((ListType)star).toTupleType();
        }
        int j = 0;
        for (int i = 0; i < pSize; ++i) {
            Type aType;
            Node arg = args.get(i);
            if (i < aSize) {
                aType = pTypes.get(i);
            } else if (i - nPos >= 0 && i - nPos < dSize) {
                aType = dTypes.get(i - nPos);
            } else if (hash != null && args.get(i) instanceof Name && hash.containsKey(((Name)args.get((int)i)).id)) {
                aType = hash.get(((Name)args.get((int)i)).id);
                hash.remove(((Name)args.get((int)i)).id);
            } else if (star != null && star instanceof TupleType && j < ((TupleType)star).eltTypes.size()) {
                aType = ((TupleType)star).get(j++);
            } else {
                aType = this.analyzer.TYPE_UNKNOWN;
                if (call != null) {
                    this.analyzer.putProblem(args.get(i), "unable to bind argument:" + args.get(i));
                }
            }
            this.bind(funcTable, arg, aType, Binding.Kind.PARAMETER);
            fromType.add(aType);
        }
        if (restKw != null) {
            if (hash != null && !hash.isEmpty()) {
                Type hashType = this.analyzer.newUnion(hash.values());
                this.bind(funcTable, restKw, (Type)new DictType(this.analyzer, this.analyzer.TYPE_STR, hashType), Binding.Kind.PARAMETER);
            } else {
                this.bind(funcTable, restKw, (Type)this.analyzer.TYPE_UNKNOWN, Binding.Kind.PARAMETER);
            }
        }
        if (rest != null) {
            if (pTypes.size() > pSize) {
                if (func.afterRest != null) {
                    int nAfter = func.afterRest.size();
                    for (int i = 0; i < nAfter; ++i) {
                        this.bind(funcTable, func.afterRest.get(i), pTypes.get(pTypes.size() - nAfter + i), Binding.Kind.PARAMETER);
                    }
                    if (pTypes.size() - nAfter > 0) {
                        TupleType restType = new TupleType(this.analyzer, pTypes.subList(pSize, pTypes.size() - nAfter));
                        this.bind(funcTable, rest, (Type)restType, Binding.Kind.PARAMETER);
                    }
                } else {
                    TupleType restType = new TupleType(this.analyzer, pTypes.subList(pSize, pTypes.size()));
                    this.bind(funcTable, rest, (Type)restType, Binding.Kind.PARAMETER);
                }
            } else {
                this.bind(funcTable, rest, (Type)this.analyzer.TYPE_UNKNOWN, Binding.Kind.PARAMETER);
            }
        }
        return fromType;
    }

    void bindMethodAttrs(@NotNull FunType cl) {
        Type cls;
        if (cl.table.parent != null && (cls = cl.table.parent.type) != null && cls instanceof ClassType) {
            this.addReadOnlyAttr(cl, "im_class", cls, Binding.Kind.CLASS);
            this.addReadOnlyAttr(cl, "__class__", cls, Binding.Kind.CLASS);
            this.addReadOnlyAttr(cl, "im_self", cls, Binding.Kind.ATTRIBUTE);
            this.addReadOnlyAttr(cl, "__self__", cls, Binding.Kind.ATTRIBUTE);
        }
    }

    void addReadOnlyAttr(@NotNull FunType fun, String name, @NotNull Type type, Binding.Kind kind) {
        Url loc = Builtins.newDataModelUrl(this.analyzer, "the-standard-type-hierarchy");
        Binding b = new Binding(this.analyzer, name, loc, type, kind);
        fun.table.update(name, b);
        b.markSynthetic();
        b.markStatic();
    }

    boolean missingReturn(@NotNull Type toType) {
        boolean hasNone = false;
        boolean hasOther = false;
        if (toType instanceof UnionType) {
            for (Type t : ((UnionType)toType).types) {
                if (t == this.analyzer.TYPE_NONE || t == this.analyzer.TYPE_CONT) {
                    hasNone = true;
                    continue;
                }
                hasOther = true;
            }
        }
        return hasNone && hasOther;
    }

    @NotNull
    public Type getSubscript(Node node, @NotNull Type vt, @Nullable Type st, State s) throws IOException {
        if (vt.isUnknownType()) {
            return this.analyzer.TYPE_UNKNOWN;
        }
        if (vt instanceof ListType) {
            return this.getListSubscript(node, vt, st, s);
        }
        if (vt instanceof TupleType) {
            return this.getListSubscript(node, ((TupleType)vt).toListType(), st, s);
        }
        if (vt instanceof DictType) {
            DictType dt = (DictType)vt;
            if (!dt.keyType.equals(st)) {
                this.addWarning(node, "Possible KeyError (wrong type for subscript)");
            }
            return ((DictType)vt).valueType;
        }
        if (vt == this.analyzer.TYPE_STR) {
            if (st != null && (st instanceof ListType || st.isNumType())) {
                return vt;
            }
            this.addWarning(node, "Possible KeyError (wrong type for subscript)");
            return this.analyzer.TYPE_UNKNOWN;
        }
        return this.analyzer.TYPE_UNKNOWN;
    }

    @NotNull
    private Type getListSubscript(Node node, @NotNull Type vt, @Nullable Type st, State s) throws IOException {
        if (vt instanceof ListType) {
            if (st != null && st instanceof ListType) {
                return vt;
            }
            if (st == null || st.isNumType()) {
                return ((ListType)vt).eltType;
            }
            Type sliceFunc = vt.table.lookupAttrType("__getslice__");
            if (sliceFunc == null) {
                this.addError(node, "The type can't be sliced: " + vt);
                return this.analyzer.TYPE_UNKNOWN;
            }
            if (sliceFunc instanceof FunType) {
                return this.apply((FunType)sliceFunc, null, null, null, null, node);
            }
            this.addError(node, "The type's __getslice__ method is not a function: " + sliceFunc);
            return this.analyzer.TYPE_UNKNOWN;
        }
        return this.analyzer.TYPE_UNKNOWN;
    }

    public void bind(@NotNull State s, Node target, @NotNull Type rvalue, Binding.Kind kind) throws IOException {
        if (target instanceof Name) {
            this.bind(s, (Name)target, rvalue, kind);
        } else if (target instanceof Tuple) {
            this.bind(s, ((Tuple)target).elts, rvalue, kind);
        } else if (target instanceof PyList) {
            this.bind(s, ((PyList)target).elts, rvalue, kind);
        } else if (target instanceof Attribute) {
            this.setAttr((Attribute)target, s, rvalue);
        } else if (target instanceof Subscript) {
            Subscript sub = (Subscript)target;
            Type valueType = (Type)this.visit(sub.value, s);
            this.visit(sub.slice, s);
            if (valueType instanceof ListType) {
                ListType t = (ListType)valueType;
                t.setElementType(this.analyzer.union(t.eltType, rvalue));
            }
        } else if (target != null) {
            this.analyzer.putProblem(target, "invalid location for assignment");
        }
    }

    public void bind(@NotNull State s, Node target, @NotNull Type rvalue) throws IOException {
        Binding.Kind kind = s.stateType == State.StateType.FUNCTION ? Binding.Kind.VARIABLE : (s.stateType == State.StateType.CLASS || s.stateType == State.StateType.INSTANCE ? Binding.Kind.ATTRIBUTE : Binding.Kind.SCOPE);
        this.bind(s, target, rvalue, kind);
    }

    public void bind(@NotNull State s, @NotNull List<Node> xs, @NotNull Type rvalue, Binding.Kind kind) throws IOException {
        if (rvalue instanceof TupleType) {
            List<Type> vs = ((TupleType)rvalue).eltTypes;
            if (xs.size() != vs.size()) {
                this.reportUnpackMismatch(xs, vs.size());
            } else {
                for (int i = 0; i < xs.size(); ++i) {
                    this.bind(s, xs.get(i), vs.get(i), kind);
                }
            }
        } else if (rvalue instanceof ListType) {
            this.bind(s, xs, (Type)((ListType)rvalue).toTupleType(xs.size()), kind);
        } else if (rvalue instanceof DictType) {
            this.bind(s, xs, (Type)((DictType)rvalue).toTupleType(xs.size()), kind);
        } else if (rvalue.isUnknownType()) {
            for (Node x : xs) {
                this.bind(s, x, (Type)this.analyzer.TYPE_UNKNOWN, kind);
            }
        } else if (xs.size() > 0) {
            this.analyzer.putProblem(xs.get(0).getFile(), xs.get((int)0).start, xs.get((int)(xs.size() - 1)).end, "unpacking non-iterable: " + rvalue);
        }
    }

    public void bind(@NotNull State s, @NotNull Name name, @NotNull Type rvalue, Binding.Kind kind) {
        if (s.isGlobalName(name.id)) {
            Set<Binding> bs = s.lookup(name.id);
            if (bs != null) {
                for (Binding b : bs) {
                    b.addType(rvalue);
                    this.analyzer.state.putRef((Node)name, b);
                }
            }
        } else {
            s.insert(name.id, name, rvalue, kind);
        }
    }

    public void bindIter(@NotNull State s, Node target, @NotNull Node iter, Binding.Kind kind) throws IOException {
        Type iterType = (Type)this.visit(iter, s);
        if (iterType instanceof ListType) {
            this.bind(s, target, ((ListType)iterType).eltType, kind);
        } else if (iterType instanceof TupleType) {
            this.bind(s, target, ((TupleType)iterType).toListType().eltType, kind);
        } else {
            Set<Binding> ents = iterType.table.lookupAttr("__iter__");
            if (ents != null) {
                for (Binding ent : ents) {
                    if (ent == null || !(ent.type instanceof FunType)) {
                        if (!iterType.isUnknownType()) {
                            this.analyzer.putProblem(iter, "not an iterable type: " + iterType);
                        }
                        this.bind(s, target, (Type)this.analyzer.TYPE_UNKNOWN, kind);
                        continue;
                    }
                    this.bind(s, target, ((FunType)ent.type).getReturnType(), kind);
                }
            } else {
                this.bind(s, target, (Type)this.analyzer.TYPE_UNKNOWN, kind);
            }
        }
    }

    private void reportUnpackMismatch(@NotNull List<Node> xs, int vsize) {
        int xsize = xs.size();
        int beg = xs.get((int)0).start;
        int end = xs.get((int)(xs.size() - 1)).end;
        int diff = xsize - vsize;
        String msg = diff > 0 ? "ValueError: need more than " + vsize + " values to unpack" : "ValueError: too many values to unpack";
        this.analyzer.putProblem(xs.get(0).getFile(), beg, end, msg);
    }

    public void addWarning(Node node, String msg) {
        this.analyzer.putProblem(node, msg);
    }

    public void addError(Node node, String msg) {
        this.analyzer.putProblem(node, msg);
    }
}

