/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.types.FloatType;
import com.sourceclear.pysonar.types.IntType;
import com.sourceclear.pysonar.types.ModuleType;
import com.sourceclear.pysonar.types.TypeVisitor;
import com.sourceclear.pysonar.types.UnionType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class Type {
    protected final Analyzer analyzer;
    @NotNull
    public State table;
    public Path file = null;

    public Type(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.table = new State(analyzer, null, State.StateType.SCOPE);
    }

    public boolean equals(Object other) {
        return this.typeEquals(other);
    }

    public abstract boolean typeEquals(Object var1);

    public void setTable(@NotNull State table) {
        this.table = table;
    }

    public void setFile(Path file) {
        this.file = file;
    }

    public boolean isNumType() {
        return this instanceof IntType || this instanceof FloatType;
    }

    public boolean isUnknownType() {
        return this == this.analyzer.TYPE_UNKNOWN;
    }

    @NotNull
    public ModuleType asModuleType() {
        if (this instanceof UnionType) {
            for (Type t : ((UnionType)this).types) {
                if (!(t instanceof ModuleType)) continue;
                return t.asModuleType();
            }
            throw new IllegalArgumentException("Union type does not contain a ModuleType");
        }
        if (this instanceof ModuleType) {
            return (ModuleType)this;
        }
        throw new IllegalArgumentException("Not a module type");
    }

    protected abstract String printType(CyclicTypeRecorder var1);

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }

    public abstract <T> T accept(TypeVisitor<T> var1);

    protected class CyclicTypeRecorder {
        int count = 0;
        @NotNull
        private Map<Type, Integer> elements = new HashMap<Type, Integer>();
        @NotNull
        private Set<Type> used = new HashSet<Type>();

        protected CyclicTypeRecorder() {
        }

        public Integer push(Type t) {
            ++this.count;
            this.elements.put(t, this.count);
            return this.count;
        }

        public void pop(Type t) {
            this.elements.remove(t);
            this.used.remove(t);
        }

        public Integer visit(Type t) {
            Integer i = this.elements.get(t);
            if (i != null) {
                this.used.add(t);
            }
            return i;
        }

        public boolean isUsed(Type t) {
            return this.used.contains(t);
        }
    }
}

