/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.ast.Call;
import com.sourceclear.pysonar.types.ClassType;
import com.sourceclear.pysonar.types.FunType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import com.sourceclear.pysonar.visitor.TypeInferencer;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InstanceType
extends Type {
    public Type classType;

    public InstanceType(Analyzer analyzer, @NotNull Type c) {
        super(analyzer);
        this.table.setStateType(State.StateType.INSTANCE);
        this.table.addSuper(c.table);
        this.table.setPath(c.table.path);
        this.classType = c;
    }

    public InstanceType(Analyzer analyzer, @NotNull Type c, Call call, List<Type> args, TypeInferencer inferencer) throws IOException {
        this(analyzer, c);
        Type initFunc = this.table.lookupAttrType("__init__");
        if (initFunc != null && initFunc instanceof FunType && ((FunType)initFunc).func != null) {
            ((FunType)initFunc).setSelfType(this);
            inferencer.apply((FunType)initFunc, args, null, null, null, call);
            ((FunType)initFunc).setSelfType(null);
        }
    }

    @Override
    public boolean typeEquals(Object other) {
        if (other instanceof InstanceType) {
            return this.classType.typeEquals(((InstanceType)other).classType);
        }
        return false;
    }

    public int hashCode() {
        return this.classType.hashCode();
    }

    @Override
    protected String printType(Type.CyclicTypeRecorder ctr) {
        return ((ClassType)this.classType).name;
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

