/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.types.TupleType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import org.jetbrains.annotations.NotNull;

public class DictType
extends Type {
    public Type keyType;
    public Type valueType;

    public DictType(Analyzer analyzer, Type key0, Type val0) {
        super(analyzer);
        this.keyType = key0;
        this.valueType = val0;
        this.table.addSuper(analyzer.builtins.BaseDict.table);
        this.table.setPath(analyzer.builtins.BaseDict.table.path);
    }

    public void add(@NotNull Type key, @NotNull Type val) {
        this.keyType = this.analyzer.union(this.keyType, key);
        this.valueType = this.analyzer.union(this.valueType, val);
    }

    @NotNull
    public TupleType toTupleType(int n) {
        TupleType ret = new TupleType(this.analyzer);
        for (int i = 0; i < n; ++i) {
            ret.add(this.keyType);
        }
        return ret;
    }

    @Override
    public boolean typeEquals(Object other) {
        if (this.analyzer.state.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof DictType) {
            this.analyzer.state.typeStack.push(this, other);
            DictType co = (DictType)other;
            boolean result = co.keyType.typeEquals(this.keyType) && co.valueType.typeEquals(this.valueType);
            this.analyzer.state.typeStack.pop(this, other);
            return result;
        }
        return false;
    }

    public int hashCode() {
        return "DictType".hashCode();
    }

    @Override
    protected String printType(@NotNull Type.CyclicTypeRecorder ctr) {
        return "dict";
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

