/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.ast;

import org.jetbrains.annotations.Nullable;

public enum Op {
    Add("+", "__add__"),
    Sub("-", "__sub__"),
    Mul("*", "__mul__"),
    MatMult("@", "__matmult__"),
    Div("/", "__div__"),
    Mod("%", "__mod__"),
    Pow("**", "__pow__"),
    FloorDiv("//", "__floordiv__"),
    Eq("is"),
    Equal("==", "__eq__"),
    Lt("<", "__lt__"),
    Gt(">", "__gt__"),
    BitAnd("&", "__and__"),
    BitOr("|", "__or__"),
    BitXor("^", "__xor__"),
    In("in"),
    LShift("<<", "__lshift__"),
    RShift(">>", "__rshift__"),
    Invert("~", "__invert__"),
    And("and"),
    Or("or"),
    Not("not"),
    NotEqual("!=", "__neq__"),
    NotEq("is not"),
    LtE("<=", "__lte__"),
    GtE(">=", "__gte__"),
    NotIn("not in"),
    Unsupported("??");

    private String rep;
    @Nullable
    private String method;

    private Op(String rep, String method) {
        this.rep = rep;
        this.method = method;
    }

    private Op(String rep) {
        this.rep = rep;
        this.method = null;
    }

    public String getRep() {
        return this.rep;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public static boolean isBoolean(Op op) {
        return op == Eq || op == Equal || op == Lt || op == Gt || op == NotEqual || op == NotEq || op == LtE || op == GtE || op == In || op == NotIn;
    }
}

