/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.ast.Url;
import com.sourceclear.pysonar.types.ClassType;
import com.sourceclear.pysonar.types.DictType;
import com.sourceclear.pysonar.types.FunType;
import com.sourceclear.pysonar.types.InstanceType;
import com.sourceclear.pysonar.types.ListType;
import com.sourceclear.pysonar.types.ModuleType;
import com.sourceclear.pysonar.types.TupleType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.UnionType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Builtins {
    public static final String LIBRARY_URL = "http://docs.python.org/library/";
    public static final String TUTORIAL_URL = "http://docs.python.org/tutorial/";
    public static final String REFERENCE_URL = "http://docs.python.org/reference/";
    public static final String DATAMODEL_URL = "http://docs.python.org/reference/datamodel#";
    private final Analyzer analyzer;
    public ModuleType Builtin;
    public ClassType objectType;
    public ClassType BaseType;
    public ClassType BaseList;
    public InstanceType BaseListInst;
    public ClassType BaseArray;
    public ClassType BaseDict;
    public ClassType BaseTuple;
    public ClassType BaseModule;
    public ClassType BaseFile;
    public InstanceType BaseFileInst;
    public ClassType BaseException;
    public ClassType BaseStruct;
    public ClassType BaseFunction;
    public ClassType BaseClass;
    public ClassType Datetime_datetime;
    public ClassType Datetime_date;
    public ClassType Datetime_time;
    public ClassType Datetime_timedelta;
    public ClassType Datetime_tzinfo;
    public InstanceType Time_struct_time;
    @NotNull
    String[] builtin_exception_types = new String[]{"ArithmeticError", "AssertionError", "AttributeError", "BaseException", "Exception", "DeprecationWarning", "EOFError", "EnvironmentError", "FloatingPointError", "FutureWarning", "GeneratorExit", "IOError", "ImportError", "ImportWarning", "IndentationError", "IndexError", "KeyError", "KeyboardInterrupt", "LookupError", "MemoryError", "NameError", "NotImplemented", "NotImplementedError", "OSError", "OverflowError", "PendingDeprecationWarning", "ReferenceError", "RuntimeError", "RuntimeWarning", "StandardError", "StopIteration", "SyntaxError", "SyntaxWarning", "SystemError", "SystemExit", "TabError", "TypeError", "UnboundLocalError", "UnicodeDecodeError", "UnicodeEncodeError", "UnicodeError", "UnicodeTranslateError", "UnicodeWarning", "UserWarning", "ValueError", "Warning", "ZeroDivisionError"};
    @NotNull
    private Map<String, NativeModule> modules = new HashMap<String, NativeModule>();

    public Builtins(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.buildTypes();
    }

    @NotNull
    public static Url newLibUrl(Analyzer analyzer, String module, String name) {
        return Builtins.newLibUrl(analyzer, module + ".html#" + name);
    }

    @NotNull
    public static Url newLibUrl(Analyzer analyzer, @NotNull String path) {
        if (!path.contains("#") && !path.endsWith(".html")) {
            path = path + ".html";
        }
        return new Url(analyzer, LIBRARY_URL + path);
    }

    @NotNull
    public static Url newRefUrl(Analyzer analyzer, String path) {
        return new Url(analyzer, REFERENCE_URL + path);
    }

    @NotNull
    public static Url newDataModelUrl(Analyzer analyzer, String path) {
        return new Url(analyzer, DATAMODEL_URL + path);
    }

    @NotNull
    public static Url newTutUrl(Analyzer analyzer, String path) {
        return new Url(analyzer, TUTORIAL_URL + path);
    }

    @NotNull
    ClassType newClass(@NotNull String name, State table) {
        return this.newClass(name, table, null, new ClassType[0]);
    }

    @NotNull
    ClassType newClass(@NotNull String name, State table, ClassType superClass, ClassType ... moreSupers) {
        ClassType t = new ClassType(this.analyzer, name, table, superClass);
        for (ClassType c : moreSupers) {
            t.addSuper(c);
        }
        return t;
    }

    @Nullable
    ModuleType newModule(String name) {
        return new ModuleType(this.analyzer, name, null, this.analyzer.globaltable);
    }

    @NotNull
    ClassType newException(@NotNull String name, State t) {
        return this.newClass(name, t, this.BaseException, new ClassType[0]);
    }

    @NotNull
    FunType newFunc() {
        return new FunType(this.analyzer);
    }

    @Nullable
    FunType newFunc(@Nullable Type type) {
        if (type == null) {
            type = this.analyzer.TYPE_UNKNOWN;
        }
        return new FunType(this.analyzer, this.analyzer.TYPE_UNKNOWN, type);
    }

    @NotNull
    ListType newList() {
        return this.newList(this.analyzer.TYPE_UNKNOWN);
    }

    @NotNull
    ListType newList(Type type) {
        return new ListType(this.analyzer, type);
    }

    @NotNull
    DictType newDict(Type ktype, Type vtype) {
        return new DictType(this.analyzer, ktype, vtype);
    }

    @NotNull
    TupleType newTuple(Type ... types) {
        return new TupleType(this.analyzer, types);
    }

    @NotNull
    UnionType newUnion(Type ... types) {
        return new UnionType(this.analyzer, types);
    }

    String[] list(String ... names) {
        return names;
    }

    private void buildTypes() {
        new BuiltinsModule();
        State bt = this.Builtin.table;
        this.objectType = this.newClass("object", bt);
        this.BaseType = this.newClass("type", bt, this.objectType, new ClassType[0]);
        this.BaseTuple = this.newClass("tuple", bt, this.objectType, new ClassType[0]);
        this.BaseList = this.newClass("list", bt, this.objectType, new ClassType[0]);
        this.BaseListInst = new InstanceType(this.analyzer, this.BaseList);
        this.BaseArray = this.newClass("array", bt);
        this.BaseDict = this.newClass("dict", bt, this.objectType, new ClassType[0]);
        ClassType numClass = this.newClass("int", bt, this.objectType, new ClassType[0]);
        this.BaseModule = this.newClass("module", bt);
        this.BaseFile = this.newClass("file", bt, this.objectType, new ClassType[0]);
        this.BaseFileInst = new InstanceType(this.analyzer, this.BaseFile);
        this.BaseFunction = this.newClass("function", bt, this.objectType, new ClassType[0]);
        this.BaseClass = this.newClass("classobj", bt, this.objectType, new ClassType[0]);
    }

    void init() {
        this.buildObjectType();
        this.buildTupleType();
        this.buildArrayType();
        this.buildListType();
        this.buildDictType();
        this.buildNumTypes();
        this.buildStrType();
        this.buildModuleType();
        this.buildFileType();
        this.buildFunctionType();
        this.buildClassType();
        this.modules.get("__builtin__").initBindings();
        new ArrayModule();
        new AudioopModule();
        new BinasciiModule();
        new Bz2Module();
        new CPickleModule();
        new CStringIOModule();
        new CMathModule();
        new CollectionsModule();
        new CryptModule();
        new CTypesModule();
        new DatetimeModule();
        new DbmModule();
        new ErrnoModule();
        new ExceptionsModule();
        new FcntlModule();
        new FpectlModule();
        new GcModule();
        new GdbmModule();
        new GrpModule();
        new ImpModule();
        new ItertoolsModule();
        new MarshalModule();
        new MathModule();
        new Md5Module();
        new MmapModule();
        new NisModule();
        new OperatorModule();
        new OsModule();
        new ParserModule();
        new PosixModule();
        new PwdModule();
        new PyexpatModule();
        new ReadlineModule();
        new ResourceModule();
        new SelectModule();
        new SignalModule();
        new ShaModule();
        new SpwdModule();
        new StropModule();
        new StructModule();
        new SysModule();
        new SyslogModule();
        new TermiosModule();
        new ThreadModule();
        new TimeModule();
        new UnicodedataModule();
        new ZipimportModule();
        new ZlibModule();
    }

    @Nullable
    public ModuleType get(@NotNull String name) {
        if (!name.contains(".")) {
            return this.getModule(name);
        }
        String[] mods = name.split("\\.");
        Type type = this.getModule(mods[0]);
        if (type == null) {
            return null;
        }
        for (int i = 1; i < mods.length; ++i) {
            type = type.table.lookupType(mods[i]);
            if (type instanceof ModuleType) continue;
            return null;
        }
        return type;
    }

    @Nullable
    private ModuleType getModule(String name) {
        NativeModule wrap = this.modules.get(name);
        return wrap == null ? null : wrap.getModule();
    }

    void buildObjectType() {
        String[] obj_methods;
        for (String m : obj_methods = new String[]{"__delattr__", "__format__", "__getattribute__", "__hash__", "__init__", "__new__", "__reduce__", "__reduce_ex__", "__repr__", "__setattr__", "__sizeof__", "__str__", "__subclasshook__"}) {
            this.objectType.table.insert(m, Builtins.newLibUrl(this.analyzer, "stdtypes"), this.newFunc(), Binding.Kind.METHOD);
        }
        this.objectType.table.insert("__doc__", Builtins.newLibUrl(this.analyzer, "stdtypes"), this.analyzer.TYPE_STR, Binding.Kind.CLASS);
        this.objectType.table.insert("__class__", Builtins.newLibUrl(this.analyzer, "stdtypes"), this.analyzer.TYPE_UNKNOWN, Binding.Kind.CLASS);
    }

    void buildTupleType() {
        String[] tuple_methods;
        State bt = this.BaseTuple.table;
        for (String m : tuple_methods = new String[]{"__add__", "__contains__", "__eq__", "__ge__", "__getnewargs__", "__gt__", "__iter__", "__le__", "__len__", "__lt__", "__mul__", "__ne__", "__new__", "__rmul__", "count", "index"}) {
            bt.insert(m, Builtins.newLibUrl(this.analyzer, "stdtypes"), this.newFunc(), Binding.Kind.METHOD);
        }
        bt.insert("__getslice__", Builtins.newDataModelUrl(this.analyzer, "object.__getslice__"), this.newFunc(), Binding.Kind.METHOD);
        bt.insert("__getitem__", Builtins.newDataModelUrl(this.analyzer, "object.__getitem__"), this.newFunc(), Binding.Kind.METHOD);
        bt.insert("__iter__", Builtins.newDataModelUrl(this.analyzer, "object.__iter__"), this.newFunc(), Binding.Kind.METHOD);
    }

    void buildArrayType() {
        String[] array_methods_str;
        String[] array_methods_num;
        String[] array_methods_none;
        for (String m : array_methods_none = new String[]{"append", "buffer_info", "byteswap", "extend", "fromfile", "fromlist", "fromstring", "fromunicode", "index", "insert", "pop", "read", "remove", "reverse", "tofile", "tolist", "typecode", "write"}) {
            this.BaseArray.table.insert(m, Builtins.newLibUrl(this.analyzer, "array"), this.newFunc(this.analyzer.TYPE_NONE), Binding.Kind.METHOD);
        }
        for (String m : array_methods_num = new String[]{"count", "itemsize"}) {
            this.BaseArray.table.insert(m, Builtins.newLibUrl(this.analyzer, "array"), this.newFunc(this.analyzer.TYPE_INT), Binding.Kind.METHOD);
        }
        for (String m : array_methods_str = new String[]{"tostring", "tounicode"}) {
            this.BaseArray.table.insert(m, Builtins.newLibUrl(this.analyzer, "array"), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        }
    }

    void buildListType() {
        String[] list_methods_num;
        String[] list_methods_none;
        this.BaseList.table.insert("__getslice__", Builtins.newDataModelUrl(this.analyzer, "object.__getslice__"), this.newFunc(this.BaseListInst), Binding.Kind.METHOD);
        this.BaseList.table.insert("__getitem__", Builtins.newDataModelUrl(this.analyzer, "object.__getitem__"), this.newFunc(this.BaseList), Binding.Kind.METHOD);
        this.BaseList.table.insert("__iter__", Builtins.newDataModelUrl(this.analyzer, "object.__iter__"), this.newFunc(this.BaseList), Binding.Kind.METHOD);
        for (String m : list_methods_none = new String[]{"append", "extend", "index", "insert", "pop", "remove", "reverse", "sort"}) {
            this.BaseList.table.insert(m, Builtins.newLibUrl(this.analyzer, "stdtypes"), this.newFunc(this.analyzer.TYPE_NONE), Binding.Kind.METHOD);
        }
        for (String m : list_methods_num = new String[]{"count"}) {
            this.BaseList.table.insert(m, Builtins.newLibUrl(this.analyzer, "stdtypes"), this.newFunc(this.analyzer.TYPE_INT), Binding.Kind.METHOD);
        }
    }

    @NotNull
    Url numUrl() {
        return Builtins.newLibUrl(this.analyzer, "stdtypes", "typesnumeric");
    }

    void buildNumTypes() {
        String[] complex_methods_num;
        String[] complex_methods;
        String[] num_methods_num;
        String[] float_methods_num;
        State bft = this.analyzer.TYPE_FLOAT.table;
        for (String m : float_methods_num = new String[]{"__abs__", "__add__", "__coerce__", "__div__", "__divmod__", "__eq__", "__float__", "__floordiv__", "__format__", "__ge__", "__getformat__", "__gt__", "__int__", "__le__", "__long__", "__lt__", "__mod__", "__mul__", "__ne__", "__neg__", "__new__", "__nonzero__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__setformat__", "__sub__", "__truediv__", "__trunc__", "as_integer_ratio", "fromhex", "is_integer"}) {
            bft.insert(m, this.numUrl(), this.newFunc(this.analyzer.TYPE_FLOAT), Binding.Kind.METHOD);
        }
        State bnt = this.analyzer.TYPE_INT.table;
        for (String m : num_methods_num = new String[]{"__abs__", "__add__", "__and__", "__class__", "__cmp__", "__coerce__", "__delattr__", "__div__", "__divmod__", "__doc__", "__float__", "__floordiv__", "__getattribute__", "__getnewargs__", "__hash__", "__hex__", "__index__", "__init__", "__int__", "__invert__", "__long__", "__lshift__", "__mod__", "__mul__", "__neg__", "__new__", "__nonzero__", "__oct__", "__or__", "__pos__", "__pow__", "__radd__", "__rand__", "__rdiv__", "__rdivmod__", "__reduce__", "__reduce_ex__", "__repr__", "__rfloordiv__", "__rlshift__", "__rmod__", "__rmul__", "__ror__", "__rpow__", "__rrshift__", "__rshift__", "__rsub__", "__rtruediv__", "__rxor__", "__setattr__", "__str__", "__sub__", "__truediv__", "__xor__"}) {
            bnt.insert(m, this.numUrl(), this.newFunc(this.analyzer.TYPE_INT), Binding.Kind.METHOD);
        }
        bnt.insert("__getnewargs__", this.numUrl(), this.newFunc(this.newTuple(this.analyzer.TYPE_INT)), Binding.Kind.METHOD);
        bnt.insert("hex", this.numUrl(), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        bnt.insert("conjugate", this.numUrl(), this.newFunc(this.analyzer.TYPE_COMPLEX), Binding.Kind.METHOD);
        State bct = this.analyzer.TYPE_COMPLEX.table;
        for (String c : complex_methods = new String[]{"__abs__", "__add__", "__div__", "__divmod__", "__float__", "__floordiv__", "__format__", "__getformat__", "__int__", "__long__", "__mod__", "__mul__", "__neg__", "__new__", "__pos__", "__pow__", "__radd__", "__rdiv__", "__rdivmod__", "__rfloordiv__", "__rmod__", "__rmul__", "__rpow__", "__rsub__", "__rtruediv__", "__sub__", "__truediv__", "conjugate"}) {
            bct.insert(c, this.numUrl(), this.newFunc(this.analyzer.TYPE_COMPLEX), Binding.Kind.METHOD);
        }
        for (String cn : complex_methods_num = new String[]{"__eq__", "__ge__", "__gt__", "__le__", "__lt__", "__ne__", "__nonzero__", "__coerce__"}) {
            bct.insert(cn, this.numUrl(), this.newFunc(this.analyzer.TYPE_INT), Binding.Kind.METHOD);
        }
        bct.insert("__getnewargs__", this.numUrl(), this.newFunc(this.newTuple(this.analyzer.TYPE_COMPLEX)), Binding.Kind.METHOD);
        bct.insert("imag", this.numUrl(), this.analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
        bct.insert("real", this.numUrl(), this.analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
    }

    void buildStrType() {
        String[] str_methods_list;
        String[] str_methods_num;
        String[] str_methods_str;
        this.analyzer.TYPE_STR.table.insert("__getslice__", Builtins.newDataModelUrl(this.analyzer, "object.__getslice__"), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        this.analyzer.TYPE_STR.table.insert("__getitem__", Builtins.newDataModelUrl(this.analyzer, "object.__getitem__"), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        this.analyzer.TYPE_STR.table.insert("__iter__", Builtins.newDataModelUrl(this.analyzer, "object.__iter__"), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        for (String m : str_methods_str = new String[]{"capitalize", "center", "decode", "encode", "expandtabs", "format", "index", "join", "ljust", "lower", "lstrip", "partition", "replace", "rfind", "rindex", "rjust", "rpartition", "rsplit", "rstrip", "strip", "swapcase", "title", "translate", "upper", "zfill"}) {
            this.analyzer.TYPE_STR.table.insert(m, Builtins.newLibUrl(this.analyzer, "stdtypes.html#str." + m), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        }
        for (String m : str_methods_num = new String[]{"count", "isalnum", "isalpha", "isdigit", "islower", "isspace", "istitle", "isupper", "find", "startswith", "endswith"}) {
            this.analyzer.TYPE_STR.table.insert(m, Builtins.newLibUrl(this.analyzer, "stdtypes.html#str." + m), this.newFunc(this.analyzer.TYPE_INT), Binding.Kind.METHOD);
        }
        for (String m : str_methods_list = new String[]{"split", "splitlines"}) {
            this.analyzer.TYPE_STR.table.insert(m, Builtins.newLibUrl(this.analyzer, "stdtypes.html#str." + m), this.newFunc(this.newList(this.analyzer.TYPE_STR)), Binding.Kind.METHOD);
        }
        this.analyzer.TYPE_STR.table.insert("partition", Builtins.newLibUrl(this.analyzer, "stdtypes"), this.newFunc(this.newTuple(this.analyzer.TYPE_STR)), Binding.Kind.METHOD);
    }

    void buildModuleType() {
        String[] attrs;
        for (String m : attrs = new String[]{"__doc__", "__file__", "__name__", "__package__"}) {
            this.BaseModule.table.insert(m, Builtins.newTutUrl(this.analyzer, "modules.html"), this.analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
        }
        this.BaseModule.table.insert("__dict__", Builtins.newLibUrl(this.analyzer, "stdtypes", "modules"), this.newDict(this.analyzer.TYPE_STR, this.analyzer.TYPE_UNKNOWN), Binding.Kind.ATTRIBUTE);
    }

    void buildDictType() {
        String[] dict_method_num;
        String[] dict_method_unknown;
        String url = "datastructures.html#dictionaries";
        State bt = this.BaseDict.table;
        bt.insert("__getitem__", Builtins.newTutUrl(this.analyzer, url), this.newFunc(), Binding.Kind.METHOD);
        bt.insert("__iter__", Builtins.newTutUrl(this.analyzer, url), this.newFunc(), Binding.Kind.METHOD);
        bt.insert("get", Builtins.newTutUrl(this.analyzer, url), this.newFunc(), Binding.Kind.METHOD);
        bt.insert("items", Builtins.newTutUrl(this.analyzer, url), this.newFunc(this.newList(this.newTuple(this.analyzer.TYPE_UNKNOWN, this.analyzer.TYPE_UNKNOWN))), Binding.Kind.METHOD);
        bt.insert("keys", Builtins.newTutUrl(this.analyzer, url), this.newFunc(this.BaseList), Binding.Kind.METHOD);
        bt.insert("values", Builtins.newTutUrl(this.analyzer, url), this.newFunc(this.BaseList), Binding.Kind.METHOD);
        for (String m : dict_method_unknown = new String[]{"clear", "copy", "fromkeys", "get", "iteritems", "iterkeys", "itervalues", "pop", "popitem", "setdefault", "update"}) {
            bt.insert(m, Builtins.newTutUrl(this.analyzer, url), this.newFunc(), Binding.Kind.METHOD);
        }
        for (String m : dict_method_num = new String[]{"has_key"}) {
            bt.insert(m, Builtins.newTutUrl(this.analyzer, url), this.newFunc(this.analyzer.TYPE_INT), Binding.Kind.METHOD);
        }
    }

    void buildFileType() {
        String[] methods_none;
        String[] num;
        String[] methods_str;
        String[] methods_unknown;
        String url = "stdtypes.html#bltin-file-objects";
        State table = this.BaseFile.table;
        for (String m : methods_unknown = new String[]{"__enter__", "__exit__", "__iter__", "flush", "readinto", "truncate"}) {
            table.insert(m, Builtins.newLibUrl(this.analyzer, url), this.newFunc(), Binding.Kind.METHOD);
        }
        for (String m : methods_str = new String[]{"next", "read", "readline"}) {
            table.insert(m, Builtins.newLibUrl(this.analyzer, url), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        }
        for (String m : num = new String[]{"fileno", "isatty", "tell"}) {
            table.insert(m, Builtins.newLibUrl(this.analyzer, url), this.newFunc(this.analyzer.TYPE_INT), Binding.Kind.METHOD);
        }
        for (String m : methods_none = new String[]{"close", "seek", "write", "writelines"}) {
            table.insert(m, Builtins.newLibUrl(this.analyzer, url), this.newFunc(this.analyzer.TYPE_NONE), Binding.Kind.METHOD);
        }
        table.insert("readlines", Builtins.newLibUrl(this.analyzer, url), this.newFunc(this.newList(this.analyzer.TYPE_STR)), Binding.Kind.METHOD);
        table.insert("xreadlines", Builtins.newLibUrl(this.analyzer, url), this.newFunc(this.analyzer.TYPE_STR), Binding.Kind.METHOD);
        table.insert("closed", Builtins.newLibUrl(this.analyzer, url), this.analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
        table.insert("encoding", Builtins.newLibUrl(this.analyzer, url), this.analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
        table.insert("errors", Builtins.newLibUrl(this.analyzer, url), this.analyzer.TYPE_UNKNOWN, Binding.Kind.ATTRIBUTE);
        table.insert("mode", Builtins.newLibUrl(this.analyzer, url), this.analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
        table.insert("name", Builtins.newLibUrl(this.analyzer, url), this.analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
        table.insert("softspace", Builtins.newLibUrl(this.analyzer, url), this.analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
        table.insert("newlines", Builtins.newLibUrl(this.analyzer, url), this.newUnion(this.analyzer.TYPE_STR, this.newTuple(this.analyzer.TYPE_STR)), Binding.Kind.ATTRIBUTE);
    }

    void buildFunctionType() {
        State t = this.BaseFunction.table;
        for (String s : this.list("func_doc", "__doc__", "func_name", "__name__", "__module__")) {
            t.insert(s, new Url(this.analyzer, DATAMODEL_URL), this.analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
        }
        t.insert("func_closure", new Url(this.analyzer, DATAMODEL_URL), this.newTuple(new Type[0]), Binding.Kind.ATTRIBUTE);
        t.insert("func_code", new Url(this.analyzer, DATAMODEL_URL), this.analyzer.TYPE_UNKNOWN, Binding.Kind.ATTRIBUTE);
        t.insert("func_defaults", new Url(this.analyzer, DATAMODEL_URL), this.newTuple(new Type[0]), Binding.Kind.ATTRIBUTE);
        t.insert("func_globals", new Url(this.analyzer, DATAMODEL_URL), new DictType(this.analyzer, this.analyzer.TYPE_STR, this.analyzer.TYPE_UNKNOWN), Binding.Kind.ATTRIBUTE);
        t.insert("func_dict", new Url(this.analyzer, DATAMODEL_URL), new DictType(this.analyzer, this.analyzer.TYPE_STR, this.analyzer.TYPE_UNKNOWN), Binding.Kind.ATTRIBUTE);
        for (String s : this.list("__func__", "im_func")) {
            t.insert(s, new Url(this.analyzer, DATAMODEL_URL), new FunType(this.analyzer), Binding.Kind.METHOD);
        }
    }

    void buildClassType() {
        State t = this.BaseClass.table;
        for (String s : this.list("__name__", "__doc__", "__module__")) {
            t.insert(s, new Url(this.analyzer, DATAMODEL_URL), this.analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
        }
        t.insert("__dict__", new Url(this.analyzer, DATAMODEL_URL), new DictType(this.analyzer, this.analyzer.TYPE_STR, this.analyzer.TYPE_UNKNOWN), Binding.Kind.ATTRIBUTE);
    }

    class ZlibModule
    extends NativeModule {
        public ZlibModule() {
            super("zlib");
        }

        @Override
        public void initBindings() {
            ClassType compress = Builtins.this.newClass("Compress", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String s : Builtins.this.list("compress", "flush")) {
                compress.table.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "zlib"), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.METHOD);
            }
            compress.table.insert("copy", Builtins.newLibUrl(Builtins.this.analyzer, "zlib"), compress, Binding.Kind.METHOD);
            this.addClass("Compress", this.liburl(), compress);
            ClassType decompress = Builtins.this.newClass("Decompress", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String s : Builtins.this.list("unused_data", "unconsumed_tail")) {
                decompress.table.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "zlib"), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
            }
            for (String s : Builtins.this.list("decompress", "flush")) {
                decompress.table.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "zlib"), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.METHOD);
            }
            decompress.table.insert("copy", Builtins.newLibUrl(Builtins.this.analyzer, "zlib"), decompress, Binding.Kind.METHOD);
            this.addClass("Decompress", this.liburl(), decompress);
            this.addFunction("adler32", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            this.addFunction("compress", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            this.addFunction("compressobj", this.liburl(), compress);
            this.addFunction("crc32", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            this.addFunction("decompress", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            this.addFunction("decompressobj", this.liburl(), decompress);
        }
    }

    class ZipimportModule
    extends NativeModule {
        public ZipimportModule() {
            super("zipimport");
        }

        @Override
        public void initBindings() {
            this.addClass("ZipImportError", this.liburl(), Builtins.this.newException("ZipImportError", this.table));
            ClassType zipimporter = Builtins.this.newClass("zipimporter", this.table, Builtins.this.objectType, new ClassType[0]);
            State t = zipimporter.table;
            t.insert("find_module", this.liburl(), zipimporter, Binding.Kind.METHOD);
            t.insert("get_code", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN, Binding.Kind.METHOD);
            t.insert("get_data", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN, Binding.Kind.METHOD);
            t.insert("get_source", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.METHOD);
            t.insert("is_package", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.METHOD);
            t.insert("load_module", this.liburl(), Builtins.this.newModule("<?>"), Binding.Kind.METHOD);
            t.insert("archive", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
            t.insert("prefix", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
            this.addClass("zipimporter", this.liburl(), zipimporter);
            this.addAttr("_zip_directory_cache", this.liburl(), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN));
        }
    }

    class UnicodedataModule
    extends NativeModule {
        public UnicodedataModule() {
            super("unicodedata");
        }

        @Override
        public void initBindings() {
            this.addNumFuncs("decimal", "digit", "numeric", "combining", "east_asian_width", "mirrored");
            this.addStrFuncs("lookup", "name", "category", "bidirectional", "decomposition", "normalize");
            this.addNumAttrs("unidata_version");
            this.addUnknownAttrs("ucd_3_2_0");
        }
    }

    class TimeModule
    extends NativeModule {
        public TimeModule() {
            super("time");
        }

        @Override
        public void initBindings() {
            String[] struct_time_attrs;
            InstanceType struct_time = Builtins.this.Time_struct_time = new InstanceType(Builtins.this.analyzer, Builtins.this.newClass("datetime", this.table, Builtins.this.objectType, new ClassType[0]));
            this.addAttr("struct_time", this.liburl(), struct_time);
            for (String s : struct_time_attrs = new String[]{"n_fields", "n_sequence_fields", "n_unnamed_fields", "tm_hour", "tm_isdst", "tm_mday", "tm_min", "tm_mon", "tm_wday", "tm_yday", "tm_year"}) {
                struct_time.table.insert(s, this.liburl("struct_time"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            }
            this.addNumAttrs("accept2dyear", "altzone", "daylight", "timezone");
            this.addAttr("tzname", this.liburl(), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR));
            this.addNoneFuncs("sleep", "tzset");
            this.addNumFuncs("clock", "mktime", "time", "tzname");
            this.addStrFuncs("asctime", "ctime", "strftime");
            this.addFunctions_beCareful(struct_time, "gmtime", "localtime", "strptime");
        }
    }

    class ThreadModule
    extends NativeModule {
        public ThreadModule() {
            super("thread");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            ClassType lock = Builtins.this.newClass("lock", this.table, Builtins.this.objectType, new ClassType[0]);
            lock.table.insert("acquire", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.METHOD);
            lock.table.insert("locked", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.METHOD);
            lock.table.insert("release", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_NONE, Binding.Kind.METHOD);
            this.addAttr("LockType", this.liburl(), Builtins.this.BaseType);
            this.addNoneFuncs("interrupt_main", "exit", "exit_thread");
            this.addNumFuncs("start_new", "start_new_thread", "get_ident", "stack_size");
            this.addFunction("allocate", this.liburl(), lock);
            this.addFunction("allocate_lock", this.liburl(), lock);
            this.addAttr("_local", this.liburl(), Builtins.this.BaseType);
        }
    }

    class TermiosModule
    extends NativeModule {
        public TermiosModule() {
            super("termios");
        }

        @Override
        public void initBindings() {
            this.addFunction("tcgetattr", this.liburl(), Builtins.this.newList());
            this.addUnknownFuncs("tcsetattr", "tcsendbreak", "tcdrain", "tcflush", "tcflow");
        }
    }

    class SyslogModule
    extends NativeModule {
        public SyslogModule() {
            super("syslog");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("syslog", "openlog", "closelog", "setlogmask");
            this.addNumAttrs("LOG_ALERT", "LOG_AUTH", "LOG_CONS", "LOG_CRIT", "LOG_CRON", "LOG_DAEMON", "LOG_DEBUG", "LOG_EMERG", "LOG_ERR", "LOG_INFO", "LOG_KERN", "LOG_LOCAL0", "LOG_LOCAL1", "LOG_LOCAL2", "LOG_LOCAL3", "LOG_LOCAL4", "LOG_LOCAL5", "LOG_LOCAL6", "LOG_LOCAL7", "LOG_LPR", "LOG_MAIL", "LOG_MASK", "LOG_NDELAY", "LOG_NEWS", "LOG_NOTICE", "LOG_NOWAIT", "LOG_PERROR", "LOG_PID", "LOG_SYSLOG", "LOG_UPTO", "LOG_USER", "LOG_UUCP", "LOG_WARNING");
        }
    }

    class SysModule
    extends NativeModule {
        public SysModule() {
            super("sys");
        }

        @Override
        public void initBindings() {
            this.addUnknownFuncs("_clear_type_cache", "call_tracing", "callstats", "_current_frames", "_getframe", "displayhook", "dont_write_bytecode", "exitfunc", "exc_clear", "exc_info", "excepthook", "exit", "last_traceback", "last_type", "last_value", "modules", "path_hooks", "path_importer_cache", "getprofile", "gettrace", "setcheckinterval", "setprofile", "setrecursionlimit", "settrace");
            this.addAttr("exc_type", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_NONE);
            this.addUnknownAttrs("__stderr__", "__stdin__", "__stdout__", "stderr", "stdin", "stdout", "version_info");
            this.addNumAttrs("api_version", "hexversion", "winver", "maxint", "maxsize", "maxunicode", "py3kwarning", "dllhandle");
            this.addStrAttrs("platform", "byteorder", "copyright", "prefix", "version", "exec_prefix", "executable");
            this.addNumFuncs("getrecursionlimit", "getwindowsversion", "getrefcount", "getsizeof", "getcheckinterval");
            this.addStrFuncs("getdefaultencoding", "getfilesystemencoding");
            for (String s : Builtins.this.list("argv", "builtin_module_names", "path", "meta_path", "subversion")) {
                this.addAttr(s, this.liburl(), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_STR));
            }
            for (String s : Builtins.this.list("flags", "warnoptions", "float_info")) {
                this.addAttr(s, this.liburl(), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            }
        }
    }

    class StructModule
    extends NativeModule {
        public StructModule() {
            super("struct");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrFuncs("pack");
            this.addUnknownFuncs("pack_into");
            this.addNumFuncs("calcsize");
            this.addFunction("unpack", this.liburl(), Builtins.this.newTuple(new Type[0]));
            this.addFunction("unpack_from", this.liburl(), Builtins.this.newTuple(new Type[0]));
            Builtins.this.BaseStruct = Builtins.this.newClass("Struct", this.table, Builtins.this.objectType, new ClassType[0]);
            this.addClass("Struct", this.liburl("struct-objects"), Builtins.this.BaseStruct);
            State t = Builtins.this.BaseStruct.table;
            t.insert("pack", this.liburl("struct-objects"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            t.insert("pack_into", this.liburl("struct-objects"), Builtins.this.newFunc(), Binding.Kind.METHOD);
            t.insert("unpack", this.liburl("struct-objects"), Builtins.this.newFunc(Builtins.this.newTuple(new Type[0])), Binding.Kind.METHOD);
            t.insert("unpack_from", this.liburl("struct-objects"), Builtins.this.newFunc(Builtins.this.newTuple(new Type[0])), Binding.Kind.METHOD);
            t.insert("format", this.liburl("struct-objects"), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
            t.insert("size", this.liburl("struct-objects"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
        }
    }

    class StropModule
    extends NativeModule {
        public StropModule() {
            super("strop");
        }

        @Override
        public void initBindings() {
            this.table.putAll(((Builtins)Builtins.this).analyzer.TYPE_STR.table);
        }
    }

    class SpwdModule
    extends NativeModule {
        public SpwdModule() {
            super("spwd");
        }

        @Override
        public void initBindings() {
            ClassType struct_spwd = Builtins.this.newClass("struct_spwd", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String s : Builtins.this.list("sp_nam", "sp_pwd", "sp_lstchg", "sp_min", "sp_max", "sp_warn", "sp_inact", "sp_expire", "sp_flag")) {
                struct_spwd.table.insert(s, this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_spwd", this.liburl(), struct_spwd);
            this.addFunction("getspnam", this.liburl(), struct_spwd);
            this.addFunction("getspall", this.liburl(), Builtins.this.newList(struct_spwd));
        }
    }

    class ShaModule
    extends NativeModule {
        public ShaModule() {
            super("sha");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            ClassType sha = Builtins.this.newClass("sha", this.table, Builtins.this.objectType, new ClassType[0]);
            sha.table.insert("update", this.liburl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            sha.table.insert("digest", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            sha.table.insert("hexdigest", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            sha.table.insert("copy", this.liburl(), Builtins.this.newFunc(sha), Binding.Kind.METHOD);
            this.addClass("sha", this.liburl(), sha);
            this.update("new", this.liburl(), Builtins.this.newFunc(sha), Binding.Kind.CONSTRUCTOR);
        }
    }

    class SignalModule
    extends NativeModule {
        public SignalModule() {
            super("signal");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("NSIG", "SIGABRT", "SIGALRM", "SIGBUS", "SIGCHLD", "SIGCLD", "SIGCONT", "SIGFPE", "SIGHUP", "SIGILL", "SIGINT", "SIGIO", "SIGIOT", "SIGKILL", "SIGPIPE", "SIGPOLL", "SIGPROF", "SIGPWR", "SIGQUIT", "SIGRTMAX", "SIGRTMIN", "SIGSEGV", "SIGSTOP", "SIGSYS", "SIGTERM", "SIGTRAP", "SIGTSTP", "SIGTTIN", "SIGTTOU", "SIGURG", "SIGUSR1", "SIGUSR2", "SIGVTALRM", "SIGWINCH", "SIGXCPU", "SIGXFSZ", "SIG_DFL", "SIG_IGN");
            this.addUnknownFuncs("default_int_handler", "getsignal", "set_wakeup_fd", "signal");
        }
    }

    class SelectModule
    extends NativeModule {
        public SelectModule() {
            super("select");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addFunction("select", this.liburl(), Builtins.this.newTuple(Builtins.this.newList(), Builtins.this.newList(), Builtins.this.newList()));
            String a = "edge-and-level-trigger-polling-epoll-objects";
            ClassType epoll = Builtins.this.newClass("epoll", this.table, Builtins.this.objectType, new ClassType[0]);
            epoll.table.insert("close", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.METHOD);
            epoll.table.insert("fileno", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            epoll.table.insert("fromfd", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(epoll), Binding.Kind.METHOD);
            for (String s : Builtins.this.list("register", "modify", "unregister", "poll")) {
                epoll.table.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(), Binding.Kind.METHOD);
            }
            this.addClass("epoll", this.liburl(a), epoll);
            for (String s : Builtins.this.list("EPOLLERR", "EPOLLET", "EPOLLHUP", "EPOLLIN", "EPOLLMSG", "EPOLLONESHOT", "EPOLLOUT", "EPOLLPRI", "EPOLLRDBAND", "EPOLLRDNORM", "EPOLLWRBAND", "EPOLLWRNORM")) {
                this.addAttr(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            a = "polling-objects";
            ClassType poll = Builtins.this.newClass("poll", this.table, Builtins.this.objectType, new ClassType[0]);
            poll.table.insert("register", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(), Binding.Kind.METHOD);
            poll.table.insert("modify", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(), Binding.Kind.METHOD);
            poll.table.insert("unregister", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(), Binding.Kind.METHOD);
            poll.table.insert("poll", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(Builtins.this.newList(Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT))), Binding.Kind.METHOD);
            this.addClass("poll", this.liburl(a), poll);
            for (String s : Builtins.this.list("POLLERR", "POLLHUP", "POLLIN", "POLLMSG", "POLLNVAL", "POLLOUT", "POLLPRI", "POLLRDBAND", "POLLRDNORM", "POLLWRBAND", "POLLWRNORM")) {
                this.addAttr(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            a = "kqueue-objects";
            ClassType kqueue = Builtins.this.newClass("kqueue", this.table, Builtins.this.objectType, new ClassType[0]);
            kqueue.table.insert("close", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.METHOD);
            kqueue.table.insert("fileno", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            kqueue.table.insert("fromfd", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(kqueue), Binding.Kind.METHOD);
            kqueue.table.insert("control", Builtins.newLibUrl(Builtins.this.analyzer, "select", a), Builtins.this.newFunc(Builtins.this.newList(Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT))), Binding.Kind.METHOD);
            this.addClass("kqueue", this.liburl(a), kqueue);
            a = "kevent-objects";
            ClassType kevent = Builtins.this.newClass("kevent", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String s : Builtins.this.list("ident", "filter", "flags", "fflags", "data", "udata")) {
                kevent.table.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "select", a), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN, Binding.Kind.ATTRIBUTE);
            }
            this.addClass("kevent", this.liburl(a), kevent);
        }
    }

    class ResourceModule
    extends NativeModule {
        public ResourceModule() {
            super("resource");
        }

        @Override
        public void initBindings() {
            String[] ru_fields;
            String[] constants;
            this.addFunction("getrlimit", this.liburl(), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addFunction("getrlimit", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
            for (String c : constants = new String[]{"RLIMIT_CORE", "RLIMIT_CPU", "RLIMIT_FSIZE", "RLIMIT_DATA", "RLIMIT_STACK", "RLIMIT_RSS", "RLIMIT_NPROC", "RLIMIT_NOFILE", "RLIMIT_OFILE", "RLIMIT_MEMLOCK", "RLIMIT_VMEM", "RLIMIT_AS"}) {
                this.addAttr(c, this.liburl("resource-limits"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            ClassType ru = Builtins.this.newClass("struct_rusage", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String ruf : ru_fields = new String[]{"ru_utime", "ru_stime", "ru_maxrss", "ru_ixrss", "ru_idrss", "ru_isrss", "ru_minflt", "ru_majflt", "ru_nswap", "ru_inblock", "ru_oublock", "ru_msgsnd", "ru_msgrcv", "ru_nsignals", "ru_nvcsw", "ru_nivcsw"}) {
                ru.table.insert(ruf, this.liburl("resource-usage"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            }
            this.addFunction("getrusage", this.liburl("resource-usage"), ru);
            this.addFunction("getpagesize", this.liburl("resource-usage"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            for (String s : Builtins.this.list("RUSAGE_SELF", "RUSAGE_CHILDREN", "RUSAGE_BOTH")) {
                this.addAttr(s, this.liburl("resource-usage"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
        }
    }

    class ReadlineModule
    extends NativeModule {
        public ReadlineModule() {
            super("readline");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("parse_and_bind", "insert_text", "read_init_file", "read_history_file", "write_history_file", "clear_history", "set_history_length", "remove_history_item", "replace_history_item", "redisplay", "set_startup_hook", "set_pre_input_hook", "set_completer", "set_completer_delims", "set_completion_display_matches_hook", "add_history");
            this.addNumFuncs("get_history_length", "get_current_history_length", "get_begidx", "get_endidx");
            this.addStrFuncs("get_line_buffer", "get_history_item");
            this.addUnknownFuncs("get_completion_type");
            this.addFunction("get_completer", this.liburl(), Builtins.this.newFunc());
            this.addFunction("get_completer_delims", this.liburl(), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_STR));
        }
    }

    class PyexpatModule
    extends NativeModule {
        public PyexpatModule() {
            super("pyexpat");
        }

        @Override
        public void initBindings() {
        }
    }

    class PwdModule
    extends NativeModule {
        public PwdModule() {
            super("pwd");
        }

        @Override
        public void initBindings() {
            ClassType struct_pwd = Builtins.this.newClass("struct_pwd", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String s : Builtins.this.list("pw_nam", "pw_passwd", "pw_uid", "pw_gid", "pw_gecos", "pw_dir", "pw_shell")) {
                struct_pwd.table.insert(s, this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            }
            this.addAttr("struct_pwd", this.liburl(), struct_pwd);
            this.addFunction("getpwuid", this.liburl(), struct_pwd);
            this.addFunction("getpwnam", this.liburl(), struct_pwd);
            this.addFunction("getpwall", this.liburl(), Builtins.this.newList(struct_pwd));
        }
    }

    class PosixModule
    extends NativeModule {
        public PosixModule() {
            super("posix");
        }

        @Override
        public void initBindings() {
            this.addAttr("environ", this.liburl(), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR));
        }
    }

    class ParserModule
    extends NativeModule {
        public ParserModule() {
            super("parser");
        }

        @Override
        public void initBindings() {
            ClassType st = Builtins.this.newClass("st", this.table, Builtins.this.objectType, new ClassType[0]);
            st.table.insert("compile", Builtins.newLibUrl(Builtins.this.analyzer, "parser", "st-objects"), Builtins.this.newFunc(), Binding.Kind.METHOD);
            st.table.insert("isexpr", Builtins.newLibUrl(Builtins.this.analyzer, "parser", "st-objects"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            st.table.insert("issuite", Builtins.newLibUrl(Builtins.this.analyzer, "parser", "st-objects"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            st.table.insert("tolist", Builtins.newLibUrl(Builtins.this.analyzer, "parser", "st-objects"), Builtins.this.newFunc(Builtins.this.newList()), Binding.Kind.METHOD);
            st.table.insert("totuple", Builtins.newLibUrl(Builtins.this.analyzer, "parser", "st-objects"), Builtins.this.newFunc(Builtins.this.newTuple(new Type[0])), Binding.Kind.METHOD);
            this.addAttr("STType", this.liburl("st-objects"), Builtins.this.BaseType);
            for (String s : Builtins.this.list("expr", "suite", "sequence2st", "tuple2st")) {
                this.addFunction(s, this.liburl("creating-st-objects"), st);
            }
            this.addFunction("st2list", this.liburl("converting-st-objects"), Builtins.this.newList());
            this.addFunction("st2tuple", this.liburl("converting-st-objects"), Builtins.this.newTuple(new Type[0]));
            this.addFunction("compilest", this.liburl("converting-st-objects"), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
            this.addFunction("isexpr", this.liburl("queries-on-st-objects"), ((Builtins)Builtins.this).analyzer.TYPE_BOOL);
            this.addFunction("issuite", this.liburl("queries-on-st-objects"), ((Builtins)Builtins.this).analyzer.TYPE_BOOL);
            this.addClass("ParserError", this.liburl("exceptions-and-error-handling"), Builtins.this.newException("ParserError", this.table));
        }
    }

    class OperatorModule
    extends NativeModule {
        public OperatorModule() {
            super("operator");
        }

        @Override
        public void initBindings() {
            this.addNumFuncs("__abs__", "__add__", "__and__", "__concat__", "__contains__", "__div__", "__doc__", "__eq__", "__floordiv__", "__ge__", "__getitem__", "__getslice__", "__gt__", "__iadd__", "__iand__", "__iconcat__", "__idiv__", "__ifloordiv__", "__ilshift__", "__imod__", "__imul__", "__index__", "__inv__", "__invert__", "__ior__", "__ipow__", "__irepeat__", "__irshift__", "__isub__", "__itruediv__", "__ixor__", "__le__", "__lshift__", "__lt__", "__mod__", "__mul__", "__name__", "__ne__", "__neg__", "__not__", "__or__", "__package__", "__pos__", "__pow__", "__repeat__", "__rshift__", "__setitem__", "__setslice__", "__sub__", "__truediv__", "__xor__", "abs", "add", "and_", "concat", "contains", "countOf", "div", "eq", "floordiv", "ge", "getitem", "getslice", "gt", "iadd", "iand", "iconcat", "idiv", "ifloordiv", "ilshift", "imod", "imul", "index", "indexOf", "inv", "invert", "ior", "ipow", "irepeat", "irshift", "isCallable", "isMappingType", "isNumberType", "isSequenceType", "is_", "is_not", "isub", "itruediv", "ixor", "le", "lshift", "lt", "mod", "mul", "ne", "neg", "not_", "or_", "pos", "pow", "repeat", "rshift", "sequenceIncludes", "setitem", "setslice", "sub", "truediv", "truth", "xor");
            this.addUnknownFuncs("attrgetter", "itemgetter", "methodcaller");
            this.addNoneFuncs("__delitem__", "__delslice__", "delitem", "delclice");
        }
    }

    class OsModule
    extends NativeModule {
        public OsModule() {
            super("os");
        }

        @Override
        public void initBindings() {
            this.addAttr("name", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.initProcBindings();
            this.initProcMgmtBindings();
            this.initFileBindings();
            this.initFileAndDirBindings();
            this.initMiscSystemInfo();
            this.initOsPathModule();
            this.addAttr("errno", this.liburl(), Builtins.this.newModule("errno"));
            this.addFunction("urandom", this.liburl("miscellaneous-functions"), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            this.addAttr("NGROUPS_MAX", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            for (String s : Builtins.this.list("_Environ", "_copy_reg", "_execvpe", "_exists", "_get_exports_list", "_make_stat_result", "_make_statvfs_result", "_pickle_stat_result", "_pickle_statvfs_result", "_spawnvef")) {
                this.addFunction(s, this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
            }
        }

        private void initProcBindings() {
            String a = "process-parameters";
            this.addAttr("environ", this.liburl(a), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR));
            for (String s : Builtins.this.list("chdir", "fchdir", "putenv", "setegid", "seteuid", "setgid", "setgroups", "setpgrp", "setpgid", "setreuid", "setregid", "setuid", "unsetenv")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_NONE);
            }
            for (String s : Builtins.this.list("getegid", "getgid", "getpgid", "getpgrp", "getppid", "getuid", "getsid", "umask")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String s : Builtins.this.list("getcwd", "ctermid", "getlogin", "getenv", "strerror")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            }
            this.addFunction("getgroups", this.liburl(a), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_STR));
            this.addFunction("uname", this.liburl(a), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR));
        }

        private void initProcMgmtBindings() {
            String a = "process-management";
            for (String s : Builtins.this.list("EX_CANTCREAT", "EX_CONFIG", "EX_DATAERR", "EX_IOERR", "EX_NOHOST", "EX_NOINPUT", "EX_NOPERM", "EX_NOUSER", "EX_OK", "EX_OSERR", "EX_OSFILE", "EX_PROTOCOL", "EX_SOFTWARE", "EX_TEMPFAIL", "EX_UNAVAILABLE", "EX_USAGE", "P_NOWAIT", "P_NOWAITO", "P_WAIT", "P_DETACH", "P_OVERLAY", "WCONTINUED", "WCOREDUMP", "WEXITSTATUS", "WIFCONTINUED", "WIFEXITED", "WIFSIGNALED", "WIFSTOPPED", "WNOHANG", "WSTOPSIG", "WTERMSIG", "WUNTRACED")) {
                this.addAttr(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String s : Builtins.this.list("abort", "execl", "execle", "execlp", "execlpe", "execv", "execve", "execvp", "execvpe", "_exit", "kill", "killpg", "plock", "startfile")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_NONE);
            }
            for (String s : Builtins.this.list("nice", "spawnl", "spawnle", "spawnlp", "spawnlpe", "spawnv", "spawnve", "spawnvp", "spawnvpe", "system")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            this.addFunction("fork", this.liburl(a), Builtins.this.newUnion(Builtins.this.BaseFileInst, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addFunction("times", this.liburl(a), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            for (String s : Builtins.this.list("forkpty", "wait", "waitpid")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            }
            for (String s : Builtins.this.list("wait3", "wait4")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            }
        }

        private void initFileBindings() {
            String a = "file-object-creation";
            for (String s : Builtins.this.list("fdopen", "popen", "tmpfile")) {
                this.addFunction(s, this.liburl(a), Builtins.this.BaseFileInst);
            }
            this.addFunction("popen2", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseFileInst, Builtins.this.BaseFileInst));
            this.addFunction("popen3", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseFileInst, Builtins.this.BaseFileInst, Builtins.this.BaseFileInst));
            this.addFunction("popen4", this.liburl(a), Builtins.this.newTuple(Builtins.this.BaseFileInst, Builtins.this.BaseFileInst));
            a = "file-descriptor-operations";
            this.addFunction("open", this.liburl(a), Builtins.this.BaseFileInst);
            for (String s : Builtins.this.list("close", "closerange", "dup2", "fchmod", "fchown", "fdatasync", "fsync", "ftruncate", "lseek", "tcsetpgrp", "write")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_NONE);
            }
            for (String s : Builtins.this.list("dup2", "fpathconf", "fstat", "fstatvfs", "isatty", "tcgetpgrp")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String s : Builtins.this.list("read", "ttyname")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            }
            for (String s : Builtins.this.list("openpty", "pipe", "fstat", "fstatvfs", "isatty")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            }
            for (String s : Builtins.this.list("O_APPEND", "O_CREAT", "O_DIRECT", "O_DIRECTORY", "O_DSYNC", "O_EXCL", "O_LARGEFILE", "O_NDELAY", "O_NOCTTY", "O_NOFOLLOW", "O_NONBLOCK", "O_RDONLY", "O_RDWR", "O_RSYNC", "O_SYNC", "O_TRUNC", "O_WRONLY", "SEEK_CUR", "SEEK_END", "SEEK_SET")) {
                this.addAttr(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
        }

        private void initFileAndDirBindings() {
            String a = "files-and-directories";
            for (String s : Builtins.this.list("F_OK", "R_OK", "W_OK", "X_OK")) {
                this.addAttr(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String s : Builtins.this.list("chflags", "chroot", "chmod", "chown", "lchflags", "lchmod", "lchown", "link", "mknod", "mkdir", "mkdirs", "remove", "removedirs", "rename", "renames", "rmdir", "symlink", "unlink", "utime")) {
                this.addAttr(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_NONE);
            }
            for (String s : Builtins.this.list("access", "lstat", "major", "minor", "makedev", "pathconf", "stat_float_times")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String s : Builtins.this.list("getcwdu", "readlink", "tempnam", "tmpnam")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            }
            for (String s : Builtins.this.list("listdir")) {
                this.addFunction(s, this.liburl(a), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_STR));
            }
            this.addFunction("mkfifo", this.liburl(a), Builtins.this.BaseFileInst);
            this.addFunction("stat", this.liburl(a), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addFunction("statvfs", this.liburl(a), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addAttr("pathconf_names", this.liburl(a), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addAttr("TMP_MAX", this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            this.addFunction("walk", this.liburl(a), Builtins.this.newList(Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR)));
        }

        private void initMiscSystemInfo() {
            String a = "miscellaneous-system-information";
            this.addAttr("confstr_names", this.liburl(a), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addAttr("sysconf_names", this.liburl(a), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            for (String s : Builtins.this.list("curdir", "pardir", "sep", "altsep", "extsep", "pathsep", "defpath", "linesep", "devnull")) {
                this.addAttr(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            }
            for (String s : Builtins.this.list("getloadavg", "sysconf")) {
                this.addFunction(s, this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            this.addFunction("confstr", this.liburl(a), ((Builtins)Builtins.this).analyzer.TYPE_STR);
        }

        private void initOsPathModule() {
            String[] str_attrs;
            String[] num_funcs;
            String[] str_funcs;
            ModuleType m = Builtins.this.newModule("path");
            State ospath = m.table;
            ospath.setPath("os.path");
            this.update("path", Builtins.newLibUrl(Builtins.this.analyzer, "os.path.html#module-os.path"), m, Binding.Kind.MODULE);
            for (String s : str_funcs = new String[]{"_resolve_link", "abspath", "basename", "commonprefix", "dirname", "expanduser", "expandvars", "join", "normcase", "normpath", "realpath", "relpath"}) {
                ospath.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "os.path", s), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.FUNCTION);
            }
            for (String s : num_funcs = new String[]{"exists", "lexists", "getatime", "getctime", "getmtime", "getsize", "isabs", "isdir", "isfile", "islink", "ismount", "samefile", "sameopenfile", "samestat", "supports_unicode_filenames"}) {
                ospath.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "os.path", s), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.FUNCTION);
            }
            for (String s : Builtins.this.list("split", "splitdrive", "splitext", "splitunc")) {
                ospath.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "os.path", s), Builtins.this.newFunc(Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR)), Binding.Kind.FUNCTION);
            }
            ospath.insert("walk", Builtins.newLibUrl(Builtins.this.analyzer, "os.path"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.FUNCTION);
            for (String s : str_attrs = new String[]{"altsep", "curdir", "devnull", "defpath", "pardir", "pathsep", "sep"}) {
                ospath.insert(s, Builtins.newLibUrl(Builtins.this.analyzer, "os.path", s), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
            }
            ospath.insert("os", this.liburl(), this.module, Binding.Kind.ATTRIBUTE);
            ospath.insert("stat", Builtins.newLibUrl(Builtins.this.analyzer, "stat"), Builtins.this.newModule("<stat-fixme>"), Binding.Kind.ATTRIBUTE);
            ospath.insert("_varprog", Builtins.newLibUrl(Builtins.this.analyzer, "os.path"), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN, Binding.Kind.ATTRIBUTE);
        }
    }

    class NisModule
    extends NativeModule {
        public NisModule() {
            super("nis");
        }

        @Override
        public void initBindings() {
            this.addStrFuncs("match", "cat", "get_default_domain");
            this.addFunction("maps", this.liburl(), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_STR));
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
        }
    }

    class MmapModule
    extends NativeModule {
        public MmapModule() {
            super("mmap");
        }

        @Override
        public void initBindings() {
            ClassType mmap = Builtins.this.newClass("mmap", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String s : Builtins.this.list("ACCESS_COPY", "ACCESS_READ", "ACCESS_WRITE", "ALLOCATIONGRANULARITY", "MAP_ANON", "MAP_ANONYMOUS", "MAP_DENYWRITE", "MAP_EXECUTABLE", "MAP_PRIVATE", "MAP_SHARED", "PAGESIZE", "PROT_EXEC", "PROT_READ", "PROT_WRITE")) {
                mmap.table.insert(s, this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            }
            for (String fstr : Builtins.this.list("read", "read_byte", "readline")) {
                mmap.table.insert(fstr, this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            }
            for (String fnum : Builtins.this.list("find", "rfind", "tell")) {
                mmap.table.insert(fnum, this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            }
            for (String fnone : Builtins.this.list("close", "flush", "move", "resize", "seek", "write", "write_byte")) {
                mmap.table.insert(fnone, this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.METHOD);
            }
            this.addClass("mmap", this.liburl(), mmap);
        }
    }

    class Md5Module
    extends NativeModule {
        public Md5Module() {
            super("md5");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("blocksize", "digest_size");
            ClassType md5 = Builtins.this.newClass("md5", this.table, Builtins.this.objectType, new ClassType[0]);
            md5.table.insert("update", this.liburl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            md5.table.insert("digest", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            md5.table.insert("hexdigest", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            md5.table.insert("copy", this.liburl(), Builtins.this.newFunc(md5), Binding.Kind.METHOD);
            this.update("new", this.liburl(), Builtins.this.newFunc(md5), Binding.Kind.CONSTRUCTOR);
            this.update("md5", this.liburl(), Builtins.this.newFunc(md5), Binding.Kind.CONSTRUCTOR);
        }
    }

    class MathModule
    extends NativeModule {
        public MathModule() {
            super("math");
        }

        @Override
        public void initBindings() {
            this.addNumFuncs("acos", "acosh", "asin", "asinh", "atan", "atan2", "atanh", "ceil", "copysign", "cos", "cosh", "degrees", "exp", "fabs", "factorial", "floor", "fmod", "frexp", "fsum", "hypot", "isinf", "isnan", "ldexp", "log", "log10", "log1p", "modf", "pow", "radians", "sin", "sinh", "sqrt", "tan", "tanh", "trunc");
            this.addNumAttrs("pi", "e");
        }
    }

    class MarshalModule
    extends NativeModule {
        public MarshalModule() {
            super("marshal");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("version");
            this.addStrFuncs("dumps");
            this.addUnknownFuncs("dump", "load", "loads");
        }
    }

    class ItertoolsModule
    extends NativeModule {
        public ItertoolsModule() {
            super("itertools");
        }

        @Override
        public void initBindings() {
            ClassType iterator = Builtins.this.newClass("iterator", this.table, Builtins.this.objectType, new ClassType[0]);
            iterator.table.insert("from_iterable", this.liburl("itertool-functions"), Builtins.this.newFunc(iterator), Binding.Kind.METHOD);
            iterator.table.insert("next", this.liburl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            for (String s : Builtins.this.list("chain", "combinations", "count", "cycle", "dropwhile", "groupby", "ifilter", "ifilterfalse", "imap", "islice", "izip", "izip_longest", "permutations", "product", "repeat", "starmap", "takewhile", "tee")) {
                this.addClass(s, this.liburl("itertool-functions"), iterator);
            }
        }
    }

    class ImpModule
    extends NativeModule {
        public ImpModule() {
            super("imp");
        }

        @Override
        public void initBindings() {
            String[] module_methods;
            this.addStrFuncs("get_magic");
            this.addFunction("get_suffixes", this.liburl(), Builtins.this.newList(Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_INT)));
            this.addFunction("find_module", this.liburl(), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            for (String mm : module_methods = new String[]{"load_module", "new_module", "init_builtin", "init_frozen", "load_compiled", "load_dynamic", "load_source"}) {
                this.addFunction(mm, this.liburl(), Builtins.this.newModule("<?>"));
            }
            this.addUnknownFuncs("acquire_lock", "release_lock");
            this.addNumAttrs("PY_SOURCE", "PY_COMPILED", "C_EXTENSION", "PKG_DIRECTORY", "C_BUILTIN", "PY_FROZEN", "SEARCH_ERROR");
            this.addNumFuncs("lock_held", "is_builtin", "is_frozen");
            ClassType impNullImporter = Builtins.this.newClass("NullImporter", this.table, Builtins.this.objectType, new ClassType[0]);
            impNullImporter.table.insert("find_module", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.FUNCTION);
            this.addClass("NullImporter", this.liburl(), impNullImporter);
        }
    }

    class GrpModule
    extends NativeModule {
        public GrpModule() {
            super("grp");
        }

        @Override
        public void initBindings() {
            Builtins.this.get("struct");
            ClassType struct_group = Builtins.this.newClass("struct_group", this.table, Builtins.this.BaseStruct, new ClassType[0]);
            struct_group.table.insert("gr_name", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
            struct_group.table.insert("gr_passwd", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_STR, Binding.Kind.ATTRIBUTE);
            struct_group.table.insert("gr_gid", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            struct_group.table.insert("gr_mem", this.liburl(), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.ATTRIBUTE);
            this.addClass("struct_group", this.liburl(), struct_group);
            for (String s : Builtins.this.list("getgrgid", "getgrnam")) {
                this.addFunction(s, this.liburl(), struct_group);
            }
            this.addFunction("getgrall", this.liburl(), new ListType(Builtins.this.analyzer, struct_group));
        }
    }

    class GdbmModule
    extends NativeModule {
        public GdbmModule() {
            super("gdbm");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            ClassType gdbm = new ClassType(Builtins.this.analyzer, "gdbm", this.table, Builtins.this.BaseDict);
            gdbm.table.insert("firstkey", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            gdbm.table.insert("nextkey", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            gdbm.table.insert("reorganize", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.METHOD);
            gdbm.table.insert("sync", this.liburl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.METHOD);
            this.addFunction("open", this.liburl(), gdbm);
        }
    }

    class GcModule
    extends NativeModule {
        public GcModule() {
            super("gc");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("enable", "disable", "set_debug", "set_threshold");
            this.addNumFuncs("isenabled", "collect", "get_debug", "get_count", "get_threshold");
            for (String s : Builtins.this.list("get_objects", "get_referrers", "get_referents")) {
                this.addFunction(s, this.liburl(), Builtins.this.newList());
            }
            this.addAttr("garbage", this.liburl(), Builtins.this.newList());
            this.addNumAttrs("DEBUG_STATS", "DEBUG_COLLECTABLE", "DEBUG_UNCOLLECTABLE", "DEBUG_INSTANCES", "DEBUG_OBJECTS", "DEBUG_SAVEALL", "DEBUG_LEAK");
        }
    }

    class FpectlModule
    extends NativeModule {
        public FpectlModule() {
            super("fpectl");
        }

        @Override
        public void initBindings() {
            this.addNoneFuncs("turnon_sigfpe", "turnoff_sigfpe");
            this.addClass("FloatingPointError", this.liburl(), Builtins.this.newException("FloatingPointError", this.table));
        }
    }

    class FcntlModule
    extends NativeModule {
        public FcntlModule() {
            super("fcntl");
        }

        @Override
        public void initBindings() {
            for (String s : Builtins.this.list("fcntl", "ioctl")) {
                this.addFunction(s, this.liburl(), Builtins.this.newUnion(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_STR));
            }
            this.addNumFuncs("flock");
            this.addUnknownFuncs("lockf");
            this.addNumAttrs("DN_ACCESS", "DN_ATTRIB", "DN_CREATE", "DN_DELETE", "DN_MODIFY", "DN_MULTISHOT", "DN_RENAME", "FASYNC", "FD_CLOEXEC", "F_DUPFD", "F_EXLCK", "F_GETFD", "F_GETFL", "F_GETLEASE", "F_GETLK", "F_GETLK64", "F_GETOWN", "F_GETSIG", "F_NOTIFY", "F_RDLCK", "F_SETFD", "F_SETFL", "F_SETLEASE", "F_SETLK", "F_SETLK64", "F_SETLKW", "F_SETLKW64", "F_SETOWN", "F_SETSIG", "F_SHLCK", "F_UNLCK", "F_WRLCK", "I_ATMARK", "I_CANPUT", "I_CKBAND", "I_FDINSERT", "I_FIND", "I_FLUSH", "I_FLUSHBAND", "I_GETBAND", "I_GETCLTIME", "I_GETSIG", "I_GRDOPT", "I_GWROPT", "I_LINK", "I_LIST", "I_LOOK", "I_NREAD", "I_PEEK", "I_PLINK", "I_POP", "I_PUNLINK", "I_PUSH", "I_RECVFD", "I_SENDFD", "I_SETCLTIME", "I_SETSIG", "I_SRDOPT", "I_STR", "I_SWROPT", "I_UNLINK", "LOCK_EX", "LOCK_MAND", "LOCK_NB", "LOCK_READ", "LOCK_RW", "LOCK_SH", "LOCK_UN", "LOCK_WRITE");
        }
    }

    class ExceptionsModule
    extends NativeModule {
        public ExceptionsModule() {
            super("exceptions");
        }

        @Override
        public void initBindings() {
            ModuleType builtins = Builtins.this.get("__builtin__");
            for (String string : Builtins.this.builtin_exception_types) {
            }
        }
    }

    class ErrnoModule
    extends NativeModule {
        public ErrnoModule() {
            super("errno");
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("E2BIG", "EACCES", "EADDRINUSE", "EADDRNOTAVAIL", "EAFNOSUPPORT", "EAGAIN", "EALREADY", "EBADF", "EBUSY", "ECHILD", "ECONNABORTED", "ECONNREFUSED", "ECONNRESET", "EDEADLK", "EDEADLOCK", "EDESTADDRREQ", "EDOM", "EDQUOT", "EEXIST", "EFAULT", "EFBIG", "EHOSTDOWN", "EHOSTUNREACH", "EILSEQ", "EINPROGRESS", "EINTR", "EINVAL", "EIO", "EISCONN", "EISDIR", "ELOOP", "EMFILE", "EMLINK", "EMSGSIZE", "ENAMETOOLONG", "ENETDOWN", "ENETRESET", "ENETUNREACH", "ENFILE", "ENOBUFS", "ENODEV", "ENOENT", "ENOEXEC", "ENOLCK", "ENOMEM", "ENOPROTOOPT", "ENOSPC", "ENOSYS", "ENOTCONN", "ENOTDIR", "ENOTEMPTY", "ENOTSOCK", "ENOTTY", "ENXIO", "EOPNOTSUPP", "EPERM", "EPFNOSUPPORT", "EPIPE", "EPROTONOSUPPORT", "EPROTOTYPE", "ERANGE", "EREMOTE", "EROFS", "ESHUTDOWN", "ESOCKTNOSUPPORT", "ESPIPE", "ESRCH", "ESTALE", "ETIMEDOUT", "ETOOMANYREFS", "EUSERS", "EWOULDBLOCK", "EXDEV", "WSABASEERR", "WSAEACCES", "WSAEADDRINUSE", "WSAEADDRNOTAVAIL", "WSAEAFNOSUPPORT", "WSAEALREADY", "WSAEBADF", "WSAECONNABORTED", "WSAECONNREFUSED", "WSAECONNRESET", "WSAEDESTADDRREQ", "WSAEDISCON", "WSAEDQUOT", "WSAEFAULT", "WSAEHOSTDOWN", "WSAEHOSTUNREACH", "WSAEINPROGRESS", "WSAEINTR", "WSAEINVAL", "WSAEISCONN", "WSAELOOP", "WSAEMFILE", "WSAEMSGSIZE", "WSAENAMETOOLONG", "WSAENETDOWN", "WSAENETRESET", "WSAENETUNREACH", "WSAENOBUFS", "WSAENOPROTOOPT", "WSAENOTCONN", "WSAENOTEMPTY", "WSAENOTSOCK", "WSAEOPNOTSUPP", "WSAEPFNOSUPPORT", "WSAEPROCLIM", "WSAEPROTONOSUPPORT", "WSAEPROTOTYPE", "WSAEREMOTE", "WSAESHUTDOWN", "WSAESOCKTNOSUPPORT", "WSAESTALE", "WSAETIMEDOUT", "WSAETOOMANYREFS", "WSAEUSERS", "WSAEWOULDBLOCK", "WSANOTINITIALISED", "WSASYSNOTREADY", "WSAVERNOTSUPPORTED");
            this.addAttr("errorcode", this.liburl("errorcode"), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_STR));
        }
    }

    class DbmModule
    extends NativeModule {
        public DbmModule() {
            super("dbm");
        }

        @Override
        public void initBindings() {
            ClassType dbm = new ClassType(Builtins.this.analyzer, "dbm", this.table, Builtins.this.BaseDict);
            this.addClass("dbm", this.liburl(), dbm);
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrAttrs("library");
            this.addFunction("open", this.liburl(), dbm);
        }
    }

    class DatetimeModule
    extends NativeModule {
        public DatetimeModule() {
            super("datetime");
        }

        @NotNull
        private Url dtUrl(String anchor) {
            return this.liburl("datetime." + anchor);
        }

        @Override
        public void initBindings() {
            this.addNumAttrs("MINYEAR", "MAXYEAR");
            ClassType timedelta = Builtins.this.Datetime_timedelta = Builtins.this.newClass("timedelta", this.table, Builtins.this.objectType, new ClassType[0]);
            this.addClass("timedelta", this.dtUrl("timedelta"), timedelta);
            State tdtable = Builtins.this.Datetime_timedelta.table;
            tdtable.insert("min", this.dtUrl("timedelta"), timedelta, Binding.Kind.ATTRIBUTE);
            tdtable.insert("max", this.dtUrl("timedelta"), timedelta, Binding.Kind.ATTRIBUTE);
            tdtable.insert("resolution", this.dtUrl("timedelta"), timedelta, Binding.Kind.ATTRIBUTE);
            tdtable.insert("days", this.dtUrl("timedelta"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            tdtable.insert("seconds", this.dtUrl("timedelta"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            tdtable.insert("microseconds", this.dtUrl("timedelta"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            ClassType tzinfo = Builtins.this.Datetime_tzinfo = Builtins.this.newClass("tzinfo", this.table, Builtins.this.objectType, new ClassType[0]);
            this.addClass("tzinfo", this.dtUrl("tzinfo"), tzinfo);
            State tztable = Builtins.this.Datetime_tzinfo.table;
            tztable.insert("utcoffset", this.dtUrl("tzinfo"), Builtins.this.newFunc(timedelta), Binding.Kind.METHOD);
            tztable.insert("dst", this.dtUrl("tzinfo"), Builtins.this.newFunc(timedelta), Binding.Kind.METHOD);
            tztable.insert("tzname", this.dtUrl("tzinfo"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            tztable.insert("fromutc", this.dtUrl("tzinfo"), Builtins.this.newFunc(tzinfo), Binding.Kind.METHOD);
            ClassType date = Builtins.this.Datetime_date = Builtins.this.newClass("date", this.table, Builtins.this.objectType, new ClassType[0]);
            this.addClass("date", this.dtUrl("date"), date);
            State dtable = Builtins.this.Datetime_date.table;
            dtable.insert("min", this.dtUrl("date"), date, Binding.Kind.ATTRIBUTE);
            dtable.insert("max", this.dtUrl("date"), date, Binding.Kind.ATTRIBUTE);
            dtable.insert("resolution", this.dtUrl("date"), timedelta, Binding.Kind.ATTRIBUTE);
            dtable.insert("today", this.dtUrl("date"), Builtins.this.newFunc(date), Binding.Kind.METHOD);
            dtable.insert("fromtimestamp", this.dtUrl("date"), Builtins.this.newFunc(date), Binding.Kind.METHOD);
            dtable.insert("fromordinal", this.dtUrl("date"), Builtins.this.newFunc(date), Binding.Kind.METHOD);
            dtable.insert("year", this.dtUrl("date"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            dtable.insert("month", this.dtUrl("date"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            dtable.insert("day", this.dtUrl("date"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            dtable.insert("replace", this.dtUrl("date"), Builtins.this.newFunc(date), Binding.Kind.METHOD);
            dtable.insert("timetuple", this.dtUrl("date"), Builtins.this.newFunc(Builtins.this.Time_struct_time), Binding.Kind.METHOD);
            for (String n : Builtins.this.list("toordinal", "weekday", "isoweekday")) {
                dtable.insert(n, this.dtUrl("date"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            }
            for (String r : Builtins.this.list("ctime", "strftime", "isoformat")) {
                dtable.insert(r, this.dtUrl("date"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            }
            dtable.insert("isocalendar", this.dtUrl("date"), Builtins.this.newFunc(Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT)), Binding.Kind.METHOD);
            ClassType time = Builtins.this.Datetime_time = Builtins.this.newClass("time", this.table, Builtins.this.objectType, new ClassType[0]);
            this.addClass("time", this.dtUrl("time"), time);
            State ttable = Builtins.this.Datetime_time.table;
            ttable.insert("min", this.dtUrl("time"), time, Binding.Kind.ATTRIBUTE);
            ttable.insert("max", this.dtUrl("time"), time, Binding.Kind.ATTRIBUTE);
            ttable.insert("resolution", this.dtUrl("time"), timedelta, Binding.Kind.ATTRIBUTE);
            ttable.insert("hour", this.dtUrl("time"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            ttable.insert("minute", this.dtUrl("time"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            ttable.insert("second", this.dtUrl("time"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            ttable.insert("microsecond", this.dtUrl("time"), ((Builtins)Builtins.this).analyzer.TYPE_INT, Binding.Kind.ATTRIBUTE);
            ttable.insert("tzinfo", this.dtUrl("time"), tzinfo, Binding.Kind.ATTRIBUTE);
            ttable.insert("replace", this.dtUrl("time"), Builtins.this.newFunc(time), Binding.Kind.METHOD);
            for (String l : Builtins.this.list("isoformat", "strftime", "tzname")) {
                ttable.insert(l, this.dtUrl("time"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            }
            for (String f : Builtins.this.list("utcoffset", "dst")) {
                ttable.insert(f, this.dtUrl("time"), Builtins.this.newFunc(timedelta), Binding.Kind.METHOD);
            }
            ClassType datetime = Builtins.this.Datetime_datetime = Builtins.this.newClass("datetime", this.table, date, time);
            this.addClass("datetime", this.dtUrl("datetime"), datetime);
            State dttable = Builtins.this.Datetime_datetime.table;
            for (String c : Builtins.this.list("combine", "fromordinal", "fromtimestamp", "now", "strptime", "today", "utcfromtimestamp", "utcnow")) {
                dttable.insert(c, this.dtUrl("datetime"), Builtins.this.newFunc(datetime), Binding.Kind.METHOD);
            }
            dttable.insert("min", this.dtUrl("datetime"), datetime, Binding.Kind.ATTRIBUTE);
            dttable.insert("max", this.dtUrl("datetime"), datetime, Binding.Kind.ATTRIBUTE);
            dttable.insert("resolution", this.dtUrl("datetime"), timedelta, Binding.Kind.ATTRIBUTE);
            dttable.insert("date", this.dtUrl("datetime"), Builtins.this.newFunc(date), Binding.Kind.METHOD);
            for (String x : Builtins.this.list("time", "timetz")) {
                dttable.insert(x, this.dtUrl("datetime"), Builtins.this.newFunc(time), Binding.Kind.METHOD);
            }
            for (String y : Builtins.this.list("replace", "astimezone")) {
                dttable.insert(y, this.dtUrl("datetime"), Builtins.this.newFunc(datetime), Binding.Kind.METHOD);
            }
            dttable.insert("utctimetuple", this.dtUrl("datetime"), Builtins.this.newFunc(Builtins.this.Time_struct_time), Binding.Kind.METHOD);
        }
    }

    class CryptModule
    extends NativeModule {
        public CryptModule() {
            super("crypt");
        }

        @Override
        public void initBindings() {
            this.addStrFuncs("crypt");
        }
    }

    class CTypesModule
    extends NativeModule {
        public CTypesModule() {
            super("ctypes");
        }

        @Override
        public void initBindings() {
            String[] ctypes_attrs;
            for (String attr : ctypes_attrs = new String[]{"ARRAY", "ArgumentError", "Array", "BigEndianStructure", "CDLL", "CFUNCTYPE", "DEFAULT_MODE", "DllCanUnloadNow", "DllGetClassObject", "FormatError", "GetLastError", "HRESULT", "LibraryLoader", "LittleEndianStructure", "OleDLL", "POINTER", "PYFUNCTYPE", "PyDLL", "RTLD_GLOBAL", "RTLD_LOCAL", "SetPointerType", "Structure", "Union", "WINFUNCTYPE", "WinDLL", "WinError", "_CFuncPtr", "_FUNCFLAG_CDECL", "_FUNCFLAG_PYTHONAPI", "_FUNCFLAG_STDCALL", "_FUNCFLAG_USE_ERRNO", "_FUNCFLAG_USE_LASTERROR", "_Pointer", "_SimpleCData", "_c_functype_cache", "_calcsize", "_cast", "_cast_addr", "_check_HRESULT", "_check_size", "_ctypes_version", "_dlopen", "_endian", "_memmove_addr", "_memset_addr", "_os", "_pointer_type_cache", "_string_at", "_string_at_addr", "_sys", "_win_functype_cache", "_wstring_at", "_wstring_at_addr", "addressof", "alignment", "byref", "c_bool", "c_buffer", "c_byte", "c_char", "c_char_p", "c_double", "c_float", "c_int", "c_int16", "c_int32", "c_int64", "c_int8", "c_long", "c_longdouble", "c_longlong", "c_short", "c_size_t", "c_ubyte", "c_uint", "c_uint16", "c_uint32", "c_uint64", "c_uint8", "c_ulong", "c_ulonglong", "c_ushort", "c_void_p", "c_voidp", "c_wchar", "c_wchar_p", "cast", "cdll", "create_string_buffer", "create_unicode_buffer", "get_errno", "get_last_error", "memmove", "memset", "oledll", "pointer", "py_object", "pydll", "pythonapi", "resize", "set_conversion_mode", "set_errno", "set_last_error", "sizeof", "string_at", "windll", "wstring_at"}) {
                this.addAttr(attr, this.liburl(attr), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
            }
        }
    }

    class CollectionsModule
    extends NativeModule {
        public CollectionsModule() {
            super("collections");
        }

        @NotNull
        private Url abcUrl() {
            return this.liburl("abcs-abstract-base-classes");
        }

        @NotNull
        private Url dequeUrl() {
            return this.liburl("deque-objects");
        }

        @Override
        public void initBindings() {
            ClassType callable = Builtins.this.newClass("Callable", this.table, Builtins.this.objectType, new ClassType[0]);
            callable.table.insert("__call__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("Callable", this.abcUrl(), callable);
            ClassType iterableType = Builtins.this.newClass("Iterable", this.table, Builtins.this.objectType, new ClassType[0]);
            iterableType.table.insert("__next__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            iterableType.table.insert("__iter__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("Iterable", this.abcUrl(), iterableType);
            ClassType Hashable = Builtins.this.newClass("Hashable", this.table, Builtins.this.objectType, new ClassType[0]);
            Hashable.table.insert("__hash__", this.abcUrl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            this.addClass("Hashable", this.abcUrl(), Hashable);
            ClassType Sized = Builtins.this.newClass("Sized", this.table, Builtins.this.objectType, new ClassType[0]);
            Sized.table.insert("__len__", this.abcUrl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            this.addClass("Sized", this.abcUrl(), Sized);
            ClassType containerType = Builtins.this.newClass("Container", this.table, Builtins.this.objectType, new ClassType[0]);
            containerType.table.insert("__contains__", this.abcUrl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            this.addClass("Container", this.abcUrl(), containerType);
            ClassType iteratorType = Builtins.this.newClass("Iterator", this.table, iterableType, new ClassType[0]);
            this.addClass("Iterator", this.abcUrl(), iteratorType);
            ClassType sequenceType = Builtins.this.newClass("Sequence", this.table, Sized, iterableType, containerType);
            sequenceType.table.insert("__getitem__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            sequenceType.table.insert("reversed", this.abcUrl(), Builtins.this.newFunc(sequenceType), Binding.Kind.METHOD);
            sequenceType.table.insert("index", this.abcUrl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            sequenceType.table.insert("count", this.abcUrl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_INT), Binding.Kind.METHOD);
            this.addClass("Sequence", this.abcUrl(), sequenceType);
            ClassType mutableSequence = Builtins.this.newClass("MutableSequence", this.table, sequenceType, new ClassType[0]);
            mutableSequence.table.insert("__setitem__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            mutableSequence.table.insert("__delitem__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("MutableSequence", this.abcUrl(), mutableSequence);
            ClassType setType = Builtins.this.newClass("Set", this.table, Sized, iterableType, containerType);
            setType.table.insert("__getitem__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("Set", this.abcUrl(), setType);
            ClassType mutableSet = Builtins.this.newClass("MutableSet", this.table, setType, new ClassType[0]);
            mutableSet.table.insert("add", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            mutableSet.table.insert("discard", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("MutableSet", this.abcUrl(), mutableSet);
            ClassType mapping = Builtins.this.newClass("Mapping", this.table, Sized, iterableType, containerType);
            mapping.table.insert("__getitem__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("Mapping", this.abcUrl(), mapping);
            ClassType mutableMapping = Builtins.this.newClass("MutableMapping", this.table, mapping, new ClassType[0]);
            mutableMapping.table.insert("__setitem__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            mutableMapping.table.insert("__delitem__", this.abcUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("MutableMapping", this.abcUrl(), mutableMapping);
            ClassType MappingView = Builtins.this.newClass("MappingView", this.table, Sized, new ClassType[0]);
            this.addClass("MappingView", this.abcUrl(), MappingView);
            ClassType KeysView = Builtins.this.newClass("KeysView", this.table, Sized, new ClassType[0]);
            this.addClass("KeysView", this.abcUrl(), KeysView);
            ClassType ItemsView = Builtins.this.newClass("ItemsView", this.table, Sized, new ClassType[0]);
            this.addClass("ItemsView", this.abcUrl(), ItemsView);
            ClassType ValuesView = Builtins.this.newClass("ValuesView", this.table, Sized, new ClassType[0]);
            this.addClass("ValuesView", this.abcUrl(), ValuesView);
            ClassType deque = Builtins.this.newClass("deque", this.table, Builtins.this.objectType, new ClassType[0]);
            for (String n : Builtins.this.list("append", "appendLeft", "clear", "extend", "extendLeft", "rotate")) {
                deque.table.insert(n, this.dequeUrl(), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.METHOD);
            }
            for (String u : Builtins.this.list("__getitem__", "__iter__", "pop", "popleft", "remove")) {
                deque.table.insert(u, this.dequeUrl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            }
            this.addClass("deque", this.dequeUrl(), deque);
            ClassType defaultdict = Builtins.this.newClass("defaultdict", this.table, Builtins.this.objectType, new ClassType[0]);
            defaultdict.table.insert("__missing__", this.liburl("defaultdict-objects"), Builtins.this.newFunc(), Binding.Kind.METHOD);
            defaultdict.table.insert("default_factory", this.liburl("defaultdict-objects"), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("defaultdict", this.liburl("defaultdict-objects"), defaultdict);
            String argh = "namedtuple-factory-function-for-tuples-with-named-fields";
            ClassType namedtuple = Builtins.this.newClass("(namedtuple)", this.table, Builtins.this.BaseTuple, new ClassType[0]);
            namedtuple.table.insert("_fields", this.liburl(argh), new ListType(Builtins.this.analyzer, ((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.ATTRIBUTE);
            this.addFunction("namedtuple", this.liburl(argh), namedtuple);
        }
    }

    class CMathModule
    extends NativeModule {
        public CMathModule() {
            super("cmath");
        }

        @Override
        public void initBindings() {
            this.addFunction("phase", this.liburl("conversions-to-and-from-polar-coordinates"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            this.addFunction("polar", this.liburl("conversions-to-and-from-polar-coordinates"), Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_INT, ((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addFunction("rect", this.liburl("conversions-to-and-from-polar-coordinates"), ((Builtins)Builtins.this).analyzer.TYPE_COMPLEX);
            for (String plf : Builtins.this.list("exp", "log", "log10", "sqrt")) {
                this.addFunction(plf, this.liburl("power-and-logarithmic-functions"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String tf : Builtins.this.list("acos", "asin", "atan", "cos", "sin", "tan")) {
                this.addFunction(tf, this.liburl("trigonometric-functions"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String hf : Builtins.this.list("acosh", "asinh", "atanh", "cosh", "sinh", "tanh")) {
                this.addFunction(hf, this.liburl("hyperbolic-functions"), ((Builtins)Builtins.this).analyzer.TYPE_COMPLEX);
            }
            for (String cf : Builtins.this.list("isinf", "isnan")) {
                this.addFunction(cf, this.liburl("classification-functions"), ((Builtins)Builtins.this).analyzer.TYPE_BOOL);
            }
            for (String c : Builtins.this.list("pi", "e")) {
                this.addAttr(c, this.liburl("constants"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
        }
    }

    class CStringIOModule
    extends NativeModule {
        public CStringIOModule() {
            super("cStringIO");
        }

        @Override
        @NotNull
        protected Url liburl() {
            return Builtins.newLibUrl(Builtins.this.analyzer, "stringio");
        }

        @Override
        @NotNull
        protected Url liburl(String anchor) {
            return Builtins.newLibUrl(Builtins.this.analyzer, "stringio", anchor);
        }

        @Override
        public void initBindings() {
            ClassType StringIO = Builtins.this.newClass("StringIO", this.table, Builtins.this.BaseFile, new ClassType[0]);
            this.addFunction("StringIO", this.liburl(), new InstanceType(Builtins.this.analyzer, StringIO));
            this.addAttr("InputType", this.liburl(), Builtins.this.BaseType);
            this.addAttr("OutputType", this.liburl(), Builtins.this.BaseType);
            this.addAttr("cStringIO_CAPI", this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
        }
    }

    class CPickleModule
    extends NativeModule {
        public CPickleModule() {
            super("cPickle");
        }

        @Override
        @NotNull
        protected Url liburl() {
            return Builtins.newLibUrl(Builtins.this.analyzer, "pickle", "module-cPickle");
        }

        @Override
        public void initBindings() {
            this.addUnknownFuncs("dump", "load", "dumps", "loads");
            this.addClass("PickleError", this.liburl(), Builtins.this.newException("PickleError", this.table));
            ClassType picklingError = Builtins.this.newException("PicklingError", this.table);
            this.addClass("PicklingError", this.liburl(), picklingError);
            this.update("UnpickleableError", this.liburl(), Builtins.this.newClass("UnpickleableError", this.table, picklingError, new ClassType[0]), Binding.Kind.CLASS);
            ClassType unpicklingError = Builtins.this.newException("UnpicklingError", this.table);
            this.addClass("UnpicklingError", this.liburl(), unpicklingError);
            this.update("BadPickleGet", this.liburl(), Builtins.this.newClass("BadPickleGet", this.table, unpicklingError, new ClassType[0]), Binding.Kind.CLASS);
            ClassType pickler = Builtins.this.newClass("Pickler", this.table, Builtins.this.objectType, new ClassType[0]);
            pickler.table.insert("dump", this.liburl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            pickler.table.insert("clear_memo", this.liburl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("Pickler", this.liburl(), pickler);
            ClassType unpickler = Builtins.this.newClass("Unpickler", this.table, Builtins.this.objectType, new ClassType[0]);
            unpickler.table.insert("load", this.liburl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            unpickler.table.insert("noload", this.liburl(), Builtins.this.newFunc(), Binding.Kind.METHOD);
            this.addClass("Unpickler", this.liburl(), unpickler);
        }
    }

    class Bz2Module
    extends NativeModule {
        public Bz2Module() {
            super("bz2");
        }

        @Override
        public void initBindings() {
            ClassType bz2 = Builtins.this.newClass("BZ2File", this.table, Builtins.this.BaseFile, new ClassType[0]);
            this.addClass("BZ2File", this.liburl(), bz2);
            ClassType bz2c = Builtins.this.newClass("BZ2Compressor", this.table, Builtins.this.objectType, new ClassType[0]);
            bz2c.table.insert("compress", Builtins.newLibUrl(Builtins.this.analyzer, "bz2", "sequential-de-compression"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            bz2c.table.insert("flush", Builtins.newLibUrl(Builtins.this.analyzer, "bz2", "sequential-de-compression"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_NONE), Binding.Kind.METHOD);
            this.addClass("BZ2Compressor", Builtins.newLibUrl(Builtins.this.analyzer, "bz2", "sequential-de-compression"), bz2c);
            ClassType bz2d = Builtins.this.newClass("BZ2Decompressor", this.table, Builtins.this.objectType, new ClassType[0]);
            bz2d.table.insert("decompress", Builtins.newLibUrl(Builtins.this.analyzer, "bz2", "sequential-de-compression"), Builtins.this.newFunc(((Builtins)Builtins.this).analyzer.TYPE_STR), Binding.Kind.METHOD);
            this.addClass("BZ2Decompressor", Builtins.newLibUrl(Builtins.this.analyzer, "bz2", "sequential-de-compression"), bz2d);
            this.addFunction("compress", Builtins.newLibUrl(Builtins.this.analyzer, "bz2", "one-shot-de-compression"), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            this.addFunction("decompress", Builtins.newLibUrl(Builtins.this.analyzer, "bz2", "one-shot-de-compression"), ((Builtins)Builtins.this).analyzer.TYPE_STR);
        }
    }

    class BinasciiModule
    extends NativeModule {
        public BinasciiModule() {
            super("binascii");
        }

        @Override
        public void initBindings() {
            this.addStrFuncs("a2b_uu", "b2a_uu", "a2b_base64", "b2a_base64", "a2b_qp", "b2a_qp", "a2b_hqx", "rledecode_hqx", "rlecode_hqx", "b2a_hqx", "b2a_hex", "hexlify", "a2b_hex", "unhexlify");
            this.addNumFuncs("crc_hqx", "crc32");
            this.addClass("Error", this.liburl(), Builtins.this.newException("Error", this.table));
            this.addClass("Incomplete", this.liburl(), Builtins.this.newException("Incomplete", this.table));
        }
    }

    class AudioopModule
    extends NativeModule {
        public AudioopModule() {
            super("audioop");
        }

        @Override
        public void initBindings() {
            this.addClass("error", this.liburl(), Builtins.this.newException("error", this.table));
            this.addStrFuncs("add", "adpcm2lin", "alaw2lin", "bias", "lin2alaw", "lin2lin", "lin2ulaw", "mul", "reverse", "tomono", "ulaw2lin");
            this.addNumFuncs("avg", "avgpp", "cross", "findfactor", "findmax", "getsample", "max", "maxpp", "rms");
            for (String s : Builtins.this.list("adpcm2lin", "findfit", "lin2adpcm", "minmax", "ratecv")) {
                this.addFunction(s, this.liburl(), Builtins.this.newTuple(new Type[0]));
            }
        }
    }

    class ArrayModule
    extends NativeModule {
        public ArrayModule() {
            super("array");
        }

        @Override
        public void initBindings() {
            this.addClass("array", Builtins.newLibUrl(Builtins.this.analyzer, "array", "array"), Builtins.this.BaseArray);
            this.addClass("ArrayType", Builtins.newLibUrl(Builtins.this.analyzer, "array", "ArrayType"), Builtins.this.BaseArray);
        }
    }

    class BuiltinsModule
    extends NativeModule {
        public BuiltinsModule() {
            super("__builtin__");
            Builtins.this.Builtin = this.module = Builtins.this.newModule(this.name);
            this.table = this.module.table;
        }

        @Override
        public void initBindings() {
            String[] builtin_func_num;
            String[] builtin_func_unknown;
            ((Builtins)Builtins.this).analyzer.moduleTable.insert(this.name, this.liburl(), this.module, Binding.Kind.MODULE);
            this.table.addSuper(Builtins.this.BaseModule.table);
            this.addClass("None", Builtins.newLibUrl(Builtins.this.analyzer, "constants"), ((Builtins)Builtins.this).analyzer.TYPE_NONE);
            this.addFunction("bool", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "bool"), ((Builtins)Builtins.this).analyzer.TYPE_BOOL);
            this.addFunction("complex", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "complex"), ((Builtins)Builtins.this).analyzer.TYPE_COMPLEX);
            this.addClass("dict", Builtins.newLibUrl(Builtins.this.analyzer, "stdtypes", "typesmapping"), Builtins.this.BaseDict);
            this.addFunction("file", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "file"), Builtins.this.BaseFileInst);
            this.addFunction("int", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "int"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            this.addFunction("long", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "long"), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            this.addFunction("float", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "float"), ((Builtins)Builtins.this).analyzer.TYPE_FLOAT);
            this.addFunction("list", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "list"), new InstanceType(Builtins.this.analyzer, Builtins.this.BaseList));
            this.addFunction("object", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "object"), new InstanceType(Builtins.this.analyzer, Builtins.this.objectType));
            this.addFunction("str", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "str"), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            this.addFunction("tuple", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "tuple"), new InstanceType(Builtins.this.analyzer, Builtins.this.BaseTuple));
            this.addFunction("type", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "type"), new InstanceType(Builtins.this.analyzer, Builtins.this.BaseType));
            for (String f : builtin_func_unknown = new String[]{"apply", "basestring", "callable", "classmethod", "coerce", "compile", "copyright", "credits", "delattr", "enumerate", "eval", "execfile", "exit", "filter", "frozenset", "getattr", "help", "input", "intern", "iter", "license", "long", "property", "quit", "raw_input", "reduce", "reload", "reversed", "set", "setattr", "slice", "sorted", "staticmethod", "super", "type", "unichr", "unicode"}) {
                this.addFunction(f, Builtins.newLibUrl(Builtins.this.analyzer, "functions.html#" + f), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
            }
            for (String f : builtin_func_num = new String[]{"abs", "all", "any", "cmp", "coerce", "divmod", "hasattr", "hash", "id", "isinstance", "issubclass", "len", "max", "min", "ord", "pow", "round", "sum"}) {
                this.addFunction(f, Builtins.newLibUrl(Builtins.this.analyzer, "functions.html#" + f), ((Builtins)Builtins.this).analyzer.TYPE_INT);
            }
            for (String f : Builtins.this.list("hex", "oct", "repr", "chr")) {
                this.addFunction(f, Builtins.newLibUrl(Builtins.this.analyzer, "functions.html#" + f), ((Builtins)Builtins.this).analyzer.TYPE_STR);
            }
            this.addFunction("dir", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "dir"), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_STR));
            this.addFunction("map", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "map"), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN));
            this.addFunction("range", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "range"), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addFunction("xrange", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "range"), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_INT));
            this.addFunction("buffer", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "buffer"), Builtins.this.newList(((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN));
            this.addFunction("zip", Builtins.newLibUrl(Builtins.this.analyzer, "functions", "zip"), Builtins.this.newList(Builtins.this.newTuple(((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN)));
            for (String f : Builtins.this.list("globals", "vars", "locals")) {
                this.addFunction(f, Builtins.newLibUrl(Builtins.this.analyzer, "functions.html#" + f), Builtins.this.newDict(((Builtins)Builtins.this).analyzer.TYPE_STR, ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN));
            }
            for (String f : Builtins.this.builtin_exception_types) {
                this.addClass(f, Builtins.newDataModelUrl(Builtins.this.analyzer, "types"), Builtins.this.newClass(f, ((Builtins)Builtins.this).analyzer.globaltable, Builtins.this.objectType, new ClassType[0]));
            }
            Builtins.this.BaseException = (ClassType)this.table.lookupType("BaseException");
            for (String f : Builtins.this.list("True", "False")) {
                this.addAttr(f, Builtins.newDataModelUrl(Builtins.this.analyzer, "types"), ((Builtins)Builtins.this).analyzer.TYPE_BOOL);
            }
            this.addAttr("None", Builtins.newDataModelUrl(Builtins.this.analyzer, "types"), ((Builtins)Builtins.this).analyzer.TYPE_NONE);
            this.addFunction("open", Builtins.newTutUrl(Builtins.this.analyzer, "inputoutput.html#reading-and-writing-files"), Builtins.this.BaseFileInst);
            this.addFunction("__import__", Builtins.newLibUrl(Builtins.this.analyzer, "functions"), Builtins.this.newModule("<?>"));
            ((Builtins)Builtins.this).analyzer.globaltable.insert("__builtins__", this.liburl(), this.module, Binding.Kind.ATTRIBUTE);
            ((Builtins)Builtins.this).analyzer.globaltable.putAll(this.table);
        }
    }

    private abstract class NativeModule {
        protected String name;
        @Nullable
        protected ModuleType module;
        @Nullable
        protected State table;

        NativeModule(String name) {
            this.name = name;
            Builtins.this.modules.put(name, this);
        }

        @Nullable
        ModuleType getModule() {
            if (this.module == null) {
                this.createModuleType();
                this.initBindings();
            }
            return this.module;
        }

        protected abstract void initBindings();

        protected void createModuleType() {
            if (this.module == null) {
                this.module = Builtins.this.newModule(this.name);
                this.table = this.module.table;
                ((Builtins)Builtins.this).analyzer.moduleTable.insert(this.name, this.liburl(), this.module, Binding.Kind.MODULE);
            }
        }

        @Nullable
        protected void update(String name, Url url, Type type, Binding.Kind kind) {
            this.table.insert(name, url, type, kind);
        }

        @Nullable
        protected void addClass(String name, Url url, Type type) {
            this.table.insert(name, url, type, Binding.Kind.CLASS);
        }

        @Nullable
        protected void addMethod(String name, Url url, Type type) {
            this.table.insert(name, url, type, Binding.Kind.METHOD);
        }

        @Nullable
        protected void addFunction(String name, Url url, Type type) {
            this.table.insert(name, url, Builtins.this.newFunc(type), Binding.Kind.FUNCTION);
        }

        protected void addFunctions_beCareful(Type type, String ... names) {
            for (String name : names) {
                this.addFunction(name, this.liburl(), type);
            }
        }

        protected void addNoneFuncs(String ... names) {
            this.addFunctions_beCareful(((Builtins)Builtins.this).analyzer.TYPE_NONE, names);
        }

        protected void addNumFuncs(String ... names) {
            this.addFunctions_beCareful(((Builtins)Builtins.this).analyzer.TYPE_INT, names);
        }

        protected void addStrFuncs(String ... names) {
            this.addFunctions_beCareful(((Builtins)Builtins.this).analyzer.TYPE_STR, names);
        }

        protected void addUnknownFuncs(String ... names) {
            for (String name : names) {
                this.addFunction(name, this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
            }
        }

        @Nullable
        protected void addAttr(String name, Url url, Type type) {
            this.table.insert(name, url, type, Binding.Kind.ATTRIBUTE);
        }

        protected void addAttributes_beCareful(Type type, String ... names) {
            for (String name : names) {
                this.addAttr(name, this.liburl(), type);
            }
        }

        protected void addNumAttrs(String ... names) {
            this.addAttributes_beCareful(((Builtins)Builtins.this).analyzer.TYPE_INT, names);
        }

        protected void addStrAttrs(String ... names) {
            this.addAttributes_beCareful(((Builtins)Builtins.this).analyzer.TYPE_STR, names);
        }

        protected void addUnknownAttrs(String ... names) {
            for (String name : names) {
                this.addAttr(name, this.liburl(), ((Builtins)Builtins.this).analyzer.TYPE_UNKNOWN);
            }
        }

        @NotNull
        protected Url liburl() {
            return Builtins.newLibUrl(Builtins.this.analyzer, this.name);
        }

        @NotNull
        protected Url liburl(String anchor) {
            return Builtins.newLibUrl(Builtins.this.analyzer, this.name, anchor);
        }

        @NotNull
        public String toString() {
            return this.module == null ? "<Non-loaded builtin module '" + this.name + "'>" : "<NativeModule:" + this.module + ">";
        }
    }
}

