/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.python;

import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallGraphBuilder;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.pysonar.Analyzer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PythonCallGraphBuilder
implements CallGraphBuilder {
    private final Analyzer analyzer;
    private final Path projectRoot;
    private final CallGraph callGraph;
    private final Set<MethodInfo> methods;
    private boolean callGraphBuilt = false;

    public PythonCallGraphBuilder(Path projectRoot, VulnMethodsConfig config) throws IOException {
        this(projectRoot, new ArrayList<MethodInfo>(), config);
    }

    public PythonCallGraphBuilder(Path projectRoot, Collection<MethodInfo> publicMethods, VulnMethodsConfig config) throws IOException {
        this.projectRoot = projectRoot;
        this.analyzer = new Analyzer(config);
        this.analyzer.stubPublicMethods(projectRoot, new ArrayList<MethodInfo>(publicMethods));
        this.callGraph = new CallGraph();
        this.methods = new HashSet<MethodInfo>();
    }

    @Override
    public void build() throws IOException {
        if (this.callGraphBuilt) {
            return;
        }
        this.callGraphBuilt = true;
        try {
            this.analyzer.analyzeCallGraph(this.projectRoot);
        }
        finally {
            this.analyzer.close();
        }
        for (CallSite callSite : this.analyzer.state.getCallSites()) {
            this.callGraph.addEdge(callSite);
        }
        this.methods.addAll(this.analyzer.state.getMethods());
    }

    @Override
    public Set<MethodInfo> getMethodsDefined() {
        return this.methods;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

