/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.InstantiatedTypesMethodVisitor;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.ReflectionMethodVisitor;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class ClassHierarchyClassVisitor
extends ClassVisitor {
    private final int version;
    private final String className;
    private final Set<String> instantiatedTypes = new HashSet<String>();
    private final HashSet<MethodInfo> methods = new HashSet();
    private boolean isInterface = false;
    private Optional<String> superName = Optional.empty();
    private Set<String> implementedInterfaces = new HashSet<String>();
    private final Set<Type> reflectedClasses = new HashSet<Type>();
    private final Set<String> reflectedMethodNames = new HashSet<String>();

    ClassHierarchyClassVisitor(int version, String className) {
        super(version);
        this.version = version;
        this.className = className;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if ((access & 0x200) == 512) {
            this.isInterface = true;
        }
        this.superName = Optional.ofNullable(superName);
        for (String i : interfaces) {
            this.implementedInterfaces.add(i);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodInfo method = new MethodInfo(this.className, name, Utils.stripReturnType(desc), Utils.attributesFromAccess(access));
        this.methods.add(method);
        return new InstantiatedTypesMethodVisitor(this.version, this.instantiatedTypes, new ReflectionMethodVisitor(this.version, this.reflectedClasses, this.reflectedMethodNames));
    }

    public void visitEnd() {
        super.visitEnd();
    }

    public ClassInfo getClassInfo() {
        return new ClassInfo(this.className, this.methods, this.superName, this.isInterface, this.implementedInterfaces, this.instantiatedTypes, this.reflectedClasses, this.reflectedMethodNames);
    }
}

