/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.yarn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.natives.parsing.NPMPackage;
import com.sourceclear.engine.component.yarn.CustomYarnLockParser;
import com.sourceclear.engine.component.yarn.YarnLockFile;
import com.sourceclear.engine.component.yarn.YarnPackage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnLockParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnLockParser.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static YarnLockFile parse(File yarnLockFile) throws CollectionException {
        File yarnParseDotJSFile = YarnLockParser.getYarnParseDotJSFile();
        LOGGER.debug("yarnParseDotJSFile: {}", (Object)yarnParseDotJSFile);
        if (Files.exists(yarnParseDotJSFile.toPath(), new LinkOption[0])) {
            LOGGER.debug("{} exists. Using this to parse lock file.", (Object)yarnParseDotJSFile);
            String parseOutput = YarnLockParser.launchParseLockFileProcess(yarnParseDotJSFile, yarnLockFile);
            return YarnLockParser.parseHelper(parseOutput);
        }
        LOGGER.debug("{} does not exist. Using custom parser.", (Object)yarnParseDotJSFile);
        return YarnLockParser.parseCustom(yarnLockFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static YarnLockFile parseCustom(File yarnLockFile) throws CollectionException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(yarnLockFile));){
            List<YarnPackage> yarnPackages = CustomYarnLockParser.parse(is);
            HashMap<String, YarnPackage> packages = new HashMap<String, YarnPackage>();
            for (YarnPackage yarnPackage : yarnPackages) {
                packages.put(yarnPackage.getDeclaration(), yarnPackage);
            }
            YarnLockFile yarnLockFile2 = new YarnLockFile(packages);
            return yarnLockFile2;
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "Couldn't read " + yarnLockFile.getAbsolutePath().toString());
        }
    }

    static YarnLockFile parseHelper(String parseOutput) throws CollectionException {
        try {
            JsonNode jsonNode = MAPPER.readTree(parseOutput);
            LOGGER.debug("converted parseOutput to jsonNode");
            HashMap<String, YarnPackage> yarnPackages = new HashMap<String, YarnPackage>();
            Iterator iter = jsonNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                YarnPackage.Builder builder = new YarnPackage.Builder();
                String declaration = (String)entry.getKey();
                builder.withDeclaration(declaration);
                JsonNode pkgDetailsNode = (JsonNode)entry.getValue();
                Iterator iter2 = pkgDetailsNode.fields();
                while (iter2.hasNext()) {
                    Map.Entry pkgDetailsEntry = (Map.Entry)iter2.next();
                    if (((String)pkgDetailsEntry.getKey()).equals("version")) {
                        builder.withVersion(((JsonNode)pkgDetailsEntry.getValue()).asText());
                        continue;
                    }
                    if (((String)pkgDetailsEntry.getKey()).equals("resolved")) {
                        builder.withResolved(((JsonNode)pkgDetailsEntry.getValue()).asText());
                        continue;
                    }
                    if (!((String)pkgDetailsEntry.getKey()).toLowerCase().endsWith("dependencies")) continue;
                    Map depsMap = (Map)MAPPER.readValue(((JsonNode)pkgDetailsEntry.getValue()).toString(), (TypeReference)new TypeReference<Map<String, String>>(){});
                    List<NPMPackage> deps = depsMap.entrySet().stream().map(nameVersion -> new NPMPackage((String)nameVersion.getKey(), (String)nameVersion.getValue())).collect(Collectors.toList());
                    if (((String)pkgDetailsEntry.getKey()).equals("dependencies")) {
                        builder.withDependencies(deps);
                        continue;
                    }
                    if (((String)pkgDetailsEntry.getKey()).equals("devDependencies")) {
                        builder.withDevDependencies(deps);
                        continue;
                    }
                    if (((String)pkgDetailsEntry.getKey()).equals("optionalDependencies")) {
                        builder.withOptionalDependencies(deps);
                        continue;
                    }
                    if (!((String)pkgDetailsEntry.getKey()).equals("peerDependencies")) continue;
                    builder.withPeerDependencies(deps);
                }
                yarnPackages.put(declaration, builder.build());
            }
            return new YarnLockFile(yarnPackages);
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "Error converting parseOutput with JSON_MAPPER: " + e.getMessage()).initCause(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String launchParseLockFileProcess(File yarnParseDotJSFile, File yarnLockFile) throws CollectionException {
        String snippet = YarnLockParser.getJavaScriptSnippet(yarnParseDotJSFile, yarnLockFile);
        LOGGER.debug("snippet: {}", (Object)snippet);
        List<String> commands = Arrays.asList("node", "-e", snippet);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(commands);
        processBuilder.redirectErrorStream(true);
        LOGGER.debug("Launching process: {}", (Object)Joiner.on((String)" ").join(commands));
        try {
            File tmpParseOutputFile = File.createTempFile("tmpParseOutput", ".yml");
            tmpParseOutputFile.deleteOnExit();
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(tmpParseOutputFile));
            LOGGER.debug("redirecting process output to {}", (Object)tmpParseOutputFile.getAbsolutePath());
            Process process = processBuilder.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            int rc = process.waitFor();
            try (InputStream inputStream = Files.newInputStream(tmpParseOutputFile.toPath(), new OpenOption[0]);){
                String output = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                if (rc != 0) {
                    LOGGER.debug("Parse yarn.lock error: {}", (Object)output);
                    throw new CollectionException(CollectionErrorType.PARSE, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", output);
                }
                String string = output;
                return string;
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug("Exception occurred when launching process: {}", (Object)e.getMessage());
            throw new CollectionException(CollectionErrorType.IO, "An IOException/InterruptedException occurred while parsing yarn.lock.", e.getMessage()).initCause(e);
        }
    }

    private static File getYarnParseDotJSFile() throws CollectionException {
        String output;
        List<String> whichYarnCommand = Arrays.asList("which", "yarn");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(whichYarnCommand);
        processBuilder.redirectErrorStream(true);
        LOGGER.debug("Launching process: {}", (Object)Joiner.on((String)" ").join(whichYarnCommand));
        try {
            Process process = processBuilder.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            int rc = process.waitFor();
            output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            if (rc != 0) {
                LOGGER.debug("Process exited with a non-zero value. Output/Error: {}", (Object)output);
                throw new CollectionException(CollectionErrorType.PARSE, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", output);
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug("Exception occurred when launching process: {}", (Object)e.getMessage());
            throw new CollectionException(CollectionErrorType.IO, "An IOException/InterruptedException occurred while trying to parse yarn.lock.", e.getMessage()).initCause(e);
        }
        Path yarnBinPath = Paths.get(output.trim(), new String[0]);
        try {
            Path yarnBinRealPathFolder = yarnBinPath.toRealPath(new LinkOption[0]).getParent();
            LOGGER.debug("yarnBinRealPathFolder: {}", (Object)yarnBinRealPathFolder);
            Path yarnParseDotJSPath = yarnBinRealPathFolder.resolve("../lib/lockfile/parse.js");
            return yarnParseDotJSPath.toFile();
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.SYSTEM, "Unable to resolve yarn bin path.", e.getMessage()).initCause(e);
        }
    }

    private static String getJavaScriptSnippet(File yarnParseDotJSFile, File yarnLockFile) {
        String snippet = "var fs = require('fs');" + String.format("var parse = require('%s').default;", yarnParseDotJSFile.getAbsolutePath()) + String.format("var contents = fs.readFileSync('%s', 'utf8');", yarnLockFile.getAbsolutePath()) + "console.log(JSON.stringify(parse(contents)));";
        return snippet;
    }
}

