/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.yarn;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.natives.parsing.NPMPackage;
import com.sourceclear.engine.component.yarn.YarnPackage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomYarnLockParser {
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String VERSION_LINE_PREFIX = "version";
    private static final String URL_LINE_PREFIX = "resolved";
    private static final String DEPENDENCIES_PREFIX = "dependencies:";
    private static final Pattern QUOTES_PATTERN = Pattern.compile("\"(.+?)\"");

    public static List<YarnPackage> parse(InputStream yarnLockFile) throws CollectionException {
        ArrayList<YarnPackage> pkgsList = new ArrayList<YarnPackage>();
        String contentsInYaml = CustomYarnLockParser.convertToValidYaml(yarnLockFile);
        try {
            JsonNode jsonNode = YAML_MAPPER.readTree(contentsInYaml);
            Iterator iter = jsonNode.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                JsonNode detailsNode = (JsonNode)entry.getValue();
                Set<String> declarations = CustomYarnLockParser.getPackageDeclarationsFromStringOrThrowEx((String)entry.getKey());
                List<NPMPackage> dependencies = CustomYarnLockParser.convertToPackageList(detailsNode.get("dependencies"));
                List<NPMPackage> optionalDependencies = CustomYarnLockParser.convertToPackageList(detailsNode.get("optionalDependencies"));
                List<NPMPackage> peerDependencies = CustomYarnLockParser.convertToPackageList(detailsNode.get("peerDependencies"));
                List<NPMPackage> devDependencies = CustomYarnLockParser.convertToPackageList(detailsNode.get("devDependencies"));
                JsonNode versionNode = detailsNode.get(VERSION_LINE_PREFIX);
                JsonNode resolvedNode = detailsNode.get(URL_LINE_PREFIX);
                String version = versionNode == null ? null : versionNode.asText();
                String resolved = resolvedNode == null ? null : resolvedNode.asText();
                for (String declaration : declarations) {
                    pkgsList.add(new YarnPackage.Builder().withDeclaration(declaration).withVersion(version).withResolved(resolved).withDependencies(dependencies).withOptionalDependencies(optionalDependencies).withPeerDependencies(peerDependencies).withDevDependencies(devDependencies).build());
                }
            }
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "IOException occurred with custom yarn.lock parser.", ex.getMessage()).initCause(ex);
        }
        return pkgsList;
    }

    public static String convertToValidYaml(InputStream yarnLockFile) throws CollectionException {
        try {
            StringBuilder finalContentsBuilder = new StringBuilder();
            ArrayList<String> yarnLockOriginalContents = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(yarnLockFile));
            String inputLine = reader.readLine();
            while (inputLine != null) {
                yarnLockOriginalContents.add(inputLine);
                inputLine = reader.readLine();
            }
            for (String line : yarnLockOriginalContents) {
                String lineToAdd;
                int indentationLevel = CustomYarnLockParser.getIndentationLevel(line);
                String trimmedLine = line.trim();
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) {
                    lineToAdd = line;
                } else if (indentationLevel == 0) {
                    int endOfDeclarations = CustomYarnLockParser.getEndOfDeclaration(line);
                    lineToAdd = CustomYarnLockParser.addCharAtIndicesOfString('\'', line, Sets.newHashSet((Object[])new Integer[]{0, endOfDeclarations}));
                } else if (indentationLevel == 2) {
                    lineToAdd = trimmedLine.startsWith(VERSION_LINE_PREFIX) ? line.replaceFirst(VERSION_LINE_PREFIX, "version:") : (trimmedLine.startsWith(URL_LINE_PREFIX) ? line.replaceFirst(URL_LINE_PREFIX, "resolved:") : (trimmedLine.startsWith(DEPENDENCIES_PREFIX) ? line : line.replaceFirst("^(\\s+[^\\s:]+) ", "$1: ")));
                } else if (indentationLevel == 4) {
                    int sep = line.indexOf(32, 4);
                    lineToAdd = CustomYarnLockParser.addCharAtIndicesOfString(':', line, Sets.newHashSet((Object[])new Integer[]{sep}));
                } else {
                    throw new CollectionException(CollectionErrorType.PARSE, String.format("Unexpected level of indentation: %s. Line: '%s'.", indentationLevel, line));
                }
                finalContentsBuilder.append(lineToAdd + "\n");
            }
            return finalContentsBuilder.toString();
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "IOException occurred when parsing yarn.lock.", e.getMessage()).initCause(e);
        }
    }

    private static List<NPMPackage> convertToPackageList(JsonNode dependenciesNode) {
        ArrayList<NPMPackage> deps = new ArrayList<NPMPackage>();
        if (dependenciesNode != null) {
            dependenciesNode.fields().forEachRemaining(stringJsonNodeEntry -> deps.add(new NPMPackage((String)stringJsonNodeEntry.getKey(), ((JsonNode)stringJsonNodeEntry.getValue()).asText())));
        }
        return deps;
    }

    private static String addCharAtIndicesOfString(char c, String originalStr, Set<Integer> indices) {
        StringBuilder modifiedLineBuilder = new StringBuilder();
        for (int i = 0; i < originalStr.length(); ++i) {
            if (indices.contains(i)) {
                modifiedLineBuilder.append(c);
            }
            modifiedLineBuilder.append(originalStr.charAt(i));
        }
        return modifiedLineBuilder.toString();
    }

    private static Set<String> getPackageDeclarationsFromStringOrThrowEx(String str) throws CollectionException {
        HashSet<String> names = new HashSet<String>();
        String trimmedString = str.trim();
        int jump = 1;
        for (int i = 0; i < trimmedString.length(); i += jump) {
            int j;
            if (trimmedString.charAt(i) == '\"') {
                int indexOfNextQuote = trimmedString.indexOf(34, i + 1);
                names.add(CustomYarnLockParser.getValueBetweenQuotes(trimmedString.substring(i, indexOfNextQuote + 1)));
                jump = indexOfNextQuote - i + 1;
                continue;
            }
            if (trimmedString.charAt(i) == ',' || trimmedString.charAt(i) == ' ') {
                jump = 1;
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (j = i; j < trimmedString.length() && trimmedString.charAt(j) != ','; ++j) {
                sb.append(trimmedString.charAt(j));
            }
            names.add(sb.toString().trim());
            jump = j - i;
        }
        return names;
    }

    private static int getEndOfDeclaration(String line) throws CollectionException {
        int indexOfColon = -1;
        int jump = 1;
        for (int i = 0; i < line.length(); i += jump) {
            char currentChar = line.charAt(i);
            if (currentChar == '\"') {
                int indexOfNextQuote = line.indexOf(34, i + 1);
                if (indexOfNextQuote == -1) {
                    throw new CollectionException(CollectionErrorType.PARSE, String.format("No matching closing quotes. Line: '%s'.", line));
                }
                jump = indexOfNextQuote - i + 1;
                continue;
            }
            if (currentChar == ':') {
                indexOfColon = i;
                break;
            }
            jump = 1;
        }
        if (indexOfColon == -1) {
            throw new CollectionException(CollectionErrorType.PARSE, String.format("Unable to find a colon for end of declaration sign. Line: '%s'.", line));
        }
        return indexOfColon;
    }

    private static String getValueBetweenQuotes(String str) {
        Matcher matcher = QUOTES_PATTERN.matcher(str);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "";
    }

    private static int getIndentationLevel(String line) {
        int spaces = 0;
        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
            ++spaces;
        }
        return spaces;
    }
}

