/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.cocoapods.PodLockFile;
import com.sourceclear.engine.component.cocoapods.PodLockFileParser;
import com.sourceclear.engine.component.collectors.CocoaPodsNativeCollector;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class PodfileDotLockQuickscanCollector
implements QuickscanCollector {
    private Path lockfile;

    @Override
    @Nonnull
    public String getName() {
        return "Podfile.lock quickscan";
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        PodLockFile podLockFile;
        if (this.lockfile == null) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, String.format("'%s' does not support this project but evidence collection was attempted.", this.getName()));
        }
        try (InputStream inputStream = Files.newInputStream(this.lockfile, new OpenOption[0]);){
            podLockFile = PodLockFileParser.parse(inputStream);
        }
        catch (Exception e) {
            throw new CollectionException(CollectionErrorType.PARSE, String.format("Unable to parse %s.", this.lockfile));
        }
        LibraryGraph graph = CocoaPodsNativeCollector.podLockFileToGraph(podLockFile);
        return new LibraryGraphContainer.Builder().withGraph(graph).build();
    }

    @Override
    public boolean supports(File file) {
        Optional<Path> lockfilePath = CollectorUtils.isOrContainFile(file.toPath(), "Podfile.lock");
        this.lockfile = lockfilePath.isPresent() ? (Path)lockfilePath.get() : null;
        return lockfilePath.isPresent();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

