/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.NPMNativeCollector;
import com.sourceclear.engine.component.natives.parsing.NPMTreeParser;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class NPMQuickscanCollector
implements QuickscanCollector {
    @Override
    @Nonnull
    public String getName() {
        return "NPM Quickscan";
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        try {
            Path path = scanTarget.toPath();
            Path lockfile = NPMNativeCollector.resolveLockfile(path);
            String content = Joiner.on((String)"").join(Files.readAllLines(lockfile, Charset.defaultCharset()));
            LibraryGraph graph = NPMTreeParser.parse(scanTarget.getName(), content);
            return new LibraryGraphContainer.Builder().withGraph(graph).build();
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }

    @Override
    public boolean supports(File file) {
        return NPMNativeCollector.isLockfileInPath(file.toPath());
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

