/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.composer.ComposerCollectorUtils;
import com.sourceclear.engine.component.composer.ComposerLock;
import com.sourceclear.engine.component.composer.ComposerParser;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposerLockQuickscanCollector
implements QuickscanCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerLockQuickscanCollector.class);
    private final String COMPOSER_JSON = "composer.json";
    private final String COMPOSER_LOCK = "composer.lock";

    @Override
    @Nonnull
    public String getName() {
        return "Composer Quickscan";
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        Path scanPath = scanTarget.toPath();
        Path composerLockFile = Files.isDirectory(scanPath, new LinkOption[0]) ? scanPath.resolve("composer.lock") : scanPath;
        String filename = composerLockFile.getFileName().toString();
        String scope = Strings.nullToEmpty((String)((String)attributes.get((Object)"SCOPE"))).trim();
        boolean noDev = "--no-dev".equals(scope);
        ComposerLock composerLock = ComposerParser.parseComposerLockFile(composerLockFile);
        Path possibleComposerJson = Files.isDirectory(scanPath, new LinkOption[0]) ? scanPath.resolve("composer.json") : scanPath.getParent().resolve("composer.json");
        Set<LibraryGraph> graphs = ComposerCollectorUtils.libraryGraphsFromLockFileAndJsonIfItExists(LOGGER, filename, noDev, composerLock, possibleComposerJson);
        LibraryGraph rootGraph = new LibraryGraph.Builder().withFilename(filename).withDirects(graphs).build();
        return new LibraryGraphContainer.Builder().withGraph(rootGraph).build();
    }

    @Override
    public boolean supports(File file) {
        Path path = file.toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return Files.exists(path.resolve("composer.lock"), new LinkOption[0]);
        }
        return Files.exists(path, new LinkOption[0]) && path.getFileName().toString().equals("composer.lock");
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

