/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.linuxso;

import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SOFileAnalyzer {
    private static final Pattern DOT_SO_SEMVER_PATTERN = Pattern.compile("(.+\\.so)\\.(.+)");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getSHA2(Path file) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            String string = DigestUtils.sha256Hex((InputStream)inputStream);
            return string;
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "An error occurred when getting library sha2 hashes.", ex.getMessage()).initCause(ex);
        }
    }

    static Pair<String, String> splitSharedLibNameAndVersion(Path file) {
        String sharedLibFilename = file.getFileName().toString();
        Matcher matcher = DOT_SO_SEMVER_PATTERN.matcher(sharedLibFilename);
        if (matcher.find()) {
            return Pair.of((Object)matcher.group(1), (Object)matcher.group(2));
        }
        return Pair.of((Object)sharedLibFilename, (Object)"");
    }

    static LibraryGraph buildGraph(String coord1, String sha2, String version, String relativeFileName) {
        Coords.Builder coordsBuilder = new Coords.Builder().withCoordinateType(CoordinateType.SO).withCoordinate1(coord1);
        if (StringUtils.isNotBlank((CharSequence)version)) {
            coordsBuilder.withVersion(version);
        }
        return new LibraryGraph.Builder().withFilename(relativeFileName).withCoords(coordsBuilder.build()).withSha2(sha2).build();
    }

    public static LibraryGraph analyze(Path file, String relativeFileName) throws CollectionException {
        String sha2 = SOFileAnalyzer.getSHA2(file);
        Pair<String, String> nameAndVersion = SOFileAnalyzer.splitSharedLibNameAndVersion(file);
        return SOFileAnalyzer.buildGraph((String)nameAndVersion.getLeft(), sha2, (String)nameAndVersion.getRight(), relativeFileName);
    }
}

