/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.gem;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.engine.component.gem.GemSpec;
import com.sourceclear.engine.component.gem.Source;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GemfileDotLock {
    private final ImmutableList<GemSpec> gems;
    private final ImmutableMultimap<String, GemSpec> gemMap;
    private final ImmutableList<String> platforms;
    private final ImmutableMap<Coordinates, Integer> dependencies;
    private final Map<Coordinates, LibraryGraph> graphCache = new HashMap<Coordinates, LibraryGraph>();

    public GemfileDotLock(Builder builder) {
        ImmutableList.Builder gemsBuilder = ImmutableList.builder();
        for (Source source : builder.sources) {
            gemsBuilder.addAll(source.getGems());
        }
        this.gems = gemsBuilder.build();
        this.platforms = ImmutableList.copyOf((Collection)builder.platforms);
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        for (GemSpec gem : this.gems) {
            mapBuilder.put((Object)gem.getCoordinates().getCoordinate1(), (Object)gem);
        }
        this.gemMap = mapBuilder.build();
        if (builder.dependencies.isEmpty() && !this.gemMap.isEmpty()) {
            ArrayList heads = new ArrayList(this.gemMap.keySet());
            for (GemSpec gem : this.gems) {
                ImmutableSet<Coordinates> trans = gem.getTransitives();
                for (Coordinates tran : trans) {
                    heads.remove(tran.getCoordinate1());
                }
            }
            for (String coord1 : heads) {
                ImmutableCollection gemSpecs = this.gemMap.get((Object)coord1);
                for (GemSpec gemSpec : gemSpecs) {
                    builder.dependencies.put(gemSpec.getCoordinates(), gemSpec.getLineNumber());
                }
            }
        }
        this.dependencies = ImmutableMap.copyOf((Map)builder.dependencies);
    }

    public LibraryGraph graph() {
        LibraryGraph.Builder builder = new LibraryGraph.Builder().withFilename("Gemfile.lock");
        for (Map.Entry entry : this.dependencies.entrySet()) {
            LibraryGraph lib = this.buildComponent((Coordinates)entry.getKey(), (Integer)entry.getValue());
            if (lib == null) continue;
            builder.withDirect(lib);
        }
        return builder.build();
    }

    private LibraryGraph buildComponent(Coordinates c, Integer lineNumber) {
        if (this.graphCache.containsKey(c)) {
            return this.graphCache.get(c);
        }
        ImmutableCollection specs = this.gemMap.get((Object)c.getCoordinate1());
        if (specs == null || specs.isEmpty()) {
            return null;
        }
        ImmutableList gemSpecs = specs.asList();
        GemSpec first = (GemSpec)gemSpecs.get(0);
        LibraryGraph.Builder builder = new LibraryGraph.Builder().withLineNumber(lineNumber).withFilename("Gemfile.lock").withCoords(new Coords.Builder().withCoordinateType(CoordinateType.GEM).withCoordinate1(first.getCoordinates().getCoordinate1()).withVersion(first.getCoordinates().getVersion()).build());
        for (GemSpec spec : gemSpecs) {
            for (Coordinates child : spec.getTransitives()) {
                LibraryGraph lib = this.buildComponent(child, lineNumber);
                if (lib == null) continue;
                builder.withDirect(lib);
            }
        }
        LibraryGraph graph = builder.build();
        this.graphCache.put(c, graph);
        return graph;
    }

    public ImmutableList<GemSpec> getGems() {
        return this.gems;
    }

    public ImmutableList<String> getPlatforms() {
        return this.platforms;
    }

    public ImmutableMap<Coordinates, Integer> getDependencies() {
        return this.dependencies;
    }

    static class Builder {
        private List<Source> sources = new ArrayList<Source>();
        private List<String> platforms = Lists.newArrayList();
        private Map<Coordinates, Integer> dependencies = Maps.newHashMap();

        Builder() {
        }

        public Builder withSource(Source source) {
            this.sources.add(source);
            return this;
        }

        public Builder withPlatform(String platform) {
            this.platforms.add(platform);
            return this;
        }

        public Builder withDependencies(Coordinates coordinates, Integer lineNumber) {
            this.dependencies.put(coordinates, lineNumber);
            return this;
        }

        public GemfileDotLock build() {
            return new GemfileDotLock(this);
        }
    }
}

