/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.dotnet;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.component.dotnet.LibraryVersion;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ProjectTarget {
    private final String dotNetFrameworkVersion;
    private final LibraryVersion libraryVersion;
    private final String type;
    private final Set<LibraryVersion> dependencies;

    public ProjectTarget(String dotNetFrameworkVersion, LibraryVersion libraryVersion, String type, Set<LibraryVersion> dependencies) {
        this.dotNetFrameworkVersion = dotNetFrameworkVersion;
        this.libraryVersion = libraryVersion;
        this.type = type;
        this.dependencies = dependencies == null ? new HashSet() : dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectTarget that = (ProjectTarget)o;
        return Objects.equals(this.dotNetFrameworkVersion, that.dotNetFrameworkVersion) && Objects.equals(this.libraryVersion, that.libraryVersion) && Objects.equals(this.type, that.type) && Objects.equals(this.dependencies, that.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.dotNetFrameworkVersion, this.libraryVersion, this.type, this.dependencies);
    }

    public String getDotNetFrameworkVersion() {
        return this.dotNetFrameworkVersion;
    }

    public LibraryVersion getLibraryVersion() {
        return this.libraryVersion;
    }

    public String getType() {
        return this.type;
    }

    public ImmutableSet<LibraryVersion> getDependencies() {
        return ImmutableSet.copyOf(this.dependencies);
    }
}

