/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.dotnet;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.component.dotnet.LibraryVersion;
import com.sourceclear.engine.component.dotnet.ProjectTarget;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectAssetsJSON {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Map<String, Set<ProjectTarget>> targets = new HashMap<String, Set<ProjectTarget>>();
    private Set<String> directs = new HashSet<String>();

    public static ProjectAssetsJSON fromFile(Path file) throws IOException {
        return (ProjectAssetsJSON)MAPPER.readValue(file.toFile(), ProjectAssetsJSON.class);
    }

    @JsonProperty(value="targets")
    private void setTargets(Map<String, Map<String, Map<String, Object>>> rawTargetMap) {
        this.targets = rawTargetMap.entrySet().stream().flatMap(entry -> {
            String dotNetVersion = (String)entry.getKey();
            Map libraryTargetMap = (Map)entry.getValue();
            return libraryTargetMap.entrySet().stream().map(stringMapEntry -> {
                String libraryNameAndVersion = (String)stringMapEntry.getKey();
                Map details = (Map)stringMapEntry.getValue();
                String[] tokens = libraryNameAndVersion.split("/");
                LibraryVersion libraryVersion = new LibraryVersion(tokens[0], tokens[1]);
                String type = (String)details.get("type");
                Map depsMap = (Map)details.get("dependencies");
                HashSet<LibraryVersion> dependencies = new HashSet<LibraryVersion>();
                if (depsMap != null) {
                    dependencies.addAll(depsMap.entrySet().stream().map(nameAndVersionEntry -> new LibraryVersion((String)nameAndVersionEntry.getKey(), (String)nameAndVersionEntry.getValue())).collect(Collectors.toSet()));
                }
                return new AbstractMap.SimpleEntry<String, Set<ProjectTarget>>(libraryVersion.getName(), Collections.singleton(new ProjectTarget(dotNetVersion, libraryVersion, type, dependencies)));
            });
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (set1, set2) -> {
            HashSet combined = new HashSet(set1);
            combined.addAll(set2);
            return combined;
        }));
    }

    @JsonProperty(value="project")
    private void setDirects(Map<String, Object> rawProjectMap) {
        Map dependenciesMap = (Map)rawProjectMap.get("dependencies");
        if (dependenciesMap != null) {
            this.directs.addAll(dependenciesMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet()));
        }
        Map frameworksMap = (Map)rawProjectMap.get("frameworks");
        frameworksMap.forEach((dotNetVersion, value) -> {
            Map frameworkDependenciesMap = (Map)value;
            Map nestedDependenciesMap = (Map)frameworkDependenciesMap.get("dependencies");
            if (nestedDependenciesMap != null) {
                this.directs.addAll(nestedDependenciesMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet()));
            }
        });
    }

    public ImmutableMap<String, Set<ProjectTarget>> getTargets() {
        return ImmutableMap.copyOf(this.targets);
    }

    public ImmutableSet<String> getDirects() {
        return ImmutableSet.copyOf(this.directs);
    }
}

