/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.composer;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.engine.component.composer.ComposerLockPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComposerLock {
    private static String PROD_SCOPE = "packages";
    private static String DEV_SCOPE = "packages-dev";
    private List<ComposerLockPackage> prodPackages = new ArrayList<ComposerLockPackage>();
    private List<ComposerLockPackage> devPackages = new ArrayList<ComposerLockPackage>();

    @JsonProperty(value="packages")
    private void getProdPackages(List<Map<String, Object>> packages) {
        this.prodPackages = new ArrayList<ComposerLockPackage>(packages.size());
        for (Map<String, Object> prodPackage : packages) {
            ComposerLockPackage composerLockPackage = new ComposerLockPackage((String)prodPackage.get("name"), (String)prodPackage.get("version"), PROD_SCOPE);
            composerLockPackage.addAllToRequires(this.getDependenciesByType(prodPackage, "require"));
            composerLockPackage.addAllToRequireDevs(this.getDependenciesByType(prodPackage, "require-dev"));
            this.prodPackages.add(composerLockPackage);
        }
    }

    @JsonProperty(value="packages-dev")
    private void getDevPackages(List<Map<String, Object>> packages) {
        this.devPackages = new ArrayList<ComposerLockPackage>(packages.size());
        for (Map<String, Object> devPackage : packages) {
            ComposerLockPackage composerLockPackage = new ComposerLockPackage((String)devPackage.get("name"), (String)devPackage.get("version"), DEV_SCOPE);
            composerLockPackage.addAllToRequires(this.getDependenciesByType(devPackage, "require"));
            composerLockPackage.addAllToRequireDevs(this.getDependenciesByType(devPackage, "require-dev"));
            this.devPackages.add(composerLockPackage);
        }
    }

    private Map<String, String> getDependenciesByType(Map<String, Object> packageDetailsMap, String type) {
        if (packageDetailsMap.containsKey(type)) {
            Object object = packageDetailsMap.get(type);
            Map map = (Map)object;
            return map;
        }
        return new HashMap<String, String>();
    }

    public List<ComposerLockPackage> getAllPackages() {
        ArrayList<ComposerLockPackage> allPackages = new ArrayList<ComposerLockPackage>(this.prodPackages.size() + this.devPackages.size());
        allPackages.addAll(this.prodPackages);
        allPackages.addAll(this.devPackages);
        return allPackages;
    }

    public List<ComposerLockPackage> getProdPackages() {
        return this.prodPackages;
    }

    public List<ComposerLockPackage> getDevPackages() {
        return this.devPackages;
    }

    @VisibleForTesting
    void addAllProdPackages(List<ComposerLockPackage> composerLockPackages) {
        this.prodPackages.addAll(composerLockPackages);
    }
}

