/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.composer;

import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.composer.ComposerJson;
import com.sourceclear.engine.component.composer.ComposerLock;
import com.sourceclear.engine.component.composer.ComposerLockPackage;
import com.sourceclear.engine.component.composer.ComposerParser;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class ComposerCollectorUtils {
    public static Set<LibraryGraph> libraryGraphsFromLockFileAndJsonIfItExists(Logger logger, String filename, boolean noDev, ComposerLock composerLock, Path composerJsonFile) throws CollectionException {
        HashSet<LibraryGraph> graphs = new HashSet<LibraryGraph>();
        Set<String> directsInComposerJson = ComposerCollectorUtils.maybeGetDirectsFromComposerJson(logger, noDev, composerJsonFile);
        Map<String, Coords> composerLockPackageCoordsMap = ComposerParser.composerLockPackagesToCoords(noDev, composerLock);
        if (directsInComposerJson.isEmpty()) {
            logger.debug("no direct dependencies found in composer.json. Either file does not exist or file is empty. Returning all packages found in composer.lock as directs.");
            graphs.addAll(ComposerParser.coordsToDirects(filename, composerLockPackageCoordsMap.values()));
        } else {
            Map<String, ComposerLockPackage> composerLockPackagesMap = ComposerParser.composerLockPackagesToMap(noDev, composerLock);
            graphs.addAll(ComposerParser.composerPackagesToGraphs(noDev, filename, directsInComposerJson, composerLockPackageCoordsMap, composerLockPackagesMap, new HashSet<String>()));
        }
        return graphs;
    }

    private static Set<String> maybeGetDirectsFromComposerJson(Logger logger, boolean noDev, Path composerJsonFile) throws CollectionException {
        HashSet<String> directPackageNames = new HashSet<String>();
        if (Files.exists(composerJsonFile, new LinkOption[0])) {
            ComposerJson composerJson = ComposerParser.parseComposerJsonFile(composerJsonFile);
            directPackageNames.addAll((Collection<String>)composerJson.getRequires().keySet());
            if (!noDev) {
                directPackageNames.addAll((Collection<String>)composerJson.getRequireDevs().keySet());
            }
        } else {
            logger.debug("{} does not exist.", (Object)composerJsonFile);
        }
        return directPackageNames;
    }
}

